/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.internal;

import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.inject.Provider;
import org.apache.hadoop.shaded.com.google.inject.internal.Errors;
import org.apache.hadoop.shaded.com.google.inject.internal.ErrorsException;
import org.apache.hadoop.shaded.com.google.inject.internal.InternalContext;
import org.apache.hadoop.shaded.com.google.inject.internal.InternalFactory;
import org.apache.hadoop.shaded.com.google.inject.spi.Dependency;

final class InternalFactoryToProviderAdapter<T>
implements InternalFactory<T> {
    private final Provider<? extends T> provider;
    private final Object source;

    public InternalFactoryToProviderAdapter(Provider<? extends T> provider, Object source) {
        this.provider = (Provider)Preconditions.checkNotNull(provider, (Object)"provider");
        this.source = Preconditions.checkNotNull((Object)source, (Object)"source");
    }

    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency, boolean linked) throws ErrorsException {
        try {
            return errors.checkForNull(this.provider.get(), this.source, dependency);
        }
        catch (RuntimeException userException) {
            throw errors.withSource(this.source).errorInProvider(userException).toException();
        }
    }

    public String toString() {
        return this.provider.toString();
    }
}

