/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.creation.jmock;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.hadoop.shaded.org.mockito.cglib.core.CodeGenerationException;
import org.apache.hadoop.shaded.org.mockito.cglib.core.NamingPolicy;
import org.apache.hadoop.shaded.org.mockito.cglib.core.Predicate;
import org.apache.hadoop.shaded.org.mockito.cglib.proxy.Callback;
import org.apache.hadoop.shaded.org.mockito.cglib.proxy.CallbackFilter;
import org.apache.hadoop.shaded.org.mockito.cglib.proxy.Enhancer;
import org.apache.hadoop.shaded.org.mockito.cglib.proxy.Factory;
import org.apache.hadoop.shaded.org.mockito.cglib.proxy.MethodInterceptor;
import org.apache.hadoop.shaded.org.mockito.cglib.proxy.NoOp;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import org.apache.hadoop.shaded.org.mockito.internal.creation.cglib.MockitoNamingPolicy;
import org.apache.hadoop.shaded.org.mockito.internal.creation.jmock.SearchingClassLoader;
import org.apache.hadoop.shaded.org.mockito.internal.creation.jmock.SerializableNoOp;
import org.apache.hadoop.shaded.org.objenesis.ObjenesisStd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassImposterizer {
    public static final ClassImposterizer INSTANCE = new ClassImposterizer();
    private ObjenesisStd objenesis = new ObjenesisStd();
    private static final NamingPolicy NAMING_POLICY_THAT_ALLOWS_IMPOSTERISATION_OF_CLASSES_IN_SIGNED_PACKAGES = new MockitoNamingPolicy(){

        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return "codegen." + super.getClassName(prefix, source, key, names);
        }
    };
    private static final CallbackFilter IGNORE_BRIDGE_METHODS = new CallbackFilter(){

        public int accept(Method method) {
            return method.isBridge() ? 1 : 0;
        }
    };

    private ClassImposterizer() {
    }

    public boolean canImposterise(Class<?> type) {
        return !type.isPrimitive() && !Modifier.isFinal(type.getModifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T imposterise(MethodInterceptor interceptor, Class<T> mockedType, Class<?> ... ancillaryTypes) {
        try {
            this.setConstructorsAccessible(mockedType, true);
            Class<?> proxyClass = this.createProxyClass(mockedType, ancillaryTypes);
            T t = mockedType.cast(this.createProxy(proxyClass, interceptor));
            return t;
        }
        finally {
            this.setConstructorsAccessible(mockedType, false);
        }
    }

    private void setConstructorsAccessible(Class<?> mockedType, boolean accessible) {
        for (Constructor<?> constructor : mockedType.getDeclaredConstructors()) {
            constructor.setAccessible(accessible);
        }
    }

    private Class<?> createProxyClass(Class<?> mockedType, Class<?> ... interfaces) {
        if (mockedType == Object.class) {
            mockedType = ClassWithSuperclassToWorkAroundCglibBug.class;
        }
        Enhancer enhancer = new Enhancer(){

            protected void filterConstructors(Class sc, List constructors) {
            }
        };
        enhancer.setClassLoader(SearchingClassLoader.combineLoadersOf(mockedType));
        enhancer.setUseFactory(true);
        if (mockedType.isInterface()) {
            enhancer.setSuperclass(Object.class);
            enhancer.setInterfaces(this.prepend(mockedType, interfaces));
        } else {
            enhancer.setSuperclass(mockedType);
            enhancer.setInterfaces(interfaces);
        }
        enhancer.setCallbackTypes(new Class[]{MethodInterceptor.class, NoOp.class});
        enhancer.setCallbackFilter(IGNORE_BRIDGE_METHODS);
        if (mockedType.getSigners() != null) {
            enhancer.setNamingPolicy(NAMING_POLICY_THAT_ALLOWS_IMPOSTERISATION_OF_CLASSES_IN_SIGNED_PACKAGES);
        } else {
            enhancer.setNamingPolicy(MockitoNamingPolicy.INSTANCE);
        }
        try {
            return enhancer.createClass();
        }
        catch (CodeGenerationException e) {
            if (Modifier.isPrivate(mockedType.getModifiers())) {
                throw new MockitoException("\nMockito cannot mock this class: " + mockedType + ".\n" + "Most likely it is a private class that is not visible by Mockito");
            }
            throw new MockitoException("\nMockito cannot mock this class: " + mockedType + "\n" + "Mockito can only mock visible & non-final classes." + "\n" + "If you're not sure why you're getting this error, please report to the mailing list.", e);
        }
    }

    private Object createProxy(Class<?> proxyClass, MethodInterceptor interceptor) {
        Factory proxy = (Factory)this.objenesis.newInstance(proxyClass);
        proxy.setCallbacks(new Callback[]{interceptor, SerializableNoOp.SERIALIZABLE_INSTANCE});
        return proxy;
    }

    private Class<?>[] prepend(Class<?> first, Class<?> ... rest) {
        Class[] all = new Class[rest.length + 1];
        all[0] = first;
        System.arraycopy(rest, 0, all, 1, rest.length);
        return all;
    }

    public static class ClassWithSuperclassToWorkAroundCglibBug {
    }
}

