/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.provider.docker;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.containerlaunch.AbstractLauncher;
import org.apache.hadoop.yarn.service.containerlaunch.CommandLineBuilder;
import org.apache.hadoop.yarn.service.containerlaunch.ContainerLaunchService;
import org.apache.hadoop.yarn.service.exceptions.SliderException;
import org.apache.hadoop.yarn.service.provider.AbstractProviderService;
import org.apache.hadoop.yarn.service.provider.ProviderUtils;
import org.apache.hadoop.yarn.service.provider.docker.DockerKeys;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;

public class DockerProviderService
extends AbstractProviderService
implements DockerKeys {
    @Override
    public void processArtifact(AbstractLauncher launcher, ComponentInstance compInstance, SliderFileSystem fileSystem, Service service, ContainerLaunchService.ComponentLaunchContext compLaunchCtx) throws IOException {
        launcher.setYarnDockerMode(true);
        launcher.setDockerImage(compLaunchCtx.getArtifact().getId());
        launcher.setDockerNetwork(compLaunchCtx.getConfiguration().getProperty("docker.network"));
        launcher.setDockerHostname(compInstance.getHostname());
        launcher.setRunPrivilegedContainer(compLaunchCtx.isRunPrivilegedContainer());
    }

    private boolean checkUseEntryPoint(ContainerLaunchService.ComponentLaunchContext compLaunchContext) {
        boolean overrideDisable = false;
        String overrideDisableKey = ApplicationConstants.Environment.YARN_CONTAINER_RUNTIME_DOCKER_RUN_OVERRIDE_DISABLE.name();
        String overrideDisableValue = compLaunchContext.getConfiguration().getEnv(overrideDisableKey) != null ? compLaunchContext.getConfiguration().getEnv(overrideDisableKey) : System.getenv(overrideDisableKey);
        overrideDisable = Boolean.parseBoolean(overrideDisableValue);
        return overrideDisable;
    }

    @Override
    public void buildContainerLaunchCommand(AbstractLauncher launcher, Service service, ComponentInstance instance, SliderFileSystem fileSystem, Configuration yarnConf, Container container, ContainerLaunchService.ComponentLaunchContext compLaunchContext, Map<String, String> tokensForSubstitution) throws IOException, SliderException {
        boolean useEntryPoint = this.checkUseEntryPoint(compLaunchContext);
        if (useEntryPoint) {
            String launchCommand = compLaunchContext.getLaunchCommand();
            if (!StringUtils.isEmpty((CharSequence)launchCommand)) {
                launcher.addCommand(launchCommand);
            }
        } else {
            String launchCommand = compLaunchContext.getLaunchCommand();
            if (!StringUtils.isEmpty((CharSequence)launchCommand)) {
                launchCommand = ProviderUtils.substituteStrWithTokens(launchCommand, tokensForSubstitution);
                CommandLineBuilder operation = new CommandLineBuilder();
                operation.add(launchCommand);
                operation.addOutAndErrFiles("stdout.txt", "stderr.txt");
                launcher.addCommand(operation.build());
            }
        }
    }
}

