/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.proto.ClientAMProtocol;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;

public class FilterUtils {
    public static List<Container> filterInstances(ServiceContext context, ClientAMProtocol.GetCompInstancesRequestProto filterReq) {
        ArrayList<Container> results = new ArrayList<Container>();
        Map<ContainerId, ComponentInstance> instances = context.scheduler.getLiveInstances();
        instances.forEach((containerId, instance) -> {
            String instanceServiceVersion;
            boolean include = true;
            if (filterReq.getComponentNamesList() != null && !filterReq.getComponentNamesList().isEmpty() && !filterReq.getComponentNamesList().contains(instance.getComponent().getName())) {
                include = false;
            }
            if (!(filterReq.getVersion() == null || filterReq.getVersion().isEmpty() || (instanceServiceVersion = instance.getServiceVersion()) != null && instanceServiceVersion.equals(filterReq.getVersion()))) {
                include = false;
            }
            if (filterReq.getContainerStatesList() != null && !filterReq.getContainerStatesList().isEmpty() && !filterReq.getContainerStatesList().contains(instance.getContainerState().toString())) {
                include = false;
            }
            if (include) {
                results.add(instance.getContainerSpec());
            }
        });
        return results;
    }
}

