/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.TreePath;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class TreeWalk
implements Iterable<TreePath> {
    protected abstract Iterable<TreePath> getChildren(TreePath var1, long var2, TreeIterator var4);

    public abstract TreeIterator iterator();

    public abstract class TreeIterator
    implements Iterator<TreePath> {
        private final Deque<TreePath> pending;

        TreeIterator() {
            this(new ArrayDeque<TreePath>());
        }

        protected TreeIterator(Deque<TreePath> pending) {
            this.pending = pending;
        }

        public abstract TreeIterator fork();

        @Override
        public boolean hasNext() {
            return !this.pending.isEmpty();
        }

        @Override
        public TreePath next() {
            return this.pending.removeFirst();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void onAccept(TreePath p, long id) {
            for (TreePath k : TreeWalk.this.getChildren(p, id, this)) {
                this.pending.addFirst(k);
            }
        }

        protected Deque<TreePath> getPendingQueue() {
            return this.pending;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ Treewalk=\"").append(TreeWalk.this.toString());
            sb.append(", pending=[");
            Iterator<TreePath> i = this.pending.iterator();
            if (i.hasNext()) {
                sb.append("\"").append(i.next()).append("\"");
            }
            while (i.hasNext()) {
                sb.append(", \"").append(i.next()).append("\"");
            }
            sb.append("]");
            sb.append(" }");
            return sb.toString();
        }
    }
}

