/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.MetricsPlugin;
import org.apache.hadoop.metrics2.filter.GlobFilter;
import org.apache.hadoop.metrics2.impl.MetricsConfigException;
import org.apache.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.shaded.com.google.common.base.Splitter;
import org.apache.hadoop.shaded.com.google.common.collect.Iterables;
import org.apache.hadoop.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.shaded.org.apache.commons.configuration2.Configuration;
import org.apache.hadoop.shaded.org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.hadoop.shaded.org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.hadoop.shaded.org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.hadoop.shaded.org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.hadoop.shaded.org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.hadoop.shaded.org.apache.commons.configuration2.io.FileBased;
import org.apache.hadoop.shaded.org.apache.commons.configuration2.io.FileHandler;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetricsConfig
extends SubsetConfiguration {
    static final Logger LOG = LoggerFactory.getLogger(MetricsConfig.class);
    static final String DEFAULT_FILE_NAME = "hadoop-metrics2.properties";
    static final String PREFIX_DEFAULT = "*.";
    static final String PERIOD_KEY = "period";
    static final int PERIOD_DEFAULT = 10;
    static final String PERIOD_MILLIS_KEY = "periodMillis";
    static final String QUEUE_CAPACITY_KEY = "queue.capacity";
    static final int QUEUE_CAPACITY_DEFAULT = 1;
    static final String RETRY_DELAY_KEY = "retry.delay";
    static final int RETRY_DELAY_DEFAULT = 10;
    static final String RETRY_BACKOFF_KEY = "retry.backoff";
    static final int RETRY_BACKOFF_DEFAULT = 2;
    static final String RETRY_COUNT_KEY = "retry.count";
    static final int RETRY_COUNT_DEFAULT = 1;
    static final String JMX_CACHE_TTL_KEY = "jmx.cache.ttl";
    static final String START_MBEANS_KEY = "source.start_mbeans";
    static final String PLUGIN_URLS_KEY = "plugin.urls";
    static final String CONTEXT_KEY = "context";
    static final String NAME_KEY = "name";
    static final String DESC_KEY = "description";
    static final String SOURCE_KEY = "source";
    static final String SINK_KEY = "sink";
    static final String METRIC_FILTER_KEY = "metric.filter";
    static final String RECORD_FILTER_KEY = "record.filter";
    static final String SOURCE_FILTER_KEY = "source.filter";
    static final Pattern INSTANCE_REGEX = Pattern.compile("([^.*]+)\\..+");
    static final Splitter SPLITTER = Splitter.on((char)',').trimResults();
    private ClassLoader pluginLoader;

    MetricsConfig(Configuration c, String prefix) {
        super(c, StringUtils.toLowerCase(prefix), ".");
    }

    static MetricsConfig create(String prefix) {
        return MetricsConfig.loadFirst(prefix, "hadoop-metrics2-" + StringUtils.toLowerCase(prefix) + ".properties", DEFAULT_FILE_NAME);
    }

    static MetricsConfig create(String prefix, String ... fileNames) {
        return MetricsConfig.loadFirst(prefix, fileNames);
    }

    static MetricsConfig loadFirst(String prefix, String ... fileNames) {
        for (String fname : fileNames) {
            try {
                PropertiesConfiguration pcf = new PropertiesConfiguration();
                pcf.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
                FileHandler fh = new FileHandler((FileBased)pcf);
                fh.setFileName(fname);
                fh.load();
                Configuration cf = pcf.interpolatedConfiguration();
                LOG.info("Loaded properties from {}", (Object)fname);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Properties: {}", (Object)MetricsConfig.toString(cf));
                }
                MetricsConfig mc = new MetricsConfig(cf, prefix);
                LOG.debug("Metrics Config: {}", (Object)mc);
                return mc;
            }
            catch (ConfigurationException e) {
                if (!e.getMessage().startsWith("Could not locate")) {
                    throw new MetricsConfigException(e);
                }
                LOG.debug("Could not locate file {}", (Object)fname, (Object)e);
            }
        }
        LOG.warn("Cannot locate configuration: tried " + Joiner.on((String)",").join((Object[])fileNames));
        return new MetricsConfig((Configuration)new PropertiesConfiguration(), prefix);
    }

    public MetricsConfig subset(String prefix) {
        return new MetricsConfig((Configuration)this, prefix);
    }

    Map<String, MetricsConfig> getInstanceConfigs(String type) {
        HashMap map = Maps.newHashMap();
        MetricsConfig sub = this.subset(type);
        for (String key : sub.keys()) {
            String instance;
            Matcher matcher = INSTANCE_REGEX.matcher(key);
            if (!matcher.matches() || map.containsKey(instance = matcher.group(1))) continue;
            map.put(instance, sub.subset(instance));
        }
        return map;
    }

    Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return MetricsConfig.this.getKeys();
            }
        };
    }

    public Object getPropertyInternal(String key) {
        Object value = super.getPropertyInternal(key);
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("poking parent '" + this.getParent().getClass().getSimpleName() + "' for key: " + key);
            }
            return this.getParent().getProperty(key.startsWith(PREFIX_DEFAULT) ? key : PREFIX_DEFAULT + key);
        }
        LOG.debug("Returning '{}' for key: {}", value, (Object)key);
        return value;
    }

    <T extends MetricsPlugin> T getPlugin(String name) {
        String clsName = this.getClassName(name);
        if (clsName == null) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(clsName, true, this.getPluginLoader());
            MetricsPlugin plugin = (MetricsPlugin)cls.newInstance();
            plugin.init(name.isEmpty() ? this : this.subset(name));
            return (T)plugin;
        }
        catch (Exception e) {
            throw new MetricsConfigException("Error creating plugin: " + clsName, e);
        }
    }

    String getClassName(String prefix) {
        String classKey = prefix.isEmpty() ? "class" : prefix.concat(".class");
        String clsName = this.getString(classKey);
        LOG.debug("Class name for prefix {} is {}", (Object)prefix, (Object)clsName);
        if (clsName == null || clsName.isEmpty()) {
            return null;
        }
        return clsName;
    }

    ClassLoader getPluginLoader() {
        if (this.pluginLoader != null) {
            return this.pluginLoader;
        }
        final ClassLoader defaultLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Object purls = super.getProperty(PLUGIN_URLS_KEY);
        if (purls == null) {
            return defaultLoader;
        }
        Iterable jars = SPLITTER.split((CharSequence)((String)purls));
        int len = Iterables.size((Iterable)jars);
        if (len > 0) {
            final URL[] urls = new URL[len];
            try {
                int i = 0;
                for (String jar : jars) {
                    LOG.debug("Parsing URL for {}", (Object)jar);
                    urls[i++] = new URL(jar);
                }
            }
            catch (Exception e) {
                throw new MetricsConfigException(e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using plugin jars: {}", (Object)Iterables.toString((Iterable)jars));
            }
            this.pluginLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new URLClassLoader(urls, defaultLoader);
                }
            });
            return this.pluginLoader;
        }
        if (this.parent instanceof MetricsConfig) {
            return ((MetricsConfig)this.parent).getPluginLoader();
        }
        return defaultLoader;
    }

    MetricsFilter getFilter(String prefix) {
        MetricsConfig conf = this.subset(prefix);
        if (conf.isEmpty()) {
            return null;
        }
        MetricsFilter filter = (MetricsFilter)this.getPlugin(prefix);
        if (filter != null) {
            return filter;
        }
        filter = new GlobFilter();
        filter.init(conf);
        return filter;
    }

    public String toString() {
        return MetricsConfig.toString((Configuration)this);
    }

    static String toString(Configuration c) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            PrintWriter pw = new PrintWriter(buffer, false);
            PropertiesConfiguration tmp = new PropertiesConfiguration();
            tmp.copy(c);
            tmp.write((Writer)pw);
            return buffer.toString("UTF-8");
        }
        catch (Exception e) {
            throw new MetricsConfigException(e);
        }
    }
}

