/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.Client;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientResponse;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.WebResource;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.logaggregation.ContainerLogAggregationType;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public final class LogToolUtils {
    public static final String CONTAINER_ON_NODE_PATTERN = "Container: %s on %s";

    private LogToolUtils() {
    }

    public static void outputContainerLog(String containerId, String nodeId, String fileName, long fileLength, long outputSize, String lastModifiedTime, InputStream fis, OutputStream os, byte[] buf, ContainerLogAggregationType logType) throws IOException {
        boolean keepGoing;
        long toSkip = 0L;
        long totalBytesToRead = fileLength;
        long skipAfterRead = 0L;
        if (outputSize < 0L) {
            long absBytes = Math.abs(outputSize);
            if (absBytes < fileLength) {
                toSkip = fileLength - absBytes;
                totalBytesToRead = absBytes;
            }
            IOUtils.skipFully(fis, toSkip);
        } else if (outputSize < fileLength) {
            totalBytesToRead = outputSize;
            skipAfterRead = fileLength - outputSize;
        }
        long curRead = 0L;
        long pendingRead = totalBytesToRead - curRead;
        int toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
        int len = fis.read(buf, 0, toRead);
        boolean bl = keepGoing = len != -1 && curRead < totalBytesToRead;
        if (keepGoing) {
            StringBuilder sb = new StringBuilder();
            String containerStr = String.format(CONTAINER_ON_NODE_PATTERN, containerId, nodeId);
            sb.append(containerStr + "\n");
            sb.append("LogAggregationType: " + (Object)((Object)logType) + "\n");
            sb.append(StringUtils.repeat((String)"=", (int)containerStr.length()) + "\n");
            sb.append("LogType:" + fileName + "\n");
            sb.append("LogLastModifiedTime:" + lastModifiedTime + "\n");
            sb.append("LogLength:" + Long.toString(fileLength) + "\n");
            sb.append("LogContents:\n");
            byte[] b = sb.toString().getBytes(Charset.forName("UTF-8"));
            os.write(b, 0, b.length);
        }
        while (keepGoing) {
            os.write(buf, 0, len);
            pendingRead = totalBytesToRead - (curRead += (long)len);
            toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
            len = fis.read(buf, 0, toRead);
            keepGoing = len != -1 && curRead < totalBytesToRead;
        }
        IOUtils.skipFully(fis, skipAfterRead);
        os.flush();
    }

    public static void outputContainerLogThroughZeroCopy(String containerId, String nodeId, String fileName, long fileLength, long outputSize, String lastModifiedTime, FileInputStream fis, OutputStream os, ContainerLogAggregationType logType) throws IOException {
        long toSkip = 0L;
        long totalBytesToRead = fileLength;
        if (outputSize < 0L) {
            long absBytes = Math.abs(outputSize);
            if (absBytes < fileLength) {
                toSkip = fileLength - absBytes;
                totalBytesToRead = absBytes;
            }
        } else if (outputSize < fileLength) {
            totalBytesToRead = outputSize;
        }
        if (totalBytesToRead > 0L) {
            StringBuilder sb = new StringBuilder();
            String containerStr = String.format(CONTAINER_ON_NODE_PATTERN, containerId, nodeId);
            sb.append(containerStr + "\n");
            sb.append("LogAggregationType: " + (Object)((Object)logType) + "\n");
            sb.append(StringUtils.repeat((String)"=", (int)containerStr.length()) + "\n");
            sb.append("LogType:" + fileName + "\n");
            sb.append("LogLastModifiedTime:" + lastModifiedTime + "\n");
            sb.append("LogLength:" + Long.toString(fileLength) + "\n");
            sb.append("LogContents:\n");
            byte[] b = sb.toString().getBytes(Charset.forName("UTF-8"));
            os.write(b, 0, b.length);
            FileChannel inputChannel = fis.getChannel();
            WritableByteChannel outputChannel = Channels.newChannel(os);
            long position = toSkip;
            while (totalBytesToRead > 0L) {
                long transferred = inputChannel.transferTo(position, totalBytesToRead, outputChannel);
                totalBytesToRead -= transferred;
                position += transferred;
            }
            os.flush();
        }
    }

    public static PrintStream createPrintStream(String localDir, String nodeId, String containerId) throws IOException {
        PrintStream out = System.out;
        if (localDir != null && !localDir.isEmpty()) {
            Path nodePath = new Path(localDir, LogAggregationUtils.getNodeString(nodeId));
            Files.createDirectories(Paths.get(nodePath.toString(), new String[0]), new FileAttribute[0]);
            Path containerLogPath = new Path(nodePath, containerId);
            out = new PrintStream(containerLogPath.toString(), "UTF-8");
        }
        return out;
    }

    public static ClientResponse getResponeFromNMWebService(Configuration conf, Client webServiceClient, ContainerLogsRequest request, String logFile) {
        WebResource webResource = webServiceClient.resource(WebAppUtils.getHttpSchemePrefix(conf) + request.getNodeHttpAddress());
        return (ClientResponse)webResource.path("ws").path("v1").path("node").path("containers").path(request.getContainerId()).path("logs").path(logFile).queryParam("size", Long.toString(request.getBytes())).accept(new String[]{"text/plain"}).get(ClientResponse.class);
    }
}

