/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.AvroTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.util.Shell;
import org.junit.Assert;
import org.junit.Test;

public class TestPath {
    public static String mergeStatuses(Path[] paths) {
        Object[] pathStrings = new String[paths.length];
        int i = 0;
        for (Path path : paths) {
            pathStrings[i++] = path.toUri().getPath();
        }
        Arrays.sort(pathStrings);
        return Joiner.on((String)";").join(pathStrings);
    }

    public static String mergeStatuses(FileStatus[] statuses) {
        Path[] paths = new Path[statuses.length];
        int i = 0;
        for (FileStatus status : statuses) {
            paths[i++] = status.getPath();
        }
        return TestPath.mergeStatuses(paths);
    }

    @Test(timeout=30000L)
    public void testToString() {
        this.toStringTest("/");
        this.toStringTest("/foo");
        this.toStringTest("/foo/bar");
        this.toStringTest("foo");
        this.toStringTest("foo/bar");
        this.toStringTest("/foo/bar#boo");
        this.toStringTest("foo/bar#boo");
        boolean emptyException = false;
        try {
            this.toStringTest("");
        }
        catch (IllegalArgumentException e) {
            emptyException = true;
        }
        Assert.assertTrue((boolean)emptyException);
        if (Path.WINDOWS) {
            this.toStringTest("c:");
            this.toStringTest("c:/");
            this.toStringTest("c:foo");
            this.toStringTest("c:foo/bar");
            this.toStringTest("c:foo/bar");
            this.toStringTest("c:/foo/bar");
            this.toStringTest("C:/foo/bar#boo");
            this.toStringTest("C:foo/bar#boo");
        }
    }

    private void toStringTest(String pathString) {
        Assert.assertEquals((Object)pathString, (Object)new Path(pathString).toString());
    }

    @Test(timeout=30000L)
    public void testNormalize() throws URISyntaxException {
        Assert.assertEquals((Object)"", (Object)new Path(".").toString());
        Assert.assertEquals((Object)"..", (Object)new Path("..").toString());
        Assert.assertEquals((Object)"/", (Object)new Path("/").toString());
        Assert.assertEquals((Object)"/", (Object)new Path("//").toString());
        Assert.assertEquals((Object)"/", (Object)new Path("///").toString());
        Assert.assertEquals((Object)"//foo/", (Object)new Path("//foo/").toString());
        Assert.assertEquals((Object)"//foo/", (Object)new Path("//foo//").toString());
        Assert.assertEquals((Object)"//foo/bar", (Object)new Path("//foo//bar").toString());
        Assert.assertEquals((Object)"/foo", (Object)new Path("/foo/").toString());
        Assert.assertEquals((Object)"/foo", (Object)new Path("/foo/").toString());
        Assert.assertEquals((Object)"foo", (Object)new Path("foo/").toString());
        Assert.assertEquals((Object)"foo", (Object)new Path("foo//").toString());
        Assert.assertEquals((Object)"foo", (Object)new Path("foo///").toString());
        Assert.assertEquals((Object)"foo/bar", (Object)new Path("foo//bar").toString());
        Assert.assertEquals((Object)"foo/bar", (Object)new Path("foo///bar").toString());
        Assert.assertEquals((Object)"hdfs://foo/foo2/bar/baz/", (Object)new Path(new URI("hdfs://foo//foo2///bar/baz///")).toString());
        if (Path.WINDOWS) {
            Assert.assertEquals((Object)"c:/a/b", (Object)new Path("c:\\a\\b").toString());
        }
    }

    @Test(timeout=30000L)
    public void testIsAbsolute() {
        Assert.assertTrue((boolean)new Path("/").isAbsolute());
        Assert.assertTrue((boolean)new Path("/foo").isAbsolute());
        Assert.assertFalse((boolean)new Path("foo").isAbsolute());
        Assert.assertFalse((boolean)new Path("foo/bar").isAbsolute());
        Assert.assertFalse((boolean)new Path(".").isAbsolute());
        if (Path.WINDOWS) {
            Assert.assertTrue((boolean)new Path("c:/a/b").isAbsolute());
            Assert.assertFalse((boolean)new Path("c:a/b").isAbsolute());
        }
    }

    @Test(timeout=30000L)
    public void testParent() {
        Assert.assertEquals((Object)new Path("/foo"), (Object)new Path("/foo/bar").getParent());
        Assert.assertEquals((Object)new Path("foo"), (Object)new Path("foo/bar").getParent());
        Assert.assertEquals((Object)new Path("/"), (Object)new Path("/foo").getParent());
        Assert.assertEquals(null, (Object)new Path("/").getParent());
        if (Path.WINDOWS) {
            Assert.assertEquals((Object)new Path("c:/"), (Object)new Path("c:/foo").getParent());
        }
    }

    @Test(timeout=30000L)
    public void testChild() {
        Assert.assertEquals((Object)new Path("."), (Object)new Path(".", "."));
        Assert.assertEquals((Object)new Path("/"), (Object)new Path("/", "."));
        Assert.assertEquals((Object)new Path("/"), (Object)new Path(".", "/"));
        Assert.assertEquals((Object)new Path("/foo"), (Object)new Path("/", "foo"));
        Assert.assertEquals((Object)new Path("/foo/bar"), (Object)new Path("/foo", "bar"));
        Assert.assertEquals((Object)new Path("/foo/bar/baz"), (Object)new Path("/foo/bar", "baz"));
        Assert.assertEquals((Object)new Path("/foo/bar/baz"), (Object)new Path("/foo", "bar/baz"));
        Assert.assertEquals((Object)new Path("foo"), (Object)new Path(".", "foo"));
        Assert.assertEquals((Object)new Path("foo/bar"), (Object)new Path("foo", "bar"));
        Assert.assertEquals((Object)new Path("foo/bar/baz"), (Object)new Path("foo", "bar/baz"));
        Assert.assertEquals((Object)new Path("foo/bar/baz"), (Object)new Path("foo/bar", "baz"));
        Assert.assertEquals((Object)new Path("/foo"), (Object)new Path("/bar", "/foo"));
        if (Path.WINDOWS) {
            Assert.assertEquals((Object)new Path("c:/foo"), (Object)new Path("/bar", "c:/foo"));
            Assert.assertEquals((Object)new Path("c:/foo"), (Object)new Path("d:/bar", "c:/foo"));
        }
    }

    @Test(timeout=30000L)
    public void testPathThreeArgContructor() {
        Assert.assertEquals((Object)new Path("foo"), (Object)new Path(null, null, "foo"));
        Assert.assertEquals((Object)new Path("scheme:///foo"), (Object)new Path("scheme", null, "/foo"));
        Assert.assertEquals((Object)new Path("scheme://authority/foo"), (Object)new Path("scheme", "authority", "/foo"));
        if (Path.WINDOWS) {
            Assert.assertEquals((Object)new Path("c:/foo/bar"), (Object)new Path(null, null, "c:/foo/bar"));
            Assert.assertEquals((Object)new Path("c:/foo/bar"), (Object)new Path(null, null, "/c:/foo/bar"));
        } else {
            Assert.assertEquals((Object)new Path("./a:b"), (Object)new Path(null, null, "a:b"));
        }
        if (Path.WINDOWS) {
            Assert.assertEquals((Object)new Path("c:/foo/bar"), (Object)new Path("/fou", new Path(null, null, "c:/foo/bar")));
            Assert.assertEquals((Object)new Path("c:/foo/bar"), (Object)new Path("/fou", new Path(null, null, "/c:/foo/bar")));
            Assert.assertEquals((Object)new Path("/foo/bar"), (Object)new Path("/foo", new Path(null, null, "bar")));
        } else {
            Assert.assertEquals((Object)new Path("/foo/bar/a:b"), (Object)new Path("/foo/bar", new Path(null, null, "a:b")));
            Assert.assertEquals((Object)new Path("/a:b"), (Object)new Path("/foo/bar", new Path(null, null, "/a:b")));
        }
    }

    @Test(timeout=30000L)
    public void testEquals() {
        Assert.assertFalse((boolean)new Path("/").equals((Object)new Path("/foo")));
    }

    @Test(timeout=30000L)
    public void testDots() {
        Assert.assertEquals((Object)new Path("/foo/bar/baz").toString(), (Object)"/foo/bar/baz");
        Assert.assertEquals((Object)new Path("/foo/bar", ".").toString(), (Object)"/foo/bar");
        Assert.assertEquals((Object)new Path("/foo/bar/../baz").toString(), (Object)"/foo/baz");
        Assert.assertEquals((Object)new Path("/foo/bar/./baz").toString(), (Object)"/foo/bar/baz");
        Assert.assertEquals((Object)new Path("/foo/bar/baz/../../fud").toString(), (Object)"/foo/fud");
        Assert.assertEquals((Object)new Path("/foo/bar/baz/.././../fud").toString(), (Object)"/foo/fud");
        Assert.assertEquals((Object)new Path("../../foo/bar").toString(), (Object)"../../foo/bar");
        Assert.assertEquals((Object)new Path(".././../foo/bar").toString(), (Object)"../../foo/bar");
        Assert.assertEquals((Object)new Path("./foo/bar/baz").toString(), (Object)"foo/bar/baz");
        Assert.assertEquals((Object)new Path("/foo/bar/../../baz/boo").toString(), (Object)"/baz/boo");
        Assert.assertEquals((Object)new Path("foo/bar/").toString(), (Object)"foo/bar");
        Assert.assertEquals((Object)new Path("foo/bar/../baz").toString(), (Object)"foo/baz");
        Assert.assertEquals((Object)new Path("foo/bar/../../baz/boo").toString(), (Object)"baz/boo");
        Assert.assertEquals((Object)new Path("/foo/bar", "baz/boo").toString(), (Object)"/foo/bar/baz/boo");
        Assert.assertEquals((Object)new Path("foo/bar/", "baz/bud").toString(), (Object)"foo/bar/baz/bud");
        Assert.assertEquals((Object)new Path("/foo/bar", "../../boo/bud").toString(), (Object)"/boo/bud");
        Assert.assertEquals((Object)new Path("foo/bar", "../../boo/bud").toString(), (Object)"boo/bud");
        Assert.assertEquals((Object)new Path(".", "boo/bud").toString(), (Object)"boo/bud");
        Assert.assertEquals((Object)new Path("/foo/bar/baz", "../../boo/bud").toString(), (Object)"/foo/boo/bud");
        Assert.assertEquals((Object)new Path("foo/bar/baz", "../../boo/bud").toString(), (Object)"foo/boo/bud");
        Assert.assertEquals((Object)new Path("../../", "../../boo/bud").toString(), (Object)"../../../../boo/bud");
        Assert.assertEquals((Object)new Path("../../foo", "../../../boo/bud").toString(), (Object)"../../../../boo/bud");
        Assert.assertEquals((Object)new Path("../../foo/bar", "../boo/bud").toString(), (Object)"../../foo/boo/bud");
        Assert.assertEquals((Object)new Path("foo/bar/baz", "../../..").toString(), (Object)"");
        Assert.assertEquals((Object)new Path("foo/bar/baz", "../../../../..").toString(), (Object)"../..");
    }

    @Test(timeout=5000L)
    public void testWindowsPaths() throws URISyntaxException, IOException {
        PlatformAssumptions.assumeWindows();
        Assert.assertEquals((Object)new Path("c:\\foo\\bar").toString(), (Object)"c:/foo/bar");
        Assert.assertEquals((Object)new Path("c:/foo/bar").toString(), (Object)"c:/foo/bar");
        Assert.assertEquals((Object)new Path("/c:/foo/bar").toString(), (Object)"c:/foo/bar");
        Assert.assertEquals((Object)new Path("file://c:/foo/bar").toString(), (Object)"file://c:/foo/bar");
    }

    @Test(timeout=5000L)
    public void testInvalidWindowsPaths() throws URISyntaxException, IOException {
        String[] invalidPaths;
        PlatformAssumptions.assumeWindows();
        for (String path : invalidPaths = new String[]{"hdfs:\\\\\\tmp"}) {
            try {
                Path item = new Path(path);
                Assert.fail((String)("Did not throw for invalid path " + path));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test(timeout=30000L)
    public void testChildParentResolution() throws URISyntaxException, IOException {
        Path parent = new Path("foo1://bar1/baz1");
        Path child = new Path("foo2://bar2/baz2");
        Assert.assertEquals((Object)child, (Object)new Path(parent, child));
    }

    @Test(timeout=30000L)
    public void testScheme() throws IOException {
        Assert.assertEquals((Object)"foo:/bar", (Object)new Path("foo:/", "/bar").toString());
        Assert.assertEquals((Object)"foo://bar/baz", (Object)new Path("foo://bar/", "/baz").toString());
    }

    @Test(timeout=30000L)
    public void testURI() throws URISyntaxException, IOException {
        URI uri = new URI("file:///bar#baz");
        Path path = new Path(uri);
        Assert.assertTrue((boolean)uri.equals(new URI(path.toString())));
        FileSystem fs = path.getFileSystem(new Configuration());
        Assert.assertTrue((boolean)uri.equals(new URI(fs.makeQualified(path).toString())));
        URI uri2 = new URI("file:///bar/baz");
        Assert.assertTrue((boolean)uri2.equals(new URI(fs.makeQualified(new Path(uri2)).toString())));
        Assert.assertEquals((Object)"foo://bar/baz#boo", (Object)new Path("foo://bar/", new Path(new URI("/baz#boo"))).toString());
        Assert.assertEquals((Object)"foo://bar/baz/fud#boo", (Object)new Path(new Path(new URI("foo://bar/baz#bud")), new Path(new URI("fud#boo"))).toString());
        Assert.assertEquals((Object)"foo://bar/fud#boo", (Object)new Path(new Path(new URI("foo://bar/baz#bud")), new Path(new URI("/fud#boo"))).toString());
    }

    @Test(timeout=30000L)
    public void testPathToUriConversion() throws URISyntaxException, IOException {
        Assert.assertEquals((String)"? mark char in to URI", (Object)new URI(null, null, "/foo?bar", null, null), (Object)new Path("/foo?bar").toUri());
        Assert.assertEquals((String)"escape slashes chars in to URI", (Object)new URI(null, null, "/foo\"bar", null, null), (Object)new Path("/foo\"bar").toUri());
        Assert.assertEquals((String)"spaces in chars to URI", (Object)new URI(null, null, "/foo bar", null, null), (Object)new Path("/foo bar").toUri());
        Assert.assertEquals((Object)"/foo?bar", (Object)new Path("http://localhost/foo?bar").toUri().getPath());
        Assert.assertEquals((Object)"/foo", (Object)new URI("http://localhost/foo?bar").getPath());
        Assert.assertEquals((Object)new URI("/foo;bar").getPath(), (Object)new Path("/foo;bar").toUri().getPath());
        Assert.assertEquals((Object)new URI("/foo;bar"), (Object)new Path("/foo;bar").toUri());
        Assert.assertEquals((Object)new URI("/foo+bar"), (Object)new Path("/foo+bar").toUri());
        Assert.assertEquals((Object)new URI("/foo-bar"), (Object)new Path("/foo-bar").toUri());
        Assert.assertEquals((Object)new URI("/foo=bar"), (Object)new Path("/foo=bar").toUri());
        Assert.assertEquals((Object)new URI("/foo,bar"), (Object)new Path("/foo,bar").toUri());
    }

    @Test(timeout=30000L)
    public void testReservedCharacters() throws URISyntaxException, IOException {
        Assert.assertEquals((Object)"/foo%20bar", (Object)new URI(null, null, "/foo bar", null, null).getRawPath());
        Assert.assertEquals((Object)"/foo bar", (Object)new URI(null, null, "/foo bar", null, null).getPath());
        Assert.assertEquals((Object)"/foo%20bar", (Object)new URI(null, null, "/foo bar", null, null).toString());
        Assert.assertEquals((Object)"/foo%20bar", (Object)new Path("/foo bar").toUri().toString());
        Assert.assertEquals((Object)"/foo;bar", (Object)new URI("/foo;bar").getPath());
        Assert.assertEquals((Object)"/foo;bar", (Object)new URI("/foo;bar").getRawPath());
        Assert.assertEquals((Object)"/foo+bar", (Object)new URI("/foo+bar").getPath());
        Assert.assertEquals((Object)"/foo+bar", (Object)new URI("/foo+bar").getRawPath());
        Assert.assertEquals((Object)"/foo bar", (Object)new Path("http://localhost/foo bar").toUri().getPath());
        Assert.assertEquals((Object)"/foo%20bar", (Object)new Path("http://localhost/foo bar").toUri().toURL().getPath());
        Assert.assertEquals((Object)"/foo?bar", (Object)new URI("http", "localhost", "/foo?bar", null, null).getPath());
        Assert.assertEquals((Object)"/foo%3Fbar", (Object)new URI("http", "localhost", "/foo?bar", null, null).toURL().getPath());
    }

    @Test(timeout=30000L)
    public void testMakeQualified() throws URISyntaxException {
        URI defaultUri = new URI("hdfs://host1/dir1");
        URI wd = new URI("hdfs://host2/dir2");
        Assert.assertEquals((Object)new Path("hdfs://host1/dir/file"), (Object)new Path("file").makeQualified(defaultUri, new Path("/dir")));
        Assert.assertEquals((Object)new Path("hdfs://host2/dir2/file"), (Object)new Path("file").makeQualified(defaultUri, new Path(wd)));
    }

    @Test(timeout=30000L)
    public void testGetName() {
        Assert.assertEquals((Object)"", (Object)new Path("/").getName());
        Assert.assertEquals((Object)"foo", (Object)new Path("foo").getName());
        Assert.assertEquals((Object)"foo", (Object)new Path("/foo").getName());
        Assert.assertEquals((Object)"foo", (Object)new Path("/foo/").getName());
        Assert.assertEquals((Object)"bar", (Object)new Path("/foo/bar").getName());
        Assert.assertEquals((Object)"bar", (Object)new Path("hdfs://host/foo/bar").getName());
    }

    @Test(timeout=30000L)
    public void testAvroReflect() throws Exception {
        AvroTestUtil.testReflect(new Path("foo"), "{\"type\":\"string\",\"java-class\":\"org.apache.hadoop.fs.Path\"}");
    }

    @Test(timeout=30000L)
    public void testGlobEscapeStatus() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)new Configuration());
        Path testRoot = lfs.makeQualified(new Path(GenericTestUtils.getTempPath("testPathGlob")));
        lfs.delete(testRoot, true);
        lfs.mkdirs(testRoot);
        Assert.assertTrue((boolean)lfs.isDirectory(testRoot));
        lfs.setWorkingDirectory(testRoot);
        Object[] paths = new Path[]{new Path(testRoot, "*/f"), new Path(testRoot, "d1/f"), new Path(testRoot, "d2/f")};
        Arrays.sort(paths);
        for (Object p : paths) {
            lfs.create((Path)p).close();
            Assert.assertTrue((boolean)lfs.exists((Path)p));
        }
        Object[] stats = lfs.listStatus(new Path(testRoot, "*"));
        Assert.assertEquals((long)1L, (long)stats.length);
        Assert.assertEquals((Object)new Path(testRoot, "*/f"), (Object)stats[0].getPath());
        stats = lfs.globStatus(new Path(testRoot, "*"));
        Arrays.sort(stats);
        Path[] parentPaths = new Path[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            parentPaths[i] = paths[i].getParent();
        }
        Assert.assertEquals((Object)TestPath.mergeStatuses(parentPaths), (Object)TestPath.mergeStatuses((FileStatus[])stats));
        stats = lfs.globStatus(new Path(testRoot, "\\*"));
        Assert.assertEquals((long)1L, (long)stats.length);
        Assert.assertEquals((Object)new Path(testRoot, "*"), (Object)stats[0].getPath());
        stats = lfs.globStatus(new Path(testRoot, "*/f"));
        Assert.assertEquals((long)paths.length, (long)stats.length);
        Assert.assertEquals((Object)TestPath.mergeStatuses((Path[])paths), (Object)TestPath.mergeStatuses((FileStatus[])stats));
        stats = lfs.globStatus(new Path(testRoot, "\\*/f"));
        Assert.assertEquals((long)1L, (long)stats.length);
        Assert.assertEquals((Object)new Path(testRoot, "*/f"), (Object)stats[0].getPath());
        stats = lfs.globStatus(new Path(testRoot, "\\*/*"));
        Assert.assertEquals((long)1L, (long)stats.length);
        Assert.assertEquals((Object)new Path(testRoot, "*/f"), (Object)stats[0].getPath());
    }

    @Test(timeout=30000L)
    public void testMergePaths() {
        Assert.assertEquals((Object)new Path("/foo/bar"), (Object)Path.mergePaths((Path)new Path("/foo"), (Path)new Path("/bar")));
        Assert.assertEquals((Object)new Path("/foo/bar/baz"), (Object)Path.mergePaths((Path)new Path("/foo/bar"), (Path)new Path("/baz")));
        Assert.assertEquals((Object)new Path("/foo/bar/baz"), (Object)Path.mergePaths((Path)new Path("/foo"), (Path)new Path("/bar/baz")));
        Assert.assertEquals((Object)new Path(Shell.WINDOWS ? "/C:/foo/bar" : "/C:/foo/C:/bar"), (Object)Path.mergePaths((Path)new Path("/C:/foo"), (Path)new Path("/C:/bar")));
        Assert.assertEquals((Object)new Path(Shell.WINDOWS ? "/C:/bar" : "/C:/C:/bar"), (Object)Path.mergePaths((Path)new Path("/C:/"), (Path)new Path("/C:/bar")));
        Assert.assertEquals((Object)new Path("/bar"), (Object)Path.mergePaths((Path)new Path("/"), (Path)new Path("/bar")));
        Assert.assertEquals((Object)new Path("viewfs:///foo/bar"), (Object)Path.mergePaths((Path)new Path("viewfs:///foo"), (Path)new Path("file:///bar")));
        Assert.assertEquals((Object)new Path("viewfs://vfsauthority/foo/bar"), (Object)Path.mergePaths((Path)new Path("viewfs://vfsauthority/foo"), (Path)new Path("file://fileauthority/bar")));
    }

    @Test(timeout=30000L)
    public void testIsWindowsAbsolutePath() {
        PlatformAssumptions.assumeWindows();
        Assert.assertTrue((boolean)Path.isWindowsAbsolutePath((String)"C:\\test", (boolean)false));
        Assert.assertTrue((boolean)Path.isWindowsAbsolutePath((String)"C:/test", (boolean)false));
        Assert.assertTrue((boolean)Path.isWindowsAbsolutePath((String)"/C:/test", (boolean)true));
        Assert.assertFalse((boolean)Path.isWindowsAbsolutePath((String)"/test", (boolean)false));
        Assert.assertFalse((boolean)Path.isWindowsAbsolutePath((String)"/test", (boolean)true));
        Assert.assertFalse((boolean)Path.isWindowsAbsolutePath((String)"C:test", (boolean)false));
        Assert.assertFalse((boolean)Path.isWindowsAbsolutePath((String)"/C:test", (boolean)true));
    }

    @Test(timeout=30000L)
    public void testSerDeser() throws Throwable {
        Path source = new Path("hdfs://localhost:4040/scratch");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(source);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Path deser = (Path)ois.readObject();
            Assert.assertEquals((Object)source, (Object)deser);
        }
    }
}

