/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestIPCServerResponder {
    public static final Logger LOG = LoggerFactory.getLogger(TestIPCServerResponder.class);
    private static Configuration conf = new Configuration();
    private static final Random RANDOM = new Random();
    private static final String ADDRESS = "0.0.0.0";
    private static final int BYTE_COUNT = 1024;
    private static final byte[] BYTES = new byte[1024];

    static Writable call(Client client, Writable param, InetSocketAddress address) throws IOException {
        Client.ConnectionId remoteId = Client.ConnectionId.getConnectionId((InetSocketAddress)address, null, null, (int)0, null, (Configuration)conf);
        return client.call(RPC.RpcKind.RPC_BUILTIN, param, remoteId, 0, null);
    }

    @Test
    public void testResponseBuffer() throws IOException, InterruptedException {
        Server.INITIAL_RESP_BUF_SIZE = 1;
        conf.setInt("ipc.server.max.response.size", 1);
        this.checkServerResponder(1, true, 1, 1, 5);
        conf = new Configuration();
    }

    @Test
    public void testServerResponder() throws IOException, InterruptedException {
        this.checkServerResponder(10, true, 1, 10, 200);
    }

    public void checkServerResponder(int handlerCount, boolean handlerSleep, int clientCount, int callerCount, int callCount) throws IOException, InterruptedException {
        int i;
        TestServer server = new TestServer(handlerCount, handlerSleep);
        server.start();
        InetSocketAddress address = NetUtils.getConnectAddress((Server)server);
        Client[] clients = new Client[clientCount];
        for (int i2 = 0; i2 < clientCount; ++i2) {
            clients[i2] = new Client(BytesWritable.class, conf);
        }
        Caller[] callers = new Caller[callerCount];
        for (i = 0; i < callerCount; ++i) {
            callers[i] = new Caller(clients[i % clientCount], address, callCount);
            callers[i].start();
        }
        for (i = 0; i < callerCount; ++i) {
            callers[i].join();
            Assert.assertFalse((boolean)callers[i].failed);
        }
        for (i = 0; i < clientCount; ++i) {
            clients[i].stop();
        }
        server.stop();
    }

    @Test(timeout=10000L)
    public void testDeferResponse() throws IOException, InterruptedException {
        final AtomicReference deferredCall = new AtomicReference();
        final AtomicInteger count = new AtomicInteger();
        IntWritable wait0 = new IntWritable(0);
        IntWritable wait1 = new IntWritable(1);
        IntWritable wait2 = new IntWritable(2);
        Server server = new Server(ADDRESS, 0, IntWritable.class, 1, conf){

            public Writable call(RPC.RpcKind rpcKind, String protocol, Writable waitCount, long receiveTime) throws IOException {
                Server.Call call = (Server.Call)Server.getCurCall().get();
                int wait = ((IntWritable)waitCount).get();
                while (wait-- > 0) {
                    call.postponeResponse();
                    deferredCall.set(call);
                }
                return new IntWritable(count.getAndIncrement());
            }
        };
        server.start();
        InetSocketAddress address = NetUtils.getConnectAddress((Server)server);
        final Client client = new Client(IntWritable.class, conf);
        Server.Call[] waitingCalls = new Server.Call[2];
        Assert.assertEquals((long)0L, (long)((IntWritable)TestIPCServerResponder.call(client, (Writable)wait0, address)).get());
        Assert.assertEquals((long)1L, (long)((IntWritable)TestIPCServerResponder.call(client, (Writable)wait0, address)).get());
        ExecutorService exec = Executors.newCachedThreadPool();
        Future<Integer> future1 = exec.submit(new Callable<Integer>((Writable)wait1, address){
            final /* synthetic */ Writable val$wait1;
            final /* synthetic */ InetSocketAddress val$address;
            {
                this.val$wait1 = writable;
                this.val$address = inetSocketAddress;
            }

            @Override
            public Integer call() throws IOException {
                return ((IntWritable)TestIPCServerResponder.call(client, this.val$wait1, this.val$address)).get();
            }
        });
        try {
            future1.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"ipc shouldn't have responded");
        }
        catch (TimeoutException timeoutException) {
        }
        catch (Exception ex) {
            Assert.fail((String)("unexpected exception:" + ex));
        }
        Assert.assertFalse((boolean)future1.isDone());
        waitingCalls[0] = (Server.Call)deferredCall.get();
        Assert.assertNotNull((Object)waitingCalls[0]);
        Assert.assertEquals((long)3L, (long)((IntWritable)TestIPCServerResponder.call(client, (Writable)wait0, address)).get());
        Future<Integer> future2 = exec.submit(new Callable<Integer>((Writable)wait2, address){
            final /* synthetic */ Writable val$wait2;
            final /* synthetic */ InetSocketAddress val$address;
            {
                this.val$wait2 = writable;
                this.val$address = inetSocketAddress;
            }

            @Override
            public Integer call() throws IOException {
                return ((IntWritable)TestIPCServerResponder.call(client, this.val$wait2, this.val$address)).get();
            }
        });
        try {
            future2.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"ipc shouldn't have responded");
        }
        catch (TimeoutException timeoutException) {
        }
        catch (Exception ex) {
            Assert.fail((String)("unexpected exception:" + ex));
        }
        Assert.assertFalse((boolean)future2.isDone());
        waitingCalls[1] = (Server.Call)deferredCall.get();
        Assert.assertNotNull((Object)waitingCalls[1]);
        Assert.assertFalse((boolean)future1.isDone());
        Assert.assertFalse((boolean)future2.isDone());
        waitingCalls[0].sendResponse();
        waitingCalls[1].sendResponse();
        try {
            int val = future1.get(1L, TimeUnit.SECONDS);
            Assert.assertEquals((long)2L, (long)val);
        }
        catch (Exception ex) {
            Assert.fail((String)("unexpected exception:" + ex));
        }
        try {
            future2.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"ipc shouldn't have responded");
        }
        catch (TimeoutException ex) {
        }
        catch (Exception ex) {
            Assert.fail((String)("unexpected exception:" + ex));
        }
        Assert.assertFalse((boolean)future2.isDone());
        Assert.assertEquals((long)5L, (long)((IntWritable)TestIPCServerResponder.call(client, (Writable)wait0, address)).get());
        waitingCalls[1].sendResponse();
        try {
            int val = future2.get(1L, TimeUnit.SECONDS);
            Assert.assertEquals((long)4L, (long)val);
        }
        catch (Exception ex) {
            Assert.fail((String)("unexpected exception:" + ex));
        }
        server.stop();
    }

    static {
        for (int i = 0; i < 1024; ++i) {
            TestIPCServerResponder.BYTES[i] = (byte)(97 + i % 26);
        }
    }

    private static class Caller
    extends Thread {
        private Client client;
        private int count;
        private InetSocketAddress address;
        private boolean failed;

        public Caller(Client client, InetSocketAddress address, int count) {
            this.client = client;
            this.address = address;
            this.count = count;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.count; ++i) {
                try {
                    int byteSize = RANDOM.nextInt(1024);
                    byte[] bytes = new byte[byteSize];
                    System.arraycopy(BYTES, 0, bytes, 0, byteSize);
                    BytesWritable param = new BytesWritable(bytes);
                    TestIPCServerResponder.call(this.client, (Writable)param, this.address);
                    Thread.sleep(RANDOM.nextInt(20));
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Caught Exception", (Throwable)e);
                    this.failed = true;
                }
            }
        }
    }

    private static class TestServer
    extends Server {
        private boolean sleep;

        public TestServer(int handlerCount, boolean sleep) throws IOException {
            super(TestIPCServerResponder.ADDRESS, 0, BytesWritable.class, handlerCount, conf);
            this.setSocketSendBufSize(512);
            this.sleep = sleep;
        }

        public Writable call(RPC.RpcKind rpcKind, String protocol, Writable param, long receiveTime) throws IOException {
            if (this.sleep) {
                try {
                    Thread.sleep(RANDOM.nextInt(20));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return param;
        }
    }
}

