/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TestFileTruncate;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAppendSnapshotTruncate {
    private static final Logger LOG;
    private static final int BLOCK_SIZE = 1024;
    private static final int DATANODE_NUM = 4;
    private static final short REPLICATION = 3;
    private static final int FILE_WORKER_NUM = 10;
    private static final long TEST_TIME_SECOND = 20L;
    private static final long TEST_TIMEOUT_SECOND = 80L;
    static final int SHORT_HEARTBEAT = 1;
    static final String[] EMPTY_STRINGS;
    static Configuration conf;
    static MiniDFSCluster cluster;
    static DistributedFileSystem dfs;
    static final FileFilter FILE_ONLY;

    @BeforeClass
    public static void startUp() throws IOException {
        conf = new HdfsConfiguration();
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 1024L);
        conf.setInt("dfs.bytes-per-checksum", 1024);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setLong("dfs.namenode.reconstruction.pending.timeout-sec", 1L);
        conf.setBoolean("dfs.client.block.write.replace-datanode-on-failure.best-effort", true);
        cluster = new MiniDFSCluster.Builder(conf).format(true).numDataNodes(4).waitSafeMode(true).build();
        dfs = cluster.getFileSystem();
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (dfs != null) {
            dfs.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test(timeout=80000L)
    public void testAST() throws Exception {
        String dirPathString = "/dir";
        Path dir = new Path("/dir");
        dfs.mkdirs(dir);
        dfs.allowSnapshot(dir);
        File localDir = GenericTestUtils.getTestDir((String)"/dir");
        if (localDir.exists()) {
            FileUtil.fullyDelete((File)localDir);
        }
        localDir.mkdirs();
        DirWorker w = new DirWorker(dir, localDir, 10);
        w.startAllFiles();
        w.start();
        Worker.sleep(20000L);
        w.stop();
        w.stopAllFiles();
        w.checkEverything();
    }

    static {
        GenericTestUtils.setLogLevel((Logger)NameNode.stateChangeLog, (Level)Level.ALL);
        LOG = LoggerFactory.getLogger(TestAppendSnapshotTruncate.class);
        EMPTY_STRINGS = new String[0];
        FILE_ONLY = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile();
            }
        };
    }

    static abstract class Worker
    implements Callable<String> {
        final String name;
        final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);
        final AtomicBoolean isCalling = new AtomicBoolean();
        final AtomicReference<Thread> thread = new AtomicReference();
        private Throwable thrown = null;

        Worker(String name) {
            this.name = name;
        }

        State checkErrorState() {
            State s = this.state.get();
            if (s == State.ERROR) {
                throw new IllegalStateException(this.name + " has " + (Object)((Object)s), this.thrown);
            }
            return s;
        }

        void setErrorState(Throwable t) {
            this.checkErrorState();
            LOG.error("Worker " + this.name + " failed.", t);
            this.state.set(State.ERROR);
            this.thrown = t;
        }

        void start() {
            Preconditions.checkState((boolean)this.state.compareAndSet(State.IDLE, State.RUNNING));
            if (this.thread.get() == null) {
                Thread t = new Thread(null, new Runnable(){

                    @Override
                    public void run() {
                        while (true) {
                            State s = this.checkErrorState();
                            if (s.isTerminated) break;
                            if (s == State.RUNNING) {
                                isCalling.set(true);
                                try {
                                    LOG.info((String)this.call());
                                }
                                catch (Throwable t) {
                                    this.setErrorState(t);
                                    return;
                                }
                                isCalling.set(false);
                            }
                            Worker.sleep(ThreadLocalRandom.current().nextInt(100) + 50);
                        }
                    }
                }, this.name);
                Preconditions.checkState((boolean)this.thread.compareAndSet(null, t));
                t.start();
            }
        }

        boolean isPaused() {
            State s = this.checkErrorState();
            if (s == State.STOPPED) {
                throw new IllegalStateException(this.name + " is " + (Object)((Object)s));
            }
            return s == State.IDLE && !this.isCalling.get();
        }

        void pause() {
            this.checkErrorState();
            Preconditions.checkState((boolean)this.state.compareAndSet(State.RUNNING, State.IDLE), (String)"%s: state=%s != %s", (Object)this.name, (Object)((Object)this.state.get()), (Object)((Object)State.RUNNING));
        }

        void stop() throws InterruptedException {
            this.checkErrorState();
            this.state.set(State.STOPPED);
            this.thread.get().join();
        }

        static void sleep(long sleepTimeMs) {
            try {
                Thread.sleep(sleepTimeMs);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        static enum State {
            IDLE(false),
            RUNNING(false),
            STOPPED(true),
            ERROR(true);

            final boolean isTerminated;

            private State(boolean isTerminated) {
                this.isTerminated = isTerminated;
            }
        }
    }

    static class FileWorker
    extends Worker {
        final Path file;
        final File localFile;

        FileWorker(Path dir, File localDir, String filename) throws IOException {
            super(filename);
            this.file = new Path(dir, filename);
            this.localFile = new File(localDir, filename);
            this.localFile.createNewFile();
            dfs.create(this.file, false, 4096, (short)3, 1024L).close();
        }

        @Override
        public String call() throws IOException {
            int op = ThreadLocalRandom.current().nextInt(9);
            if (op == 0) {
                return this.checkFullFile();
            }
            int nBlocks = ThreadLocalRandom.current().nextInt(4) + 1;
            int lastBlockSize = ThreadLocalRandom.current().nextInt(1024) + 1;
            int nBytes = nBlocks * 1024 + lastBlockSize;
            if (op <= 4) {
                return this.append(nBytes);
            }
            if (op <= 6) {
                return this.truncateArbitrarily(nBytes);
            }
            return this.truncateToBlockBoundary(nBlocks);
        }

        String append(int n) throws IOException {
            StringBuilder b = new StringBuilder("append ").append(n).append(" bytes to ").append(this.file.getName());
            byte[] bytes = new byte[n];
            ThreadLocalRandom.current().nextBytes(bytes);
            FileOutputStream out = new FileOutputStream(this.localFile, true);
            out.write(bytes, 0, bytes.length);
            out.close();
            out = dfs.append(this.file);
            out.write(bytes, 0, bytes.length);
            out.close();
            return b.toString();
        }

        String truncateArbitrarily(int nBytes) throws IOException {
            Preconditions.checkArgument((nBytes > 0 ? 1 : 0) != 0);
            int length = this.checkLength();
            StringBuilder b = new StringBuilder("truncateArbitrarily: ").append(nBytes).append(" bytes from ").append(this.file.getName()).append(", length=" + length);
            this.truncate(length > nBytes ? (long)(length - nBytes) : 0L, b);
            return b.toString();
        }

        String truncateToBlockBoundary(int nBlocks) throws IOException {
            Preconditions.checkArgument((nBlocks > 0 ? 1 : 0) != 0);
            int length = this.checkLength();
            StringBuilder b = new StringBuilder("truncateToBlockBoundary: ").append(nBlocks).append(" blocks from ").append(this.file.getName()).append(", length=" + length);
            int n = (nBlocks - 1) * 1024 + length % 1024;
            Preconditions.checkState((boolean)this.truncate(length > n ? (long)(length - n) : 0L, b), (Object)b);
            return b.toString();
        }

        private boolean truncate(long newLength, StringBuilder b) throws IOException {
            RandomAccessFile raf = new RandomAccessFile(this.localFile, "rw");
            raf.setLength(newLength);
            raf.close();
            boolean isReady = dfs.truncate(this.file, newLength);
            b.append(", newLength=").append(newLength).append(", isReady=").append(isReady);
            if (!isReady) {
                TestFileTruncate.checkBlockRecovery(this.file, dfs, 100, 300L);
            }
            return isReady;
        }

        int checkLength() throws IOException {
            return FileWorker.checkLength(this.file, this.localFile);
        }

        static int checkLength(Path file, File localFile) throws IOException {
            long length = dfs.getFileStatus(file).getLen();
            Assert.assertEquals((long)localFile.length(), (long)length);
            Assert.assertTrue((length <= Integer.MAX_VALUE ? 1 : 0) != 0);
            return (int)length;
        }

        String checkFullFile() throws IOException {
            return FileWorker.checkFullFile(this.file, this.localFile);
        }

        static String checkFullFile(Path file, File localFile) throws IOException {
            StringBuilder b = new StringBuilder("checkFullFile: ").append(file.getName()).append(" vs ").append(localFile);
            byte[] bytes = new byte[FileWorker.checkLength(file, localFile)];
            b.append(", length=").append(bytes.length);
            FileInputStream in = new FileInputStream(localFile);
            for (int n = 0; n < bytes.length; n += in.read(bytes, n, bytes.length - n)) {
            }
            in.close();
            AppendTestUtil.checkFullFile((FileSystem)dfs, file, bytes.length, bytes, "File content mismatch: " + b, false);
            return b.toString();
        }
    }

    static class DirWorker
    extends Worker {
        final Path dir;
        final File localDir;
        final FileWorker[] files;
        private Map<String, Path> snapshotPaths = new HashMap<String, Path>();
        private AtomicInteger snapshotCount = new AtomicInteger();

        DirWorker(Path dir, File localDir, int nFiles) throws IOException {
            super(dir.getName());
            this.dir = dir;
            this.localDir = localDir;
            this.files = new FileWorker[nFiles];
            for (int i = 0; i < this.files.length; ++i) {
                this.files[i] = new FileWorker(dir, localDir, String.format("file%02d", i));
            }
        }

        static String getSnapshotName(int n) {
            return String.format("s%02d", n);
        }

        String createSnapshot(String snapshot) throws IOException {
            StringBuilder b = new StringBuilder("createSnapshot: ").append(snapshot).append(" for ").append(this.dir);
            File subDir = new File(this.localDir, snapshot);
            Assert.assertFalse((boolean)subDir.exists());
            subDir.mkdir();
            for (File f : this.localDir.listFiles(FILE_ONLY)) {
                FileUtils.copyFile((File)f, (File)new File(subDir, f.getName()));
            }
            Path p = dfs.createSnapshot(this.dir, snapshot);
            this.snapshotPaths.put(snapshot, p);
            return b.toString();
        }

        String checkSnapshot(String snapshot) throws IOException {
            StringBuilder b = new StringBuilder("checkSnapshot: ").append(snapshot);
            File subDir = new File(this.localDir, snapshot);
            Assert.assertTrue((boolean)subDir.exists());
            Object[] localFiles = subDir.listFiles(FILE_ONLY);
            Path p = this.snapshotPaths.get(snapshot);
            Object[] statuses = dfs.listStatus(p);
            Assert.assertEquals((long)localFiles.length, (long)statuses.length);
            b.append(p).append(" vs ").append(subDir).append(", ").append(statuses.length).append(" entries");
            Arrays.sort(localFiles);
            Arrays.sort(statuses);
            for (int i = 0; i < statuses.length; ++i) {
                FileWorker.checkFullFile(statuses[i].getPath(), (File)localFiles[i]);
            }
            return b.toString();
        }

        String deleteSnapshot(String snapshot) throws IOException {
            StringBuilder b = new StringBuilder("deleteSnapshot: ").append(snapshot).append(" from ").append(this.dir);
            FileUtil.fullyDelete((File)new File(this.localDir, snapshot));
            dfs.deleteSnapshot(this.dir, snapshot);
            this.snapshotPaths.remove(snapshot);
            return b.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() throws Exception {
            int op = ThreadLocalRandom.current().nextInt(6);
            if (op <= 1) {
                this.pauseAllFiles();
                try {
                    String snapshot = DirWorker.getSnapshotName(this.snapshotCount.getAndIncrement());
                    String string = this.createSnapshot(snapshot);
                    return string;
                }
                finally {
                    this.startAllFiles();
                }
            }
            if (op <= 3) {
                String[] keys = this.snapshotPaths.keySet().toArray(EMPTY_STRINGS);
                if (keys.length == 0) {
                    return "NO-OP";
                }
                String snapshot = keys[ThreadLocalRandom.current().nextInt(keys.length)];
                String s = this.checkSnapshot(snapshot);
                if (op == 2) {
                    return this.deleteSnapshot(snapshot);
                }
                return s;
            }
            return "NO-OP";
        }

        void pauseAllFiles() {
            for (FileWorker f : this.files) {
                f.pause();
            }
            int i = 0;
            while (i < this.files.length) {
                DirWorker.sleep(100L);
                while (i < this.files.length && this.files[i].isPaused()) {
                    ++i;
                }
            }
        }

        void startAllFiles() {
            for (FileWorker f : this.files) {
                f.start();
            }
        }

        void stopAllFiles() throws InterruptedException {
            for (FileWorker f : this.files) {
                f.stop();
            }
        }

        void checkEverything() throws IOException {
            LOG.info("checkEverything");
            for (FileWorker f : this.files) {
                f.checkFullFile();
                f.checkErrorState();
            }
            for (String snapshot : this.snapshotPaths.keySet()) {
                this.checkSnapshot(snapshot);
            }
            this.checkErrorState();
        }
    }
}

