/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.DefaultOutputter;
import org.apache.hadoop.tools.rumen.DeskewedJobTraceReader;
import org.apache.hadoop.tools.rumen.JobTraceReader;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.Outputter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Folder
extends Configured
implements Tool {
    private long outputDuration = -1L;
    private long inputCycle = -1L;
    private double concentration = 1.0;
    private long randomSeed = 0L;
    private boolean seeded = false;
    private boolean debug = false;
    private boolean allowMissorting = false;
    private int skewBufferLength = 0;
    private long startsAfter = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(Folder.class);
    private DeskewedJobTraceReader reader = null;
    private Outputter<LoggedJob> outGen = null;
    private List<Path> tempPaths = new LinkedList<Path>();
    private Path tempDir = null;
    private long firstJobSubmitTime;
    private double timeDilation;
    private double transcriptionRateFraction;
    private int transcriptionRateInteger;
    private Random random;
    private static final long TICKS_PER_SECOND = 1000L;
    private static final int NON_EXISTENT_FILES = 1;
    private static final int NO_INPUT_CYCLE_LENGTH = 2;
    private static final int EMPTY_JOB_TRACE = 3;
    private static final int OUT_OF_ORDER_JOBS = 4;
    private static final int ALL_JOBS_SIMULTANEOUS = 5;
    private static final int IO_ERROR = 6;
    private static final int OTHER_ERROR = 7;
    private Set<Closeable> closees = new HashSet<Closeable>();
    private Set<Path> deletees = new HashSet<Path>();

    static long parseDuration(String durationString) {
        String numeral = durationString.substring(0, durationString.length() - 1);
        char durationCode = durationString.charAt(durationString.length() - 1);
        long result = Integer.parseInt(numeral);
        if (result <= 0L) {
            throw new IllegalArgumentException("Negative durations are not allowed");
        }
        switch (durationCode) {
            case 'D': 
            case 'd': {
                return 86400000L * result;
            }
            case 'H': 
            case 'h': {
                return 3600000L * result;
            }
            case 'M': 
            case 'm': {
                return 60000L * result;
            }
            case 'S': 
            case 's': {
                return 1000L * result;
            }
        }
        throw new IllegalArgumentException("Missing or invalid duration code");
    }

    private int initialize(String[] args) throws IllegalArgumentException {
        String tempDirName = null;
        String inputPathName = null;
        String outputPathName = null;
        for (int i = 0; i < args.length; ++i) {
            String thisArg = args[i];
            if (thisArg.equalsIgnoreCase("-starts-after")) {
                this.startsAfter = Folder.parseDuration(args[++i]);
                continue;
            }
            if (thisArg.equalsIgnoreCase("-output-duration")) {
                this.outputDuration = Folder.parseDuration(args[++i]);
                continue;
            }
            if (thisArg.equalsIgnoreCase("-input-cycle")) {
                this.inputCycle = Folder.parseDuration(args[++i]);
                continue;
            }
            if (thisArg.equalsIgnoreCase("-concentration")) {
                this.concentration = Double.parseDouble(args[++i]);
                continue;
            }
            if (thisArg.equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            if (thisArg.equalsIgnoreCase("-allow-missorting")) {
                this.allowMissorting = true;
                continue;
            }
            if (thisArg.equalsIgnoreCase("-seed")) {
                this.seeded = true;
                this.randomSeed = Long.parseLong(args[++i]);
                continue;
            }
            if (thisArg.equalsIgnoreCase("-skew-buffer-length")) {
                this.skewBufferLength = Integer.parseInt(args[++i]);
                continue;
            }
            if (thisArg.equalsIgnoreCase("-temp-directory")) {
                tempDirName = args[++i];
                continue;
            }
            if (thisArg.equals("") || thisArg.startsWith("-")) {
                throw new IllegalArgumentException("Illegal switch argument, " + thisArg + " at position " + i);
            }
            inputPathName = thisArg;
            outputPathName = args[++i];
            if (i == args.length - 1) continue;
            throw new IllegalArgumentException("Too many non-switch arguments");
        }
        try {
            Configuration conf = this.getConf();
            Path inPath = new Path(inputPathName);
            this.reader = new DeskewedJobTraceReader(new JobTraceReader(inPath, conf), this.skewBufferLength, !this.allowMissorting);
            Path outPath = new Path(outputPathName);
            this.outGen = new DefaultOutputter<LoggedJob>();
            this.outGen.init(outPath, conf);
            this.tempDir = tempDirName == null ? outPath.getParent() : new Path(tempDirName);
            FileSystem fs = this.tempDir.getFileSystem(this.getConf());
            if (!fs.getFileStatus(this.tempDir).isDirectory()) {
                throw new IOException("Your temp directory is not a directory");
            }
            if (this.inputCycle <= 0L) {
                LOG.error("You must have an input cycle length.");
                return 2;
            }
            if (this.outputDuration <= 0L) {
                this.outputDuration = 3600000L;
            }
            if (this.inputCycle <= 0L) {
                this.inputCycle = this.outputDuration;
            }
            this.timeDilation = (double)this.outputDuration / (double)this.inputCycle;
            Random random = this.random = this.seeded ? new Random(this.randomSeed) : new Random();
            if (this.debug) {
                this.randomSeed = this.random.nextLong();
                LOG.warn("This run effectively has a -seed of " + this.randomSeed);
                this.random = new Random(this.randomSeed);
                this.seeded = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return 1;
        }
        return 0;
    }

    public int run(String[] args) throws IOException {
        int result = this.initialize(args);
        if (result != 0) {
            return result;
        }
        return this.run();
    }

    /*
     * Exception decompiling
     */
    public int run() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CATCHBLOCK], 21[CATCHBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void maybeOutput(LoggedJob job) throws IOException {
        for (int i = 0; i < this.transcriptionRateInteger; ++i) {
            this.outGen.output(job);
        }
        if (this.random.nextDouble() < this.transcriptionRateFraction) {
            this.outGen.output(job);
        }
    }

    private void adjustJobTimes(LoggedJob adjustee) {
        long offsetInCycle = (adjustee.getSubmitTime() - this.firstJobSubmitTime) % this.inputCycle;
        long outputOffset = (long)((double)offsetInCycle * this.timeDilation);
        long adjustment = this.firstJobSubmitTime + outputOffset - adjustee.getSubmitTime();
        adjustee.adjustTimes(adjustment);
    }

    public static void main(String[] args) {
        Folder instance = new Folder();
        int result = 0;
        try {
            result = ToolRunner.run((Tool)instance, (String[])args);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(6);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(7);
        }
        if (result != 0) {
            System.exit(result);
        }
    }
}

