/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.TestReplicationPolicy;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Before;

public abstract class BaseReplicationPolicyTest {
    protected NetworkTopology cluster;
    protected DatanodeDescriptor[] dataNodes;
    protected static final int BLOCK_SIZE = 1024;
    protected NameNode namenode;
    protected DatanodeManager dnManager;
    protected BlockPlacementPolicy replicator;
    private BlockPlacementPolicy striptedPolicy;
    protected final String filename = "/dummyfile.txt";
    protected DatanodeStorageInfo[] storages;
    protected String blockPlacementPolicy;
    protected NamenodeProtocols nameNodeRpc;

    public BaseReplicationPolicyTest() {
        GenericTestUtils.setLogLevel(BlockPlacementPolicy.LOG, Level.ALL);
        this.filename = "/dummyfile.txt";
        this.nameNodeRpc = null;
    }

    static void updateHeartbeatWithUsage(DatanodeDescriptor dn, long capacity, long dfsUsed, long remaining, long blockPoolUsed, long dnCacheCapacity, long dnCacheUsed, int xceiverCount, int volFailures) {
        dn.getStorageInfos()[0].setUtilizationForTesting(capacity, dfsUsed, remaining, blockPoolUsed);
        dn.updateHeartbeat(BlockManagerTestUtil.getStorageReportsForDatanode(dn), dnCacheCapacity, dnCacheUsed, xceiverCount, volFailures, null);
    }

    abstract DatanodeDescriptor[] getDatanodeDescriptors(Configuration var1);

    @Before
    public void setupCluster() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.dataNodes = this.getDatanodeDescriptors((Configuration)conf);
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "0.0.0.0:0");
        File baseDir = PathUtils.getTestDir(TestReplicationPolicy.class);
        conf.set("dfs.namenode.name.dir", new File(baseDir, "name").getPath());
        conf.set("dfs.block.replicator.classname", this.blockPlacementPolicy);
        conf.setBoolean("dfs.namenode.avoid.read.stale.datanode", true);
        conf.setBoolean("dfs.namenode.avoid.write.stale.datanode", true);
        DFSTestUtil.formatNameNode((Configuration)conf);
        this.namenode = new NameNode((Configuration)conf);
        this.nameNodeRpc = this.namenode.getRpcServer();
        BlockManager bm = this.namenode.getNamesystem().getBlockManager();
        this.replicator = bm.getBlockPlacementPolicy();
        this.striptedPolicy = bm.getStriptedBlockPlacementPolicy();
        this.cluster = bm.getDatanodeManager().getNetworkTopology();
        this.dnManager = bm.getDatanodeManager();
        for (int i = 0; i < this.dataNodes.length; ++i) {
            this.cluster.add((Node)this.dataNodes[i]);
            bm.getDatanodeManager().getHeartbeatManager().addDatanode(this.dataNodes[i]);
            bm.getDatanodeManager().getHeartbeatManager().updateDnStat(this.dataNodes[i]);
        }
        this.updateHeartbeatWithUsage();
    }

    void updateHeartbeatWithUsage() {
        for (int i = 0; i < this.dataNodes.length; ++i) {
            BaseReplicationPolicyTest.updateHeartbeatWithUsage(this.dataNodes[i], 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
        }
    }

    public BlockPlacementPolicy getStriptedPolicy() {
        return this.striptedPolicy;
    }

    @After
    public void tearDown() throws Exception {
        this.namenode.stop();
    }

    boolean isOnSameRack(DatanodeStorageInfo left, DatanodeStorageInfo right) {
        return this.isOnSameRack(left, right.getDatanodeDescriptor());
    }

    boolean isOnSameRack(DatanodeStorageInfo left, DatanodeDescriptor right) {
        return this.cluster.isOnSameRack((Node)left.getDatanodeDescriptor(), (Node)right);
    }

    DatanodeStorageInfo[] chooseTarget(int numOfReplicas) {
        return this.chooseTarget(numOfReplicas, this.dataNodes[0]);
    }

    DatanodeStorageInfo[] chooseTarget(int numOfReplicas, DatanodeDescriptor writer) {
        return this.chooseTarget(numOfReplicas, writer, new ArrayList<DatanodeStorageInfo>());
    }

    DatanodeStorageInfo[] chooseTarget(int numOfReplicas, List<DatanodeStorageInfo> chosenNodes) {
        return this.chooseTarget(numOfReplicas, this.dataNodes[0], chosenNodes);
    }

    DatanodeStorageInfo[] chooseTarget(int numOfReplicas, DatanodeDescriptor writer, List<DatanodeStorageInfo> chosenNodes) {
        return this.chooseTarget(numOfReplicas, writer, chosenNodes, null);
    }

    DatanodeStorageInfo[] chooseTarget(int numOfReplicas, List<DatanodeStorageInfo> chosenNodes, Set<Node> excludedNodes) {
        return this.chooseTarget(numOfReplicas, this.dataNodes[0], chosenNodes, excludedNodes);
    }

    DatanodeStorageInfo[] chooseTarget(int numOfReplicas, DatanodeDescriptor writer, List<DatanodeStorageInfo> chosenNodes, Set<Node> excludedNodes) {
        return this.replicator.chooseTarget("/dummyfile.txt", numOfReplicas, (Node)writer, chosenNodes, false, excludedNodes, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
    }
}

