/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.DNSDomainNameResolver;
import org.apache.hadoop.net.DomainNameResolver;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class DomainNameResolverFactory {
    private DomainNameResolverFactory() {
    }

    public static DomainNameResolver newInstance(Configuration conf, URI uri, String configKey) throws IOException {
        String host = uri.getHost();
        String confKeyWithHost = configKey + "." + host;
        return DomainNameResolverFactory.newInstance(conf, confKeyWithHost);
    }

    public static DomainNameResolver newInstance(Configuration conf, String configKey) {
        Class<DomainNameResolver> resolverClass = conf.getClass(configKey, DNSDomainNameResolver.class, DomainNameResolver.class);
        return ReflectionUtils.newInstance(resolverClass, conf);
    }
}

