/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.files;

import com.amazonaws.services.s3.model.PartETag;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.commit.CommitUtils;
import org.apache.hadoop.fs.s3a.commit.ValidationFailure;
import org.apache.hadoop.fs.s3a.commit.files.PersistentCommitData;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.hadoop.util.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SinglePendingCommit
extends PersistentCommitData<SinglePendingCommit>
implements Iterable<String> {
    private static final long serialVersionUID = 65538L;
    private int version = 2;
    private String filename;
    private String uri = "";
    private String uploadId;
    private String bucket;
    private String destinationKey;
    private long created;
    private long saved;
    private String date;
    private String jobId = "";
    private String taskId = "";
    private String text = "";
    private List<String> etags;
    private Map<String, String> extraData = new HashMap<String, String>(0);
    @JsonProperty(value="iostatistics")
    private IOStatisticsSnapshot iostats = new IOStatisticsSnapshot();
    private long length;

    public static JsonSerialization<SinglePendingCommit> serializer() {
        return new JsonSerialization(SinglePendingCommit.class, false, false);
    }

    public static SinglePendingCommit load(FileSystem fs, Path path, FileStatus status, JsonSerialization<SinglePendingCommit> serDeser) throws IOException {
        return SinglePendingCommit.load(fs, path, serDeser, null);
    }

    public static SinglePendingCommit load(FileSystem fs, Path path, JsonSerialization<SinglePendingCommit> serDeser, @Nullable FileStatus status) throws IOException {
        JsonSerialization<SinglePendingCommit> jsonSerialization = serDeser != null ? serDeser : SinglePendingCommit.serializer();
        SinglePendingCommit instance = (SinglePendingCommit)jsonSerialization.load(fs, path, status);
        instance.filename = path.toString();
        instance.validate();
        return instance;
    }

    private void readObject(ObjectInputStream inStream) throws IOException, ClassNotFoundException {
        inStream.defaultReadObject();
        this.validate();
    }

    public void touch(long millis) {
        this.created = millis;
        this.saved = millis;
        this.date = new Date(millis).toString();
    }

    public void bindCommitData(List<PartETag> parts) throws ValidationFailure {
        this.etags = new ArrayList<String>(parts.size());
        int counter = 1;
        for (PartETag part : parts) {
            ValidationFailure.verify(part.getPartNumber() == counter, "Expected part number %s but got %s", counter, part.getPartNumber());
            this.etags.add(part.getETag());
            ++counter;
        }
    }

    @Override
    public void validate() throws ValidationFailure {
        ValidationFailure.verify(this.version == 2, "Wrong version: %s", this.version);
        ValidationFailure.verify(StringUtils.isNotEmpty((CharSequence)this.bucket), "Empty bucket", new Object[0]);
        ValidationFailure.verify(StringUtils.isNotEmpty((CharSequence)this.destinationKey), "Empty destination", new Object[0]);
        ValidationFailure.verify(StringUtils.isNotEmpty((CharSequence)this.uploadId), "Empty uploadId", new Object[0]);
        ValidationFailure.verify(this.length >= 0L, "Invalid length: " + this.length, new Object[0]);
        this.destinationPath();
        ValidationFailure.verify(this.etags != null, "No etag list", new Object[0]);
        CommitUtils.validateCollectionClass(this.etags, String.class);
        for (String etag : this.etags) {
            ValidationFailure.verify(StringUtils.isNotEmpty((CharSequence)etag), "Empty etag", new Object[0]);
        }
        if (this.extraData != null) {
            CommitUtils.validateCollectionClass(this.extraData.keySet(), String.class);
            CommitUtils.validateCollectionClass(this.extraData.values(), String.class);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SinglePendingCommit{");
        sb.append("version=").append(this.version);
        sb.append(", uri='").append(this.uri).append('\'');
        sb.append(", destination='").append(this.destinationKey).append('\'');
        sb.append(", uploadId='").append(this.uploadId).append('\'');
        sb.append(", created=").append(this.created);
        sb.append(", saved=").append(this.saved);
        sb.append(", size=").append(this.length);
        sb.append(", date='").append(this.date).append('\'');
        sb.append(", jobId='").append(this.jobId).append('\'');
        sb.append(", taskId='").append(this.taskId).append('\'');
        sb.append(", notes='").append(this.text).append('\'');
        if (this.etags != null) {
            sb.append(", etags=[");
            sb.append(org.apache.hadoop.util.StringUtils.join((CharSequence)",", this.etags));
            sb.append(']');
        } else {
            sb.append(", etags=null");
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public byte[] toBytes(JsonSerialization<SinglePendingCommit> serializer) throws IOException {
        this.validate();
        return serializer.toBytes((Object)this);
    }

    @Override
    public IOStatistics save(FileSystem fs, Path path, JsonSerialization<SinglePendingCommit> serializer) throws IOException {
        return SinglePendingCommit.saveFile(fs, path, this, serializer, true);
    }

    public Path destinationPath() {
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)this.uri), (Object)"Empty uri");
        try {
            return new Path(new URI(this.uri));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot parse URI " + this.uri);
        }
    }

    public int getPartCount() {
        return this.etags.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.etags.iterator();
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getDestinationKey() {
        return this.destinationKey;
    }

    public void setDestinationKey(String destinationKey) {
        this.destinationKey = destinationKey;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public long getSaved() {
        return this.saved;
    }

    public void setSaved(long saved) {
        this.saved = saved;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<String> getEtags() {
        return this.etags;
    }

    public void setEtags(List<String> etags) {
        this.etags = etags;
    }

    public Map<String, String> getExtraData() {
        return this.extraData;
    }

    public void setExtraData(Map<String, String> extraData) {
        this.extraData = extraData;
    }

    public void putExtraData(String key, String value) {
        this.extraData.put(key, value);
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public IOStatisticsSnapshot getIOStatistics() {
        return this.iostats;
    }

    public void setIOStatistics(IOStatisticsSnapshot ioStatistics) {
        this.iostats = ioStatistics;
    }
}

