/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.amazonaws.SdkBaseException;
import com.amazonaws.services.s3.transfer.Copy;
import com.amazonaws.services.s3.transfer.model.CopyResult;

public final class CopyOutcome {
    private final CopyResult copyResult;
    private final InterruptedException interruptedException;
    private final SdkBaseException awsException;

    public CopyOutcome(CopyResult copyResult, InterruptedException interruptedException, SdkBaseException awsException) {
        this.copyResult = copyResult;
        this.interruptedException = interruptedException;
        this.awsException = awsException;
    }

    public CopyResult getCopyResult() {
        return this.copyResult;
    }

    public InterruptedException getInterruptedException() {
        return this.interruptedException;
    }

    public SdkBaseException getAwsException() {
        return this.awsException;
    }

    public static CopyOutcome waitForCopy(Copy copy) {
        try {
            CopyResult result = copy.waitForCopyResult();
            return new CopyOutcome(result, null, null);
        }
        catch (SdkBaseException e) {
            return new CopyOutcome(null, null, e);
        }
        catch (InterruptedException e) {
            return new CopyOutcome(null, e, null);
        }
    }
}

