/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.List;
import org.apache.hadoop.fs.s3a.AWSS3IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiObjectDeleteSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MultiObjectDeleteSupport.class);
    public static final String ACCESS_DENIED = "AccessDenied";

    private MultiObjectDeleteSupport() {
    }

    public static IOException translateDeleteException(String message, MultiObjectDeleteException deleteException) {
        List errors = deleteException.getErrors();
        LOG.info("Bulk delete operation failed to delete all objects; failure count = {}", (Object)errors.size());
        StringBuilder result = new StringBuilder(errors.size() * 256);
        result.append(message).append(": ");
        String exitCode = "";
        for (MultiObjectDeleteException.DeleteError error : deleteException.getErrors()) {
            String code = error.getCode();
            String item = String.format("%s: %s%s: %s%n", code, error.getKey(), error.getVersionId() != null ? " (" + error.getVersionId() + ")" : "", error.getMessage());
            LOG.info(item);
            result.append(item);
            if (exitCode != null && !exitCode.isEmpty() && !ACCESS_DENIED.equals(code)) continue;
            exitCode = code;
        }
        if (ACCESS_DENIED.equals(exitCode)) {
            return (IOException)new AccessDeniedException(result.toString()).initCause(deleteException);
        }
        return new AWSS3IOException(result.toString(), (AmazonS3Exception)((Object)deleteException));
    }
}

