/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;

public class RouterConfigBuilder {
    private Configuration conf;
    private boolean enableRpcServer = false;
    private boolean enableAdminServer = false;
    private boolean enableHttpServer = false;
    private boolean enableHeartbeat = false;
    private boolean enableLocalHeartbeat = false;
    private boolean enableStateStore = false;
    private boolean enableMetrics = false;
    private boolean enableQuota = false;
    private boolean enableSafemode = false;
    private boolean enableCacheRefresh;

    public RouterConfigBuilder(Configuration configuration) {
        this.conf = configuration;
    }

    public RouterConfigBuilder() {
        this.conf = new Configuration(false);
    }

    public RouterConfigBuilder all() {
        this.enableRpcServer = true;
        this.enableAdminServer = true;
        this.enableHttpServer = true;
        this.enableHeartbeat = true;
        this.enableLocalHeartbeat = true;
        this.enableStateStore = true;
        this.enableMetrics = true;
        this.enableSafemode = true;
        return this;
    }

    public RouterConfigBuilder enableLocalHeartbeat(boolean enable) {
        this.enableLocalHeartbeat = enable;
        return this;
    }

    public RouterConfigBuilder rpc(boolean enable) {
        this.enableRpcServer = enable;
        return this;
    }

    public RouterConfigBuilder admin(boolean enable) {
        this.enableAdminServer = enable;
        return this;
    }

    public RouterConfigBuilder http(boolean enable) {
        this.enableHttpServer = enable;
        return this;
    }

    public RouterConfigBuilder heartbeat(boolean enable) {
        this.enableHeartbeat = enable;
        return this;
    }

    public RouterConfigBuilder stateStore(boolean enable) {
        this.enableStateStore = enable;
        return this;
    }

    public RouterConfigBuilder metrics(boolean enable) {
        this.enableMetrics = enable;
        return this;
    }

    public RouterConfigBuilder quota(boolean enable) {
        this.enableQuota = enable;
        return this;
    }

    public RouterConfigBuilder safemode(boolean enable) {
        this.enableSafemode = enable;
        return this;
    }

    public RouterConfigBuilder refreshCache(boolean enable) {
        this.enableCacheRefresh = enable;
        return this;
    }

    public RouterConfigBuilder rpc() {
        return this.rpc(true);
    }

    public RouterConfigBuilder admin() {
        return this.admin(true);
    }

    public RouterConfigBuilder http() {
        return this.http(true);
    }

    public RouterConfigBuilder heartbeat() {
        return this.heartbeat(true);
    }

    public RouterConfigBuilder stateStore() {
        this.conf.setClass("dfs.federation.router.store.driver.class", FederationStateStoreTestUtils.getTestDriverClass(), StateStoreDriver.class);
        return this.stateStore(true);
    }

    public RouterConfigBuilder metrics() {
        return this.metrics(true);
    }

    public RouterConfigBuilder quota() {
        return this.quota(true);
    }

    public RouterConfigBuilder safemode() {
        return this.safemode(true);
    }

    public RouterConfigBuilder refreshCache() {
        return this.refreshCache(true);
    }

    public Configuration build() {
        this.conf.setBoolean("dfs.federation.router.store.enable", this.enableStateStore);
        this.conf.setBoolean("dfs.federation.router.rpc.enable", this.enableRpcServer);
        if (this.enableRpcServer) {
            this.conf.set("dfs.federation.router.rpc-address", "127.0.0.1:0");
            this.conf.set("dfs.federation.router.rpc-bind-host", "0.0.0.0");
        }
        this.conf.setBoolean("dfs.federation.router.admin.enable", this.enableAdminServer);
        if (this.enableAdminServer) {
            this.conf.set("dfs.federation.router.admin-address", "127.0.0.1:0");
            this.conf.set("dfs.federation.router.admin-bind-host", "0.0.0.0");
        }
        this.conf.setBoolean("dfs.federation.router.http.enable", this.enableHttpServer);
        if (this.enableHttpServer) {
            this.conf.set("dfs.federation.router.http-address", "127.0.0.1:0");
            this.conf.set("dfs.federation.router.https-address", "127.0.0.1:0");
            this.conf.set("dfs.federation.router.http-bind-host", "0.0.0.0");
        }
        this.conf.setBoolean("dfs.federation.router.heartbeat.enable", this.enableHeartbeat);
        this.conf.setBoolean("dfs.federation.router.monitor.localnamenode.enable", this.enableLocalHeartbeat);
        this.conf.setBoolean("dfs.federation.router.metrics.enable", this.enableMetrics);
        this.conf.setBoolean("dfs.federation.router.quota.enable", this.enableQuota);
        this.conf.setBoolean("dfs.federation.router.safemode.enable", this.enableSafemode);
        this.conf.setBoolean("dfs.federation.router.mount-table.cache.update", this.enableCacheRefresh);
        return this.conf;
    }
}

