/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.metrics.RBFMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.MembershipNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.router.NameserviceManager;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.store.DisabledNameserviceStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.DisableNameserviceRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.Time;
import org.codehaus.jettison.json.JSONObject;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDisableNameservices {
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static RouterClient routerAdminClient;
    private static ClientProtocol routerProtocol;

    @BeforeClass
    public static void setUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 2);
        Configuration routerConf = new RouterConfigBuilder().stateStore().metrics().admin().rpc().build();
        routerConf.setInt("dfs.federation.router.handler.count", 8);
        routerConf.setInt("dfs.federation.router.client.thread-size", 4);
        cluster.setIndependentDNs();
        cluster.addRouterOverrides(routerConf);
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        routerContext = cluster.getRandomRouter();
        routerProtocol = routerContext.getClient().getNamenode();
        routerAdminClient = routerContext.getAdminClient();
        TestDisableNameservices.setupNamespace();
        MiniDFSCluster dfsCluster = cluster.getCluster();
        NameNode nn0 = dfsCluster.getNameNode(0);
        FederationTestUtils.simulateSlowNamenode(nn0, 1);
    }

    private static void setupNamespace() throws IOException {
        MountTableManager mountTable = routerAdminClient.getMountTableManager();
        TreeMap<String, String> destinations = new TreeMap<String, String>();
        destinations.put("ns0", "/dirns0");
        MountTable newEntry = MountTable.newInstance((String)"/dirns0", destinations);
        AddMountTableEntryRequest request = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        mountTable.addMountTableEntry(request);
        destinations = new TreeMap();
        destinations.put("ns1", "/dirns1");
        newEntry = MountTable.newInstance((String)"/dirns1", destinations);
        request = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        mountTable.addMountTableEntry(request);
        Router router = routerContext.getRouter();
        MountTableResolver mountTableResolver = (MountTableResolver)router.getSubclusterResolver();
        mountTableResolver.loadCache(true);
        MiniRouterDFSCluster.NamenodeContext nn0 = cluster.getNamenode("ns0", null);
        nn0.getFileSystem().mkdirs(new Path("/dirns0/0"));
        nn0.getFileSystem().mkdirs(new Path("/dir-ns"));
        MiniRouterDFSCluster.NamenodeContext nn1 = cluster.getNamenode("ns1", null);
        nn1.getFileSystem().mkdirs(new Path("/dirns1/1"));
    }

    @AfterClass
    public static void tearDown() {
        if (cluster != null) {
            cluster.stopRouter(routerContext);
            cluster.shutdown();
            cluster = null;
        }
    }

    @After
    public void cleanup() throws IOException {
        Router router = routerContext.getRouter();
        StateStoreService stateStore = router.getStateStore();
        DisabledNameserviceStore store = (DisabledNameserviceStore)stateStore.getRegisteredRecordStore(DisabledNameserviceStore.class);
        store.loadCache(true);
        Set disabled = store.getDisabledNameservices();
        for (String nsId : disabled) {
            store.enableNameservice(nsId);
        }
        store.loadCache(true);
    }

    @Test
    public void testWithoutDisabling() throws IOException {
        long t0 = Time.monotonicNow();
        routerProtocol.renewLease("client0");
        long t = Time.monotonicNow() - t0;
        Assert.assertTrue((String)("It took too little: " + t + "ms"), (t > TimeUnit.SECONDS.toMillis(1L) ? 1 : 0) != 0);
        FileSystem routerFs = routerContext.getFileSystem();
        FileStatus[] filesStatus = routerFs.listStatus(new Path("/"));
        Assert.assertEquals((long)3L, (long)filesStatus.length);
        Assert.assertEquals((Object)"dir-ns", (Object)filesStatus[0].getPath().getName());
        Assert.assertEquals((Object)"dirns0", (Object)filesStatus[1].getPath().getName());
        Assert.assertEquals((Object)"dirns1", (Object)filesStatus[2].getPath().getName());
    }

    @Test
    public void testDisabling() throws Exception {
        TestDisableNameservices.disableNameservice("ns0");
        long t0 = Time.monotonicNow();
        routerProtocol.renewLease("client0");
        long t = Time.monotonicNow() - t0;
        Assert.assertTrue((String)("It took too long: " + t + "ms"), (t < TimeUnit.SECONDS.toMillis(1L) ? 1 : 0) != 0);
        FileSystem routerFs = routerContext.getFileSystem();
        FileStatus[] filesStatus = routerFs.listStatus(new Path("/"));
        Assert.assertEquals((long)2L, (long)filesStatus.length);
        Assert.assertEquals((Object)"dirns0", (Object)filesStatus[0].getPath().getName());
        Assert.assertEquals((Object)"dirns1", (Object)filesStatus[1].getPath().getName());
        filesStatus = routerFs.listStatus(new Path("/dirns1"));
        Assert.assertEquals((long)1L, (long)filesStatus.length);
        Assert.assertEquals((Object)"1", (Object)filesStatus[0].getPath().getName());
    }

    @Test
    public void testMetrics() throws Exception {
        TestDisableNameservices.disableNameservice("ns0");
        int numActive = 0;
        int numDisabled = 0;
        Router router = routerContext.getRouter();
        RBFMetrics metrics = router.getMetrics();
        String jsonString = metrics.getNameservices();
        JSONObject jsonObject = new JSONObject(jsonString);
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            JSONObject json = jsonObject.getJSONObject(key);
            String nsId = json.getString("nameserviceId");
            String state = json.getString("state");
            if (nsId.equals("ns0")) {
                Assert.assertEquals((Object)"DISABLED", (Object)state);
                ++numDisabled;
                continue;
            }
            Assert.assertEquals((Object)"ACTIVE", (Object)state);
            ++numActive;
        }
        Assert.assertEquals((long)1L, (long)numActive);
        Assert.assertEquals((long)1L, (long)numDisabled);
    }

    private static void disableNameservice(String nsId) throws IOException {
        NameserviceManager nsManager = routerAdminClient.getNameserviceManager();
        DisableNameserviceRequest req = DisableNameserviceRequest.newInstance((String)nsId);
        nsManager.disableNameservice(req);
        Router router = routerContext.getRouter();
        StateStoreService stateStore = router.getStateStore();
        DisabledNameserviceStore store = (DisabledNameserviceStore)stateStore.getRegisteredRecordStore(DisabledNameserviceStore.class);
        store.loadCache(true);
        MembershipNamenodeResolver resolver = (MembershipNamenodeResolver)router.getNamenodeResolver();
        resolver.loadCache(true);
    }
}

