/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.junit.Assert;
import org.junit.Test;

public class TestFederationUtil {
    @Test
    public void testInstanceCreation() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setClass("dfs.federation.router.namenode.resolver.client.class", MockResolver.class, ActiveNamenodeResolver.class);
        conf.setClass("dfs.federation.router.file.resolver.client.class", MockResolver.class, FileSubclusterResolver.class);
        Router router = new Router();
        StateStoreService stateStore = new StateStoreService();
        ActiveNamenodeResolver namenodeResolverWithContext = FederationUtil.newActiveNamenodeResolver((Configuration)conf, (StateStoreService)stateStore);
        ActiveNamenodeResolver namenodeResolverWithoutContext = FederationUtil.newActiveNamenodeResolver((Configuration)conf, null);
        FileSubclusterResolver subclusterResolverWithContext = FederationUtil.newFileSubclusterResolver((Configuration)conf, (Router)router);
        FileSubclusterResolver subclusterResolverWithoutContext = FederationUtil.newFileSubclusterResolver((Configuration)conf, null);
        Assert.assertNotNull((Object)namenodeResolverWithContext);
        Assert.assertNotNull((Object)namenodeResolverWithoutContext);
        Assert.assertNotNull((Object)subclusterResolverWithContext);
        Assert.assertNotNull((Object)subclusterResolverWithoutContext);
    }
}

