/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.registry;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceId;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnRegistryViewForProviders {
    private static final Logger LOG = LoggerFactory.getLogger(YarnRegistryViewForProviders.class);
    private final RegistryOperations registryOperations;
    private final String user;
    private final String serviceClass;
    private final String instanceName;
    private ServiceRecord selfRegistration;
    private String selfRegistrationPath;

    public YarnRegistryViewForProviders(RegistryOperations registryOperations, String user, String serviceClass, String instanceName, ApplicationAttemptId applicationAttemptId) {
        Preconditions.checkArgument((registryOperations != null ? 1 : 0) != 0, (Object)"null registry operations");
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"null user");
        Preconditions.checkArgument((boolean)ServiceUtils.isSet(serviceClass), (Object)"unset service class");
        Preconditions.checkArgument((boolean)ServiceUtils.isSet(instanceName), (Object)"instanceName");
        Preconditions.checkArgument((applicationAttemptId != null ? 1 : 0) != 0, (Object)"null applicationAttemptId");
        this.registryOperations = registryOperations;
        this.user = user;
        this.serviceClass = serviceClass;
        this.instanceName = instanceName;
    }

    public String getUser() {
        return this.user;
    }

    private void setSelfRegistration(ServiceRecord selfRegistration) {
        this.selfRegistration = selfRegistration;
    }

    public String getSelfRegistrationPath() {
        return this.selfRegistrationPath;
    }

    public String getAbsoluteSelfRegistrationPath() {
        if (this.selfRegistrationPath == null) {
            return null;
        }
        String root = this.registryOperations.getConfig().getTrimmed("hadoop.registry.zk.root", "/registry");
        return RegistryPathUtils.join((String)root, (String)this.selfRegistrationPath);
    }

    public void putComponent(String componentName, ServiceRecord record) throws IOException {
        this.putComponent(this.serviceClass, this.instanceName, componentName, record);
    }

    public void putComponent(String serviceClass, String serviceName, String componentName, ServiceRecord record) throws IOException {
        String path = RegistryUtils.componentPath((String)this.user, (String)serviceClass, (String)serviceName, (String)componentName);
        this.registryOperations.mknode(RegistryPathUtils.parentOf((String)path), true);
        this.registryOperations.bind(path, record, 1);
    }

    public ServiceRecord getComponent(String componentName) throws IOException {
        String path = RegistryUtils.componentPath((String)this.user, (String)this.serviceClass, (String)this.instanceName, (String)componentName);
        LOG.info("Resolving path {}", (Object)path);
        return this.registryOperations.resolve(path);
    }

    public List<String> listComponents() throws IOException {
        String path = RegistryUtils.componentListPath((String)this.user, (String)this.serviceClass, (String)this.instanceName);
        return this.registryOperations.list(path);
    }

    public String putService(String username, String serviceClass, String serviceName, ServiceRecord record, boolean deleteTreeFirst) throws IOException {
        String path = RegistryUtils.servicePath((String)username, (String)serviceClass, (String)serviceName);
        if (deleteTreeFirst) {
            this.registryOperations.delete(path, true);
        }
        this.registryOperations.mknode(RegistryPathUtils.parentOf((String)path), true);
        this.registryOperations.bind(path, record, 1);
        return path;
    }

    public String registerSelf(ServiceRecord record, boolean deleteTreeFirst) throws IOException {
        this.selfRegistrationPath = this.putService(this.user, this.serviceClass, this.instanceName, record, deleteTreeFirst);
        this.setSelfRegistration(record);
        return this.selfRegistrationPath;
    }

    public void deleteComponent(ComponentInstanceId instanceId, String containerId) throws IOException {
        String path = RegistryUtils.componentPath((String)this.user, (String)this.serviceClass, (String)this.instanceName, (String)containerId);
        LOG.info(instanceId + ": Deleting registry path " + path);
        this.registryOperations.delete(path, false);
    }

    public void deleteChildren(String path, boolean recursive) throws IOException {
        List childNames = null;
        try {
            childNames = this.registryOperations.list(path);
        }
        catch (PathNotFoundException e) {
            return;
        }
        for (String childName : childNames) {
            String child = RegistryPathUtils.join((String)path, (String)childName);
            this.registryOperations.delete(child, recursive);
        }
    }
}

