/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.curator;

import java.util.Arrays;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.util.JaasConfiguration;
import org.apache.hadoop.util.ZKUtil;
import org.apache.hadoop.util.curator.ZKCuratorManager;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestZKCuratorManager {
    private TestingServer server;
    private ZKCuratorManager curator;

    @Before
    public void setup() throws Exception {
        this.server = new TestingServer();
        Configuration conf = new Configuration();
        conf.set("hadoop.zk.address", this.server.getConnectString());
        this.curator = new ZKCuratorManager(conf);
        this.curator.start();
    }

    @After
    public void teardown() throws Exception {
        this.curator.close();
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }

    @Test
    public void testReadWriteData() throws Exception {
        String testZNode = "/test";
        String expectedString = "testString";
        Assert.assertFalse((boolean)this.curator.exists(testZNode));
        this.curator.create(testZNode);
        Assert.assertTrue((boolean)this.curator.exists(testZNode));
        this.curator.setData(testZNode, expectedString, -1);
        String testString = this.curator.getStringData("/test");
        Assert.assertEquals((Object)expectedString, (Object)testString);
    }

    @Test
    public void testChildren() throws Exception {
        List children = this.curator.getChildren("/");
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertFalse((boolean)this.curator.exists("/node1"));
        this.curator.create("/node1");
        Assert.assertTrue((boolean)this.curator.exists("/node1"));
        Assert.assertFalse((boolean)this.curator.exists("/node2"));
        this.curator.create("/node2");
        Assert.assertTrue((boolean)this.curator.exists("/node2"));
        children = this.curator.getChildren("/");
        Assert.assertEquals((long)3L, (long)children.size());
        this.curator.delete("/node2");
        Assert.assertFalse((boolean)this.curator.exists("/node2"));
        children = this.curator.getChildren("/");
        Assert.assertEquals((long)2L, (long)children.size());
    }

    @Test
    public void testGetStringData() throws Exception {
        String node1 = "/node1";
        String node2 = "/node2";
        Assert.assertFalse((boolean)this.curator.exists(node1));
        this.curator.create(node1);
        Assert.assertNull((Object)this.curator.getStringData(node1));
        byte[] setData = "setData".getBytes("UTF-8");
        this.curator.setData(node1, setData, -1);
        Assert.assertEquals((Object)"setData", (Object)this.curator.getStringData(node1));
        Stat stat = new Stat();
        Assert.assertFalse((boolean)this.curator.exists(node2));
        this.curator.create(node2);
        Assert.assertNull((Object)this.curator.getStringData(node2, stat));
        this.curator.setData(node2, setData, -1);
        Assert.assertEquals((Object)"setData", (Object)this.curator.getStringData(node2, stat));
    }

    @Test
    public void testTransaction() throws Exception {
        List zkAcl = ZKUtil.parseACLs((String)"world:anyone:rwcda");
        String fencingNodePath = "/fencing";
        String node1 = "/node1";
        String node2 = "/node2";
        byte[] testData = "testData".getBytes("UTF-8");
        Assert.assertFalse((boolean)this.curator.exists(fencingNodePath));
        Assert.assertFalse((boolean)this.curator.exists(node1));
        Assert.assertFalse((boolean)this.curator.exists(node2));
        ZKCuratorManager.SafeTransaction txn = this.curator.createTransaction(zkAcl, fencingNodePath);
        txn.create(node1, testData, zkAcl, CreateMode.PERSISTENT);
        txn.create(node2, testData, zkAcl, CreateMode.PERSISTENT);
        Assert.assertFalse((boolean)this.curator.exists(fencingNodePath));
        Assert.assertFalse((boolean)this.curator.exists(node1));
        Assert.assertFalse((boolean)this.curator.exists(node2));
        txn.commit();
        Assert.assertFalse((boolean)this.curator.exists(fencingNodePath));
        Assert.assertTrue((boolean)this.curator.exists(node1));
        Assert.assertTrue((boolean)this.curator.exists(node2));
        Assert.assertTrue((boolean)Arrays.equals(testData, this.curator.getData(node1)));
        Assert.assertTrue((boolean)Arrays.equals(testData, this.curator.getData(node2)));
        byte[] setData = "setData".getBytes("UTF-8");
        txn = this.curator.createTransaction(zkAcl, fencingNodePath);
        txn.setData(node1, setData, -1);
        txn.delete(node2);
        Assert.assertTrue((boolean)this.curator.exists(node2));
        Assert.assertTrue((boolean)Arrays.equals(testData, this.curator.getData(node1)));
        txn.commit();
        Assert.assertFalse((boolean)this.curator.exists(node2));
        Assert.assertTrue((boolean)Arrays.equals(setData, this.curator.getData(node1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJaasConfiguration() throws Exception {
        ZKCuratorManager.HadoopZookeeperFactory factory1 = new ZKCuratorManager.HadoopZookeeperFactory("foo1", "bar1", "bar1.keytab");
        ZooKeeper zk1 = factory1.newZooKeeper("connString", 1000, null, false);
        this.validateJaasConfiguration("HadoopZookeeperClient", "bar1", "bar1.keytab", zk1);
        ZKCuratorManager.HadoopZookeeperFactory factory2 = new ZKCuratorManager.HadoopZookeeperFactory("foo2", "bar2", "bar2.keytab");
        ZooKeeper zk2 = factory2.newZooKeeper("connString", 1000, null, false);
        this.validateJaasConfiguration("HadoopZookeeperClient", "bar2", "bar2.keytab", zk2);
        try {
            String testClientConfig = "TestClientConfig";
            JaasConfiguration jconf = new JaasConfiguration(testClientConfig, "test", "test.keytab");
            javax.security.auth.login.Configuration.setConfiguration((javax.security.auth.login.Configuration)jconf);
            System.setProperty("zookeeper.sasl.clientconfig", testClientConfig);
            ZKCuratorManager.HadoopZookeeperFactory factory3 = new ZKCuratorManager.HadoopZookeeperFactory("foo3", "bar3", "bar3.keytab");
            ZooKeeper zk3 = factory3.newZooKeeper("connString", 1000, null, false);
            this.validateJaasConfiguration(testClientConfig, "test", "test.keytab", zk3);
        }
        finally {
            System.clearProperty("zookeeper.sasl.clientconfig");
        }
    }

    private void validateJaasConfiguration(String clientConfig, String principal, String keytab, ZooKeeper zk) {
        Assert.assertEquals((String)"Validate that expected clientConfig is set in ZK config", (Object)clientConfig, (Object)zk.getClientConfig().getProperty("zookeeper.sasl.clientconfig"));
        AppConfigurationEntry[] entries = javax.security.auth.login.Configuration.getConfiguration().getAppConfigurationEntry(clientConfig);
        Assert.assertEquals((String)"Validate that expected principal is set in Jaas config", (Object)principal, entries[0].getOptions().get("principal"));
        Assert.assertEquals((String)"Validate that expected keytab is set in Jaas config", (Object)keytab, entries[0].getOptions().get("keyTab"));
    }
}

