/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp.dao;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.util.Times;

@InterfaceAudience.Public
@InterfaceStability.Evolving
@XmlRootElement(name="container")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ContainerInfo {
    protected String containerId;
    protected long allocatedMB;
    protected long allocatedVCores;
    protected String assignedNodeId;
    protected int priority;
    protected long startedTime;
    protected long finishedTime;
    protected long elapsedTime;
    protected String diagnosticsInfo;
    protected String logUrl;
    protected int containerExitStatus;
    protected ContainerState containerState;
    protected String nodeHttpAddress;
    protected String nodeId;
    protected Map<String, Long> allocatedResources;
    private String exposedPorts;

    public ContainerInfo() {
    }

    public ContainerInfo(ContainerReport container) {
        if (container.getAssignedNode() != null) {
            this.assignedNodeId = container.getAssignedNode().toString();
        }
        this.containerId = container.getContainerId().toString();
        this.priority = container.getPriority().getPriority();
        this.startedTime = container.getCreationTime();
        this.finishedTime = container.getFinishTime();
        this.elapsedTime = Times.elapsed((long)this.startedTime, (long)this.finishedTime);
        this.diagnosticsInfo = container.getDiagnosticsInfo();
        this.logUrl = container.getLogUrl();
        this.containerExitStatus = container.getContainerExitStatus();
        this.containerState = container.getContainerState();
        this.nodeHttpAddress = container.getNodeHttpAddress();
        this.nodeId = container.getAssignedNode().toString();
        this.exposedPorts = container.getExposedPorts();
        Resource allocated = container.getAllocatedResource();
        if (allocated != null) {
            this.allocatedMB = allocated.getMemorySize();
            this.allocatedVCores = allocated.getVirtualCores();
            this.allocatedResources = new HashMap<String, Long>();
            for (ResourceInformation info : allocated.getResources()) {
                this.allocatedResources.put(info.getName(), info.getValue());
            }
        }
    }

    public String getContainerId() {
        return this.containerId;
    }

    public long getAllocatedMB() {
        return this.allocatedMB;
    }

    public long getAllocatedVCores() {
        return this.allocatedVCores;
    }

    public String getAssignedNodeId() {
        return this.assignedNodeId;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getStartedTime() {
        return this.startedTime;
    }

    public long getFinishedTime() {
        return this.finishedTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getDiagnosticsInfo() {
        return this.diagnosticsInfo;
    }

    public String getLogUrl() {
        return this.logUrl;
    }

    public int getContainerExitStatus() {
        return this.containerExitStatus;
    }

    public ContainerState getContainerState() {
        return this.containerState;
    }

    public String getNodeHttpAddress() {
        return this.nodeHttpAddress;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Map<String, Long> getAllocatedResources() {
        return Collections.unmodifiableMap(this.allocatedResources);
    }

    public String getExposedPorts() {
        return this.exposedPorts;
    }

    public boolean hasCustomResources() {
        return this.allocatedResources.size() > 2;
    }
}

