/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestURLConnectionFactory {
    @Test
    public void testConnConfiguratior() throws IOException {
        final URL u = new URL("http://localhost");
        final ArrayList conns = Lists.newArrayList();
        URLConnectionFactory fc = new URLConnectionFactory(new ConnectionConfigurator(){

            public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                Assert.assertEquals((Object)u, (Object)conn.getURL());
                conns.add(conn);
                return conn;
            }
        });
        fc.openConnection(u);
        Assert.assertEquals((long)1L, (long)conns.size());
    }

    @Test
    public void testSSLInitFailure() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.ssl.hostname.verifier", "foo");
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(URLConnectionFactory.class));
        URLConnectionFactory.newDefaultURLConnectionFactory((Configuration)conf);
        Assert.assertTrue((String)"Expected log for ssl init failure not found!", (boolean)logs.getOutput().contains("Cannot load customized ssl related configuration"));
    }

    @Test
    public void testSSLFactoryCleanup() throws Exception {
        String baseDir = GenericTestUtils.getTempPath((String)TestURLConnectionFactory.class.getSimpleName());
        File base = new File(baseDir);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        String keystoreDir = new File(baseDir).getAbsolutePath();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestURLConnectionFactory.class);
        Configuration conf = new Configuration();
        KeyStoreTestUtil.setupSSLConfig((String)keystoreDir, (String)sslConfDir, (Configuration)conf, (boolean)false, (boolean)true);
        Configuration sslConf = KeyStoreTestUtil.getSslConfig();
        sslConf.set("fs.defaultFS", "swebhdfs://localhost");
        FileSystem fs = FileSystem.get((Configuration)sslConf);
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        Thread[] threads = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threads);
        Thread reloaderThread = null;
        for (Thread thread : threads) {
            if (thread.getName() == null || !thread.getName().contains("SSL Certificates Store Monitor")) continue;
            reloaderThread = thread;
        }
        Assert.assertTrue((String)"Reloader is not alive", (boolean)reloaderThread.isAlive());
        fs.close();
        boolean reloaderStillAlive = true;
        for (int i = 0; i < 10 && (reloaderStillAlive = reloaderThread.isAlive()); ++i) {
            Thread.sleep(1000L);
        }
        Assert.assertFalse((String)"Reloader is still alive", (boolean)reloaderStillAlive);
    }
}

