/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.context;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.terracotta.context.ContextElement;
import org.terracotta.context.TreeNode;
import org.terracotta.statistics.StatisticsManager;

class ContextAwareTreeNode
implements TreeNode {
    private Object context;
    private TreeNode wrappedNode;

    public ContextAwareTreeNode(TreeNode node, Object context) {
        this.context = context;
        this.wrappedNode = node;
    }

    @Override
    public Set<? extends TreeNode> getChildren() {
        return this.wrappedNode.getChildren();
    }

    @Override
    public List<? extends TreeNode> getPath() throws IllegalStateException {
        return this.wrappedNode.getPath();
    }

    @Override
    public Collection<List<? extends TreeNode>> getPaths() {
        return this.wrappedNode.getPaths();
    }

    @Override
    public ContextElement getContext() {
        return this.wrappedNode.getContext();
    }

    @Override
    public String toTreeString() {
        return this.wrappedNode.toTreeString();
    }

    @Override
    public void clean() {
        this.wrappedNode.clean();
        StatisticsManager.removePassThroughStatistics(this.context);
    }
}

