/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class KafkaSink
implements MetricsSink,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSink.class);
    public static final String BROKER_LIST = "broker_list";
    public static final String TOPIC = "topic";
    private String hostname = null;
    private String brokerList = null;
    private String topic = null;
    private Producer<Integer, byte[]> producer = null;
    private final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH:mm:ss");
    private final ZoneId zoneId = ZoneId.systemDefault();

    public void setProducer(Producer<Integer, byte[]> p) {
        this.producer = p;
    }

    public void init(SubsetConfiguration conf) {
        Properties props = new Properties();
        this.brokerList = conf.getString(BROKER_LIST);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Broker list " + this.brokerList);
        }
        props.put("bootstrap.servers", this.brokerList);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Kafka brokers: " + this.brokerList);
        }
        this.topic = conf.getString(TOPIC);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Kafka topic " + this.topic);
        }
        if (Strings.isNullOrEmpty((String)this.topic)) {
            throw new MetricsException("Kafka topic can not be null");
        }
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("request.required.acks", "0");
        this.hostname = "null";
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOG.warn("Error getting Hostname, going to continue");
        }
        try {
            this.producer = new KafkaProducer(props);
        }
        catch (Exception e) {
            throw new MetricsException("Error creating Producer, " + this.brokerList, (Throwable)e);
        }
    }

    public void putMetrics(MetricsRecord record) {
        if (this.producer == null) {
            throw new MetricsException("Producer in KafkaSink is null!");
        }
        StringBuilder jsonLines = new StringBuilder();
        long timestamp = record.timestamp();
        Instant instant = Instant.ofEpochMilli(timestamp);
        LocalDateTime ldt = LocalDateTime.ofInstant(instant, this.zoneId);
        String date = ldt.format(this.dateFormat);
        String time = ldt.format(this.timeFormat);
        jsonLines.append("{\"hostname\": \"" + this.hostname);
        jsonLines.append("\", \"timestamp\": " + timestamp);
        jsonLines.append(", \"date\": \"" + date);
        jsonLines.append("\",\"time\": \"" + time);
        jsonLines.append("\",\"name\": \"" + record.name() + "\" ");
        for (MetricsTag tag : record.tags()) {
            jsonLines.append(", \"" + tag.name().toString().replaceAll("[\\p{Cc}]", "") + "\": ");
            jsonLines.append(" \"" + tag.value().toString() + "\"");
        }
        for (AbstractMetric metric : record.metrics()) {
            jsonLines.append(", \"" + metric.name().toString().replaceAll("[\\p{Cc}]", "") + "\": ");
            jsonLines.append(" \"" + metric.value().toString() + "\"");
        }
        jsonLines.append("}");
        LOG.debug("kafka message: " + jsonLines.toString());
        ProducerRecord data = new ProducerRecord(this.topic, (Object)jsonLines.toString().getBytes(Charset.forName("UTF-8")));
        Future future = this.producer.send(data);
        jsonLines.setLength(0);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            throw new MetricsException("Error sending data", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new MetricsException("Error sending data", (Throwable)e);
        }
    }

    public void flush() {
        LOG.debug("Kafka seems not to have any flush() mechanism!");
    }

    @Override
    public void close() throws IOException {
        try {
            this.producer.close();
        }
        catch (RuntimeException e) {
            throw new MetricsException("Error closing producer", (Throwable)e);
        }
        finally {
            this.producer = null;
        }
    }
}

