/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.CsiAdaptorProtos;

public class ValidateVolumeCapabilitiesRequestPBImpl
extends ValidateVolumeCapabilitiesRequest {
    private CsiAdaptorProtos.ValidateVolumeCapabilitiesRequest.Builder builder;

    public ValidateVolumeCapabilitiesRequestPBImpl(CsiAdaptorProtos.ValidateVolumeCapabilitiesRequest proto) {
        this.builder = proto.toBuilder();
    }

    public ValidateVolumeCapabilitiesRequestPBImpl() {
        this.builder = CsiAdaptorProtos.ValidateVolumeCapabilitiesRequest.newBuilder();
    }

    public String getVolumeId() {
        Preconditions.checkNotNull((Object)this.builder);
        return this.builder.getVolumeId();
    }

    public void setVolumeAttributes(Map<String, String> attributes) {
        Preconditions.checkNotNull((Object)this.builder);
        this.builder.addAllVolumeAttributes(ProtoUtils.convertToProtoFormat(attributes));
    }

    public void setVolumeId(String volumeId) {
        Preconditions.checkNotNull((Object)this.builder);
        this.builder.setVolumeId(volumeId);
    }

    public void addVolumeCapability(ValidateVolumeCapabilitiesRequest.VolumeCapability volumeCapability) {
        Preconditions.checkNotNull((Object)this.builder);
        CsiAdaptorProtos.VolumeCapability vc = CsiAdaptorProtos.VolumeCapability.newBuilder().setAccessMode(CsiAdaptorProtos.VolumeCapability.AccessMode.forNumber((int)volumeCapability.getAccessMode().ordinal())).setVolumeType(CsiAdaptorProtos.VolumeCapability.VolumeType.forNumber((int)volumeCapability.getVolumeType().ordinal())).addAllMountFlags((Iterable)volumeCapability.getMountFlags()).build();
        this.builder.addVolumeCapabilities(vc);
    }

    public List<ValidateVolumeCapabilitiesRequest.VolumeCapability> getVolumeCapabilities() {
        Preconditions.checkNotNull((Object)this.builder);
        ArrayList<ValidateVolumeCapabilitiesRequest.VolumeCapability> caps = new ArrayList<ValidateVolumeCapabilitiesRequest.VolumeCapability>(this.builder.getVolumeCapabilitiesCount());
        this.builder.getVolumeCapabilitiesList().forEach(capability -> {
            ValidateVolumeCapabilitiesRequest.VolumeCapability vc = new ValidateVolumeCapabilitiesRequest.VolumeCapability(ValidateVolumeCapabilitiesRequest.AccessMode.valueOf((String)capability.getAccessMode().name()), ValidateVolumeCapabilitiesRequest.VolumeType.valueOf((String)capability.getVolumeType().name()), (List)capability.getMountFlagsList());
            caps.add(vc);
        });
        return caps;
    }

    public Map<String, String> getVolumeAttributes() {
        Preconditions.checkNotNull((Object)this.builder);
        return ProtoUtils.convertStringStringMapProtoListToMap(this.builder.getVolumeAttributesList());
    }

    public CsiAdaptorProtos.ValidateVolumeCapabilitiesRequest getProto() {
        Preconditions.checkNotNull((Object)this.builder);
        return this.builder.build();
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((ValidateVolumeCapabilitiesRequestPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }
}

