/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.StorageErrorCode;
import com.microsoft.azure.storage.StorageException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class NativeAzureFileSystemHelper {
    private static final Logger LOG = LoggerFactory.getLogger(NativeAzureFileSystemHelper.class);

    private NativeAzureFileSystemHelper() {
    }

    public static void cleanup(Logger log, Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (log == null) break block3;
                    log.debug("Exception in closing {}", (Object)closeable, (Object)e);
                }
            }
        }
    }

    public static Throwable checkForAzureStorageException(Exception e) {
        Throwable innerException;
        for (innerException = e.getCause(); innerException != null && !(innerException instanceof StorageException); innerException = innerException.getCause()) {
        }
        return innerException;
    }

    public static boolean isFileNotFoundException(StorageException e) {
        String errorCode = e.getErrorCode();
        return errorCode != null && (errorCode.equals("BlobNotFound") || errorCode.equals("ResourceNotFound") || errorCode.equals("ContainerNotFound") || errorCode.equals(StorageErrorCode.BLOB_NOT_FOUND.toString()) || errorCode.equals(StorageErrorCode.RESOURCE_NOT_FOUND.toString()) || errorCode.equals(StorageErrorCode.CONTAINER_NOT_FOUND.toString()));
    }

    static boolean isBlobAlreadyExistsConflict(StorageException e) {
        return e.getHttpStatusCode() == 409 && "BlobAlreadyExists".equals(e.getErrorCode());
    }

    public static void logAllLiveStackTraces() {
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            LOG.debug("Thread " + entry.getKey().getName());
            StackTraceElement[] trace = entry.getValue();
            for (int j = 0; j < trace.length; ++j) {
                LOG.debug("\tat " + trace[j]);
            }
        }
    }

    static void validateReadArgs(byte[] buffer, int offset, int length) throws EOFException {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length is negative");
        Preconditions.checkArgument((buffer != null ? 1 : 0) != 0, (Object)"Null buffer");
        if (buffer.length - offset < length) {
            throw new IndexOutOfBoundsException("Requested more bytes than destination buffer size: request length=" + length + ", with offset =" + offset + "; buffer capacity =" + (buffer.length - offset));
        }
    }
}

