/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.CombinedHostFileManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostConfigManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDatanodeReport {
    static final Logger LOG = LoggerFactory.getLogger(TestDatanodeReport.class);
    private static final Configuration conf = new HdfsConfiguration();
    private static final int NUM_OF_DATANODES = 4;
    static final Comparator<StorageReport> CMP = new Comparator<StorageReport>(){

        @Override
        public int compare(StorageReport left, StorageReport right) {
            return left.getStorage().getStorageID().compareTo(right.getStorage().getStorageID());
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatanodeReportWithUpgradeDomain() throws Exception {
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setClass("dfs.namenode.hosts.provider.classname", CombinedHostFileManager.class, HostConfigManager.class);
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize(conf, "temp/datanodeReport");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        DFSClient client = cluster.getFileSystem().dfs;
        String ud1 = "ud1";
        String ud2 = "ud2";
        try {
            cluster.waitActive();
            DatanodeAdminProperties datanode = new DatanodeAdminProperties();
            datanode.setHostName(cluster.getDataNodes().get(0).getDatanodeId().getHostName());
            datanode.setUpgradeDomain("ud1");
            hostsFileWriter.initIncludeHosts(new DatanodeAdminProperties[]{datanode});
            client.refreshNodes();
            DatanodeInfo[] all = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            Assert.assertEquals((Object)all[0].getUpgradeDomain(), (Object)"ud1");
            datanode.setUpgradeDomain(null);
            hostsFileWriter.initIncludeHosts(new DatanodeAdminProperties[]{datanode});
            client.refreshNodes();
            all = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            Assert.assertEquals((Object)all[0].getUpgradeDomain(), null);
            datanode.setUpgradeDomain("ud2");
            hostsFileWriter.initIncludeHosts(new DatanodeAdminProperties[]{datanode});
            client.refreshNodes();
            all = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            Assert.assertEquals((Object)all[0].getUpgradeDomain(), (Object)"ud2");
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatanodeReport() throws Exception {
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setLong("dfs.heartbeat.interval", 1L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).build();
        try {
            cluster.waitActive();
            String bpid = cluster.getNamesystem().getBlockPoolId();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            DFSClient client = cluster.getFileSystem().dfs;
            TestDatanodeReport.assertReports(4, HdfsConstants.DatanodeReportType.ALL, client, datanodes, bpid);
            TestDatanodeReport.assertReports(4, HdfsConstants.DatanodeReportType.LIVE, client, datanodes, bpid);
            TestDatanodeReport.assertReports(0, HdfsConstants.DatanodeReportType.DEAD, client, datanodes, bpid);
            DataNode last = (DataNode)datanodes.get(datanodes.size() - 1);
            LOG.info("XXX shutdown datanode " + last.getDatanodeUuid());
            last.shutdown();
            DatanodeInfo[] nodeInfo = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
            while (nodeInfo.length != 1) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                nodeInfo = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
            }
            TestDatanodeReport.assertReports(4, HdfsConstants.DatanodeReportType.ALL, client, datanodes, null);
            TestDatanodeReport.assertReports(3, HdfsConstants.DatanodeReportType.LIVE, client, datanodes, null);
            TestDatanodeReport.assertReports(1, HdfsConstants.DatanodeReportType.DEAD, client, datanodes, null);
            Thread.sleep(5000L);
            MetricsAsserts.assertCounter((String)"ExpiredHeartbeats", (int)1, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"FSNamesystem"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatanodeReportMissingBlock() throws Exception {
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("dfs.client.retry.window.base", 1L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path p = new Path("/testDatanodeReportMissingBlock");
            DFSTestUtil.writeFile((FileSystem)fs, p, new String("testdata"));
            LocatedBlock lb = fs.getClient().getLocatedBlocks(p.toString(), 0L).get(0);
            Assert.assertEquals((long)3L, (long)lb.getLocations().length);
            ExtendedBlock b = lb.getBlock();
            cluster.corruptBlockOnDataNodesByDeletingBlockFile(b);
            try {
                DFSTestUtil.readFile((FileSystem)fs, p);
                Assert.fail((String)"Must throw exception as the block doesn't exists on disk");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            cluster.triggerHeartbeats();
            int retries = 0;
            while (0 != (lb = fs.getClient().getLocatedBlocks(p.toString(), 0L).get(0)).getLocations().length) {
                if (++retries > 7) {
                    Assert.fail((String)"getLocatedBlocks failed after 7 retries");
                }
                Thread.sleep(2000L);
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    static void assertReports(int numDatanodes, HdfsConstants.DatanodeReportType type, DFSClient client, List<DataNode> datanodes, String bpid) throws IOException {
        DatanodeInfo[] infos = client.datanodeReport(type);
        Assert.assertEquals((long)numDatanodes, (long)infos.length);
        DatanodeStorageReport[] reports = client.getDatanodeStorageReport(type);
        Assert.assertEquals((long)numDatanodes, (long)reports.length);
        for (int i = 0; i < infos.length; ++i) {
            Assert.assertEquals((Object)infos[i], (Object)reports[i].getDatanodeInfo());
            DataNode d = TestDatanodeReport.findDatanode(infos[i].getDatanodeUuid(), datanodes);
            if (bpid == null) continue;
            StorageReport[] computed = reports[i].getStorageReports();
            Arrays.sort(computed, CMP);
            StorageReport[] expected = d.getFSDataset().getStorageReports(bpid);
            Arrays.sort(expected, CMP);
            Assert.assertEquals((long)expected.length, (long)computed.length);
            for (int j = 0; j < expected.length; ++j) {
                Assert.assertEquals((Object)expected[j].getStorage().getStorageID(), (Object)computed[j].getStorage().getStorageID());
            }
        }
    }

    static DataNode findDatanode(String id, List<DataNode> datanodes) {
        for (DataNode d : datanodes) {
            if (!d.getDatanodeUuid().equals(id)) continue;
            return d;
        }
        throw new IllegalStateException("Datnode " + id + " not in datanode list: " + datanodes);
    }
}

