/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerFaultInjector;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockReportLeaseManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBlockReportRateLimiting {
    static final Logger LOG = LoggerFactory.getLogger(TestBlockReportRateLimiting.class);

    private static void setFailure(AtomicReference<String> failure, String what) {
        failure.compareAndSet("", what);
        LOG.error("Test error: " + what);
    }

    @After
    public void restoreNormalBlockManagerFaultInjector() {
        BlockManagerFaultInjector.instance = new BlockManagerFaultInjector();
    }

    @BeforeClass
    public static void raiseBlockManagerLogLevels() {
        GenericTestUtils.setLogLevel((Logger)BlockManager.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Logger)BlockReportLeaseManager.LOG, (Level)Level.ALL);
    }

    @Test(timeout=180000L)
    public void testRateLimitingDuringDataNodeStartup() throws Exception {
        BlockManagerFaultInjector injector;
        Configuration conf = new Configuration();
        conf.setInt("dfs.namenode.max.full.block.report.leases", 1);
        conf.setLong("dfs.namenode.full.block.report.lease.length.ms", 1200000L);
        final Semaphore fbrSem = new Semaphore(0);
        final HashSet expectedFbrDns = new HashSet();
        final HashSet fbrDns = new HashSet();
        final AtomicReference<String> failure = new AtomicReference<String>("");
        BlockManagerFaultInjector.instance = injector = new BlockManagerFaultInjector(){
            private int numLeases = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void incomingBlockReportRpc(DatanodeID nodeID, BlockReportContext context) throws IOException {
                LOG.info("Incoming full block report from " + nodeID + ".  Lease ID = 0x" + Long.toHexString(context.getLeaseId()));
                if (context.getLeaseId() == 0L) {
                    TestBlockReportRateLimiting.setFailure(failure, "Got unexpected rate-limiting-bypassing full block report RPC from " + nodeID);
                }
                fbrSem.acquireUninterruptibly();
                1 var3_3 = this;
                synchronized (var3_3) {
                    fbrDns.add(nodeID);
                    if (!expectedFbrDns.remove(nodeID)) {
                        TestBlockReportRateLimiting.setFailure(failure, "Got unexpected full block report RPC from " + nodeID + ".  expectedFbrDns = " + Joiner.on((String)", ").join((Iterable)expectedFbrDns));
                    }
                    LOG.info("Proceeding with full block report from " + nodeID + ".  Lease ID = 0x" + Long.toHexString(context.getLeaseId()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void requestBlockReportLease(DatanodeDescriptor node, long leaseId) {
                if (leaseId == 0L) {
                    return;
                }
                1 var4_3 = this;
                synchronized (var4_3) {
                    ++this.numLeases;
                    expectedFbrDns.add(node);
                    LOG.info("requestBlockReportLease(node=" + node + ", leaseId=0x" + Long.toHexString(leaseId) + ").  expectedFbrDns = " + Joiner.on((String)", ").join((Iterable)expectedFbrDns));
                    if (this.numLeases > 1) {
                        TestBlockReportRateLimiting.setFailure(failure, "More than 1 lease was issued at once.");
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeBlockReportLease(DatanodeDescriptor node, long leaseId) {
                LOG.info("removeBlockReportLease(node=" + node + ", leaseId=0x" + Long.toHexString(leaseId) + ")");
                1 var4_3 = this;
                synchronized (var4_3) {
                    --this.numLeases;
                }
            }
        };
        int NUM_DATANODES = 5;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(5).build();
        cluster.waitActive();
        int n = 1;
        while (n <= 5) {
            LOG.info("Waiting for " + n + " datanode(s) to report in.");
            fbrSem.release();
            Uninterruptibles.sleepUninterruptibly((long)20L, (TimeUnit)TimeUnit.MILLISECONDS);
            final int currentN = n++;
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean get() {
                    BlockManagerFaultInjector blockManagerFaultInjector = injector;
                    synchronized (blockManagerFaultInjector) {
                        if (fbrDns.size() > currentN) {
                            TestBlockReportRateLimiting.setFailure(failure, "Expected at most " + currentN + " datanodes to have sent a block report, but actually " + fbrDns.size() + " have.");
                        }
                        return fbrDns.size() >= currentN;
                    }
                }
            }, (long)25L, (long)50000L);
        }
        cluster.shutdown();
        Assert.assertEquals((Object)"", (Object)failure.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testLeaseExpiration() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.namenode.max.full.block.report.leases", 1);
        conf.setLong("dfs.namenode.full.block.report.lease.length.ms", 100L);
        final Semaphore gotFbrSem = new Semaphore(0);
        final AtomicReference failure = new AtomicReference();
        AtomicReference<MiniDFSCluster> cluster = new AtomicReference<MiniDFSCluster>();
        final AtomicReference datanodeToStop = new AtomicReference();
        BlockManagerFaultInjector injector = new BlockManagerFaultInjector(){

            public void incomingBlockReportRpc(DatanodeID nodeID, BlockReportContext context) throws IOException {
                if (context.getLeaseId() == 0L) {
                    TestBlockReportRateLimiting.setFailure(failure, "Got unexpected rate-limiting-bypassing full block report RPC from " + nodeID);
                }
                if (nodeID.getXferAddr().equals(datanodeToStop.get())) {
                    throw new IOException("Injecting failure into block report RPC for " + nodeID);
                }
                gotFbrSem.release();
            }

            public void requestBlockReportLease(DatanodeDescriptor node, long leaseId) {
                if (leaseId == 0L) {
                    return;
                }
                datanodeToStop.compareAndSet(null, node.getXferAddr());
            }

            public void removeBlockReportLease(DatanodeDescriptor node, long leaseId) {
            }
        };
        try {
            BlockManagerFaultInjector.instance = injector;
            cluster.set(new MiniDFSCluster.Builder(conf).numDataNodes(2).build());
            ((MiniDFSCluster)cluster.get()).waitActive();
            Assert.assertNotNull((Object)((MiniDFSCluster)cluster.get()).stopDataNode((String)datanodeToStop.get()));
            gotFbrSem.acquire();
            Assert.assertNull(failure.get());
        }
        finally {
            if (cluster.get() != null) {
                ((MiniDFSCluster)cluster.get()).shutdown();
            }
        }
    }
}

