/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.applications.mawo.server.common;

import com.google.inject.Singleton;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class MawoConfiguration {
    static final Logger LOG = LoggerFactory.getLogger(MawoConfiguration.class);
    static final String COMMA_SPLITTER = ",";
    public static final String CONFIG_FILE = "mawo.properties";
    private static final String RPC_SERVER_HOSTNAME = "rpc.server.hostname";
    private static final String RPC_SERVER_PORT = "rpc.server.port";
    private static final String RPC_SERVER_HOSTNAME_DEFAULT = "localhost";
    private static final String RPC_SERVER_PORT_DEFAULT = "5121";
    private static final String JOB_QUEUE_STORAGE_ENABLED = "mawo.job-queue-storage.enabled";
    private static final String ZK_PREFIX = "zookeeper.";
    private static final String ZK_ADDRESS = "zookeeper.address";
    private static final String ZK_ADDRESS_DEFAULT = "localhost:2181";
    private static final String ZK_PARENT_PATH = "zookeeper.parent.path";
    private static final String ZK_PARENT_PATH_DEFAULT = "/mawoRoot";
    private static final String ZK_RETRY_INTERVAL_MS = "zookeeper.retry.interval.ms";
    private static final String ZK_RETRY_INTERVAL_MS_DEFAULT = "1000";
    private static final String ZK_SESSION_TIMEOUT_MS = "zookeeper.session.timeout.ms";
    private static final String ZK_SESSION_TIMEOUT_MS_DEFAULT = "10000";
    private static final String ZK_RETRIES_NUM = "zookeeper.retries.num";
    private static final String ZK_RETRIES_NUM_DEFAULT = "1000";
    private static final String ZK_ACL = "zookeeper.acl";
    private static final String ZK_ACL_DEFAULT = "world:anyone:rwcda";
    private static final String WORKER_NUM_TASKS = "worker.num.tasks";
    private static final String WORKER_NUM_TASKS_DEFAULT = "10";
    public static final String JOB_BUILDER_CLASS = "mawo.job-builder.class";
    private static final String JOB_BUILDER_CLASS_DEFAULT = "org.apache.hadoop.applications.mawo.server.master.job.SimpleTaskJobBuilder";
    private static final String WORKER_WORK_SPACE = "worker.workspace";
    private static final String WORKER_WORK_SPACE_DEFAULT = "/tmp";
    public static final String CLUSTER_MANAGER_URL = "ycloud.url";
    private static final String DEFAULT_CLUSTER_MANAGER_URL = "0.0.0.0:9191";
    public static final String AUTO_SHUTDOWN_WORKERS = "mawo.master.auto-shutdown-workers";
    private static final boolean DEFAULT_AUTO_SHUTDOWN_WORKERS = false;
    public static final String MASTER_TASKS_STATUS_LOG_PATH = "master.tasks-status.log.path";
    private static final String MASTER_TASKS_STATUS_LOG_PATH_DEFAULT = "/tmp";
    private static final String MASTER_DRAIN_EVENTS_TIMEOUT = "master.drain-events.timeout";
    private static final long MASTER_DRAIN_EVENTS_TIMEOUT_DEFAULT = 60000L;
    private static final String WORKER_WHITELIST_ENV = "worker.whitelist.env";
    private static final String WORKER_WHITELIST_ENV_DEFAULT = "";
    private static final String MASTER_TEARDOWN_WORKER_VALIDITY_INTERVAL_MS = "master.teardown-worker.validity-interval.ms";
    private static final String MASTER_TEARDOWN_WORKER_VALIDITY_INTERVAL_MS_DEFAULT = "120000";
    private Map<String, String> configsMap = new HashMap<String, String>();

    public MawoConfiguration() {
        this(MawoConfiguration.readConfigFile());
    }

    private MawoConfiguration(Properties properties) {
        this.configsMap.put(RPC_SERVER_HOSTNAME, properties.getProperty(RPC_SERVER_HOSTNAME, RPC_SERVER_HOSTNAME_DEFAULT));
        this.configsMap.put(RPC_SERVER_PORT, properties.getProperty(RPC_SERVER_PORT, RPC_SERVER_PORT_DEFAULT));
        this.configsMap.put(ZK_ADDRESS, properties.getProperty(ZK_ADDRESS, ZK_ADDRESS_DEFAULT));
        this.configsMap.put(ZK_PARENT_PATH, properties.getProperty(ZK_PARENT_PATH, ZK_PARENT_PATH_DEFAULT));
        this.configsMap.put(ZK_RETRY_INTERVAL_MS, properties.getProperty(ZK_RETRY_INTERVAL_MS, "1000"));
        this.configsMap.put(ZK_SESSION_TIMEOUT_MS, properties.getProperty(ZK_SESSION_TIMEOUT_MS, ZK_SESSION_TIMEOUT_MS_DEFAULT));
        this.configsMap.put(ZK_RETRIES_NUM, properties.getProperty(ZK_RETRIES_NUM, "1000"));
        this.configsMap.put(ZK_ACL, properties.getProperty(ZK_ACL, ZK_ACL_DEFAULT));
        this.configsMap.put(JOB_BUILDER_CLASS, properties.getProperty(JOB_BUILDER_CLASS, JOB_BUILDER_CLASS_DEFAULT));
        this.configsMap.put(JOB_QUEUE_STORAGE_ENABLED, properties.getProperty(JOB_QUEUE_STORAGE_ENABLED, "false"));
        this.configsMap.put(CLUSTER_MANAGER_URL, properties.getProperty(CLUSTER_MANAGER_URL, DEFAULT_CLUSTER_MANAGER_URL));
        this.configsMap.put(WORKER_NUM_TASKS, properties.getProperty(WORKER_NUM_TASKS, WORKER_NUM_TASKS_DEFAULT));
        this.configsMap.put(WORKER_WORK_SPACE, properties.getProperty(WORKER_WORK_SPACE, "/tmp"));
        this.configsMap.put(AUTO_SHUTDOWN_WORKERS, properties.getProperty(AUTO_SHUTDOWN_WORKERS, String.valueOf(false)));
        this.configsMap.put(MASTER_TASKS_STATUS_LOG_PATH, properties.getProperty(MASTER_TASKS_STATUS_LOG_PATH, String.valueOf("/tmp")));
        this.configsMap.put(MASTER_DRAIN_EVENTS_TIMEOUT, properties.getProperty(MASTER_DRAIN_EVENTS_TIMEOUT, String.valueOf(60000L)));
        this.configsMap.put(WORKER_WHITELIST_ENV, properties.getProperty(WORKER_WHITELIST_ENV, WORKER_WHITELIST_ENV_DEFAULT));
        this.configsMap.put(MASTER_TEARDOWN_WORKER_VALIDITY_INTERVAL_MS, properties.getProperty(MASTER_TEARDOWN_WORKER_VALIDITY_INTERVAL_MS, MASTER_TEARDOWN_WORKER_VALIDITY_INTERVAL_MS_DEFAULT));
    }

    public Map<String, String> getConfigsMap() {
        return this.configsMap;
    }

    private static Properties readConfigFile() {
        Properties properties = new Properties();
        LOG.info("Configuration file being loaded: mawo.properties. Found in classpath at " + MawoConfiguration.class.getClassLoader().getResource(CONFIG_FILE));
        InputStream inputStream = MawoConfiguration.class.getClassLoader().getResourceAsStream(CONFIG_FILE);
        if (inputStream == null) {
            throw new RuntimeException("mawo.properties not found in classpath");
        }
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        catch (FileNotFoundException fnf) {
            LOG.error("No configuration file mawo.properties found in classpath.");
        }
        catch (IOException ie) {
            throw new IllegalArgumentException("Can't read configuration file mawo.properties", ie);
        }
        return properties;
    }

    public int getRpcServerPort() {
        return Integer.parseInt(this.configsMap.get(RPC_SERVER_PORT));
    }

    public String getRpcHostName() {
        return this.configsMap.get(RPC_SERVER_HOSTNAME);
    }

    public boolean getJobQueueStorageEnabled() {
        return Boolean.parseBoolean(this.configsMap.get(JOB_QUEUE_STORAGE_ENABLED));
    }

    public String getZKAddress() {
        return this.configsMap.get(ZK_ADDRESS);
    }

    public String getZKParentPath() {
        return this.configsMap.get(ZK_PARENT_PATH);
    }

    public int getZKRetryIntervalMS() {
        return Integer.parseInt(this.configsMap.get(ZK_RETRY_INTERVAL_MS));
    }

    public int getZKSessionTimeoutMS() {
        return Integer.parseInt(this.configsMap.get(ZK_SESSION_TIMEOUT_MS));
    }

    public int getZKRetriesNum() {
        return Integer.parseInt(this.configsMap.get(ZK_RETRIES_NUM));
    }

    public String getZKAcl() {
        return this.configsMap.get(ZK_ACL);
    }

    public int getWorkerConcurrentTasksLimit() {
        return Integer.parseInt(this.configsMap.get(WORKER_NUM_TASKS));
    }

    public String getJobBuilderClass() {
        return this.configsMap.get(JOB_BUILDER_CLASS);
    }

    public String getWorkerWorkSpace() {
        return this.configsMap.get(WORKER_WORK_SPACE);
    }

    public String getClusterManagerURL() {
        return this.configsMap.get(CLUSTER_MANAGER_URL);
    }

    public boolean getAutoShutdownWorkers() {
        return Boolean.parseBoolean(this.configsMap.get(AUTO_SHUTDOWN_WORKERS));
    }

    public String getMasterTasksStatusLogPath() {
        return this.configsMap.get(MASTER_TASKS_STATUS_LOG_PATH);
    }

    public long getMasterDrainEventsTimeout() {
        return Long.parseLong(this.configsMap.get(MASTER_DRAIN_EVENTS_TIMEOUT));
    }

    public List<String> getWorkerWhiteListEnv() {
        ArrayList<String> whiteList = new ArrayList<String>();
        String env = this.configsMap.get(WORKER_WHITELIST_ENV);
        if (env != null && !env.isEmpty()) {
            String[] variables;
            for (String variable : variables = env.split(COMMA_SPLITTER)) {
                if ((variable = variable.trim()).startsWith("$")) {
                    variable = variable.substring(1);
                }
                if (variable.isEmpty()) continue;
                whiteList.add(variable);
            }
        }
        return whiteList;
    }

    public long getTeardownWorkerValidityInterval() {
        return Long.parseLong(this.configsMap.get(MASTER_TEARDOWN_WORKER_VALIDITY_INTERVAL_MS));
    }
}

