/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.core.internal.resilience;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.shaded.org.ehcache.core.internal.resilience.RecoveryCache;
import org.apache.hadoop.shaded.org.ehcache.core.internal.resilience.ResilienceStrategy;
import org.apache.hadoop.shaded.org.ehcache.core.internal.resilience.RethrowingStoreAccessException;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.StoreAccessException;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.BulkCacheLoadingException;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.BulkCacheWritingException;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheLoadingException;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheWritingException;

public abstract class RobustResilienceStrategy<K, V>
implements ResilienceStrategy<K, V> {
    private final RecoveryCache<K> cache;

    public RobustResilienceStrategy(RecoveryCache<K> cache) {
        this.cache = cache;
    }

    @Override
    public V getFailure(K key, StoreAccessException e) {
        this.cleanup(key, e);
        return null;
    }

    @Override
    public V getFailure(K key, V loaded, StoreAccessException e) {
        this.cleanup(key, e);
        return loaded;
    }

    @Override
    public V getFailure(K key, StoreAccessException e, CacheLoadingException f) {
        this.cleanup(key, e);
        throw f;
    }

    @Override
    public boolean containsKeyFailure(K key, StoreAccessException e) {
        this.cleanup(key, e);
        return false;
    }

    @Override
    public void putFailure(K key, V value, StoreAccessException e) {
        this.cleanup(key, e);
    }

    @Override
    public void putFailure(K key, V value, StoreAccessException e, CacheWritingException f) {
        this.cleanup(key, e);
        throw f;
    }

    @Override
    public void removeFailure(K key, StoreAccessException e) {
        this.cleanup(key, e);
    }

    @Override
    public void removeFailure(K key, StoreAccessException e, CacheWritingException f) {
        this.cleanup(key, e);
        throw f;
    }

    @Override
    public void clearFailure(StoreAccessException e) {
        this.cleanup(e);
    }

    @Override
    public V putIfAbsentFailure(K key, V value, V loaderWriterFunctionResult, StoreAccessException e, boolean knownToBeAbsent) {
        this.cleanup(key, e);
        if (loaderWriterFunctionResult != null && !loaderWriterFunctionResult.equals(value)) {
            return loaderWriterFunctionResult;
        }
        return null;
    }

    @Override
    public V putIfAbsentFailure(K key, V value, StoreAccessException e, CacheWritingException f) {
        this.cleanup(key, e);
        throw f;
    }

    @Override
    public V putIfAbsentFailure(K key, V value, StoreAccessException e, CacheLoadingException f) {
        this.cleanup(key, e);
        throw f;
    }

    @Override
    public boolean removeFailure(K key, V value, StoreAccessException e, boolean knownToBePresent) {
        this.cleanup(key, e);
        return knownToBePresent;
    }

    @Override
    public boolean removeFailure(K key, V value, StoreAccessException e, CacheWritingException f) {
        this.cleanup(key, e);
        throw f;
    }

    @Override
    public boolean removeFailure(K key, V value, StoreAccessException e, CacheLoadingException f) {
        this.cleanup(key, e);
        throw f;
    }

    @Override
    public V replaceFailure(K key, V value, StoreAccessException e) {
        this.cleanup(key, e);
        return null;
    }

    @Override
    public V replaceFailure(K key, V value, StoreAccessException e, CacheWritingException f) {
        this.cleanup(key, e);
        throw f;
    }

    @Override
    public V replaceFailure(K key, V value, StoreAccessException e, CacheLoadingException f) {
        this.cleanup(key, e);
        throw f;
    }

    @Override
    public boolean replaceFailure(K key, V value, V newValue, StoreAccessException e, boolean knownToMatch) {
        this.cleanup(key, e);
        return knownToMatch;
    }

    @Override
    public boolean replaceFailure(K key, V value, V newValue, StoreAccessException e, CacheWritingException f) {
        this.cleanup(key, e);
        throw f;
    }

    @Override
    public boolean replaceFailure(K key, V value, V newValue, StoreAccessException e, CacheLoadingException f) {
        this.cleanup(key, e);
        throw f;
    }

    @Override
    public Map<K, V> getAllFailure(Iterable<? extends K> keys, StoreAccessException e) {
        this.cleanup((K)keys, e);
        HashMap<K, Object> result = new HashMap<K, Object>();
        for (K key : keys) {
            result.put(key, null);
        }
        return result;
    }

    @Override
    public Map<K, V> getAllFailure(Iterable<? extends K> keys, Map<K, V> loaded, StoreAccessException e) {
        this.cleanup((K)keys, e);
        return loaded;
    }

    @Override
    public Map<K, V> getAllFailure(Iterable<? extends K> keys, StoreAccessException e, BulkCacheLoadingException f) {
        this.cleanup((K)keys, e);
        throw f;
    }

    @Override
    public void putAllFailure(Map<? extends K, ? extends V> entries, StoreAccessException e) {
        this.cleanup((K)entries.keySet(), e);
    }

    @Override
    public void putAllFailure(Map<? extends K, ? extends V> entries, StoreAccessException e, BulkCacheWritingException f) {
        this.cleanup((K)entries.keySet(), e);
        throw f;
    }

    @Override
    public Map<K, V> removeAllFailure(Iterable<? extends K> entries, StoreAccessException e) {
        this.cleanup((K)entries, e);
        return Collections.emptyMap();
    }

    @Override
    public Map<K, V> removeAllFailure(Iterable<? extends K> entries, StoreAccessException e, BulkCacheWritingException f) {
        this.cleanup((K)entries, e);
        throw f;
    }

    private void cleanup(StoreAccessException from) {
        this.filterException(from);
        try {
            this.cache.obliterate();
        }
        catch (StoreAccessException e) {
            this.inconsistent(from, e);
            return;
        }
        this.recovered(from);
    }

    private void cleanup(Iterable<? extends K> keys, StoreAccessException from) {
        this.filterException(from);
        try {
            this.cache.obliterate(keys);
        }
        catch (StoreAccessException e) {
            this.inconsistent(keys, from, e);
            return;
        }
        this.recovered(keys, from);
    }

    private void cleanup(K key, StoreAccessException from) {
        this.filterException(from);
        try {
            this.cache.obliterate(key);
        }
        catch (StoreAccessException e) {
            this.inconsistent(key, from, e);
            return;
        }
        this.recovered(key, from);
    }

    @Deprecated
    void filterException(StoreAccessException cae) throws RuntimeException {
        if (cae instanceof RethrowingStoreAccessException) {
            throw ((RethrowingStoreAccessException)cae).getCause();
        }
    }

    protected abstract void recovered(K var1, StoreAccessException var2);

    protected abstract void recovered(Iterable<? extends K> var1, StoreAccessException var2);

    protected abstract void recovered(StoreAccessException var1);

    protected abstract void inconsistent(K var1, StoreAccessException var2, StoreAccessException ... var3);

    protected abstract void inconsistent(Iterable<? extends K> var1, StoreAccessException var2, StoreAccessException ... var3);

    protected abstract void inconsistent(StoreAccessException var1, StoreAccessException ... var2);
}

