/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathLocation {
    private static final Logger LOG = LoggerFactory.getLogger(PathLocation.class);
    private final String sourcePath;
    private final List<RemoteLocation> destinations;
    private final DestinationOrder destOrder;

    public PathLocation(String source, List<RemoteLocation> dest, DestinationOrder order) {
        this.sourcePath = source;
        this.destinations = Collections.unmodifiableList(dest);
        this.destOrder = order;
    }

    public PathLocation(String source, List<RemoteLocation> dest) {
        this(source, dest, DestinationOrder.HASH);
    }

    public PathLocation(PathLocation other) {
        this.sourcePath = other.sourcePath;
        this.destinations = Collections.unmodifiableList(other.destinations);
        this.destOrder = other.destOrder;
    }

    public PathLocation(PathLocation other, String firstNsId) {
        this.sourcePath = other.sourcePath;
        this.destOrder = other.destOrder;
        this.destinations = PathLocation.orderedNamespaces(other.destinations, firstNsId);
    }

    private static List<RemoteLocation> orderedNamespaces(List<RemoteLocation> original, String nsId) {
        if (original.size() <= 1) {
            return original;
        }
        LinkedList<RemoteLocation> newDestinations = new LinkedList<RemoteLocation>();
        boolean found = false;
        for (RemoteLocation dest : original) {
            if (dest.getNameserviceId().equals(nsId)) {
                found = true;
                newDestinations.addFirst(dest);
                continue;
            }
            newDestinations.add(dest);
        }
        if (!found) {
            LOG.debug("Cannot find location with namespace {} in {}", (Object)nsId, original);
        }
        return Collections.unmodifiableList(newDestinations);
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public Set<String> getNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        List<RemoteLocation> locations = this.getDestinations();
        for (RemoteLocation location : locations) {
            String nsId = location.getNameserviceId();
            namespaces.add(nsId);
        }
        return namespaces;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (RemoteLocation destination : this.destinations) {
            String nsId = destination.getNameserviceId();
            String path = destination.getDest();
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(nsId + "->" + path);
        }
        if (this.destinations.size() > 1) {
            sb.append(" [").append(this.destOrder.toString()).append("]");
        }
        return sb.toString();
    }

    public boolean hasMultipleDestinations() {
        return this.destinations.size() > 1;
    }

    public List<RemoteLocation> getDestinations() {
        return Collections.unmodifiableList(this.destinations);
    }

    public DestinationOrder getDestinationOrder() {
        return this.destOrder;
    }

    public RemoteLocation getDefaultLocation() {
        if (this.destinations.isEmpty() || this.destinations.get(0).getDest() == null) {
            throw new UnsupportedOperationException("Unsupported path " + this.sourcePath + " please check mount table");
        }
        return this.destinations.get(0);
    }
}

