/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.proto.RouterProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.RouterAdminProtocol;
import org.apache.hadoop.hdfs.protocolPB.RouterAdminProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.RouterAdminProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.RouterPolicyProvider;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.Quota;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterPermissionChecker;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterSafemodeService;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.store.DisabledNameserviceStore;
import org.apache.hadoop.hdfs.server.federation.store.MountTableStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreCache;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.DisableNameserviceRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.DisableNameserviceResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnableNameserviceRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnableNameserviceResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnterSafeModeRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnterSafeModeResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDestinationRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDestinationResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDisabledNameservicesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDisabledNameservicesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetSafeModeRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetSafeModeResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.LeaveSafeModeRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.LeaveSafeModeResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RefreshMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RefreshMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.GenericRefreshProtocol;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RefreshCallQueueProtocol;
import org.apache.hadoop.ipc.RefreshRegistry;
import org.apache.hadoop.ipc.RefreshResponse;
import org.apache.hadoop.ipc.proto.GenericRefreshProtocolProtos;
import org.apache.hadoop.ipc.proto.RefreshCallQueueProtocolProtos;
import org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolPB;
import org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolServerSideTranslatorPB;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolPB;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.protobuf.BlockingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterAdminServer
extends AbstractService
implements RouterAdminProtocol,
RefreshCallQueueProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(RouterAdminServer.class);
    private Configuration conf;
    private final Router router;
    private MountTableStore mountTableStore;
    private DisabledNameserviceStore disabledStore;
    private final RPC.Server adminServer;
    private final InetSocketAddress adminAddress;
    private static String routerOwner;
    private static String superGroup;
    private static boolean isPermissionEnabled;
    private boolean iStateStoreCache;

    public RouterAdminServer(Configuration conf, Router router) throws IOException {
        super(RouterAdminServer.class.getName());
        this.conf = conf;
        this.router = router;
        int handlerCount = this.conf.getInt("dfs.federation.router.admin.handler.count", 1);
        RPC.setProtocolEngine((Configuration)this.conf, RouterAdminProtocolPB.class, ProtobufRpcEngine2.class);
        RouterAdminProtocolServerSideTranslatorPB routerAdminProtocolTranslator = new RouterAdminProtocolServerSideTranslatorPB(this);
        BlockingService clientNNPbService = RouterProtocolProtos.RouterAdminProtocolService.newReflectiveBlockingService(routerAdminProtocolTranslator);
        InetSocketAddress confRpcAddress = conf.getSocketAddr("dfs.federation.router.admin-bind-host", "dfs.federation.router.admin-address", "0.0.0.0:8111", 8111);
        String bindHost = conf.get("dfs.federation.router.admin-bind-host", confRpcAddress.getHostName());
        LOG.info("Admin server binding to {}:{}", (Object)bindHost, (Object)confRpcAddress.getPort());
        RouterAdminServer.initializePermissionSettings(this.conf);
        this.adminServer = new RPC.Builder(this.conf).setProtocol(RouterAdminProtocolPB.class).setInstance((Object)clientNNPbService).setBindAddress(bindHost).setPort(confRpcAddress.getPort()).setNumHandlers(handlerCount).setVerbose(false).build();
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.adminServer.refreshServiceAcl(conf, (PolicyProvider)new RouterPolicyProvider());
        }
        InetSocketAddress listenAddress = this.adminServer.getListenerAddress();
        this.adminAddress = new InetSocketAddress(confRpcAddress.getHostName(), listenAddress.getPort());
        router.setAdminServerAddress(this.adminAddress);
        this.iStateStoreCache = router.getSubclusterResolver() instanceof StateStoreCache;
        GenericRefreshProtocolServerSideTranslatorPB genericRefreshXlator = new GenericRefreshProtocolServerSideTranslatorPB((GenericRefreshProtocol)this);
        BlockingService genericRefreshService = GenericRefreshProtocolProtos.GenericRefreshProtocolService.newReflectiveBlockingService((GenericRefreshProtocolProtos.GenericRefreshProtocolService.BlockingInterface)genericRefreshXlator);
        RefreshCallQueueProtocolServerSideTranslatorPB refreshCallQueueXlator = new RefreshCallQueueProtocolServerSideTranslatorPB((RefreshCallQueueProtocol)this);
        BlockingService refreshCallQueueService = RefreshCallQueueProtocolProtos.RefreshCallQueueProtocolService.newReflectiveBlockingService((RefreshCallQueueProtocolProtos.RefreshCallQueueProtocolService.BlockingInterface)refreshCallQueueXlator);
        DFSUtil.addPBProtocol((Configuration)conf, GenericRefreshProtocolPB.class, (BlockingService)genericRefreshService, (RPC.Server)this.adminServer);
        DFSUtil.addPBProtocol((Configuration)conf, RefreshCallQueueProtocolPB.class, (BlockingService)refreshCallQueueService, (RPC.Server)this.adminServer);
    }

    private static void initializePermissionSettings(Configuration routerConf) throws IOException {
        routerOwner = UserGroupInformation.getCurrentUser().getShortUserName();
        superGroup = routerConf.get("dfs.permissions.superusergroup", "supergroup");
        isPermissionEnabled = routerConf.getBoolean("dfs.permissions.enabled", true);
    }

    @VisibleForTesting
    RPC.Server getAdminServer() {
        return this.adminServer;
    }

    private MountTableStore getMountTableStore() throws IOException {
        if (this.mountTableStore == null) {
            this.mountTableStore = this.router.getStateStore().getRegisteredRecordStore(MountTableStore.class);
            if (this.mountTableStore == null) {
                throw new IOException("Mount table state store is not available.");
            }
        }
        return this.mountTableStore;
    }

    private DisabledNameserviceStore getDisabledNameserviceStore() throws IOException {
        if (this.disabledStore == null) {
            this.disabledStore = this.router.getStateStore().getRegisteredRecordStore(DisabledNameserviceStore.class);
            if (this.disabledStore == null) {
                throw new IOException("Disabled Nameservice state store is not available.");
            }
        }
        return this.disabledStore;
    }

    public InetSocketAddress getRpcAddress() {
        return this.adminAddress;
    }

    void checkSuperuserPrivilege() throws AccessControlException {
        RouterPermissionChecker pc = RouterAdminServer.getPermissionChecker();
        if (pc != null) {
            pc.checkSuperuserPrivilege();
        }
    }

    protected void serviceInit(Configuration configuration) throws Exception {
        this.conf = configuration;
        super.serviceInit(this.conf);
    }

    protected void serviceStart() throws Exception {
        this.adminServer.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.adminServer != null) {
            this.adminServer.stop();
        }
        super.serviceStop();
    }

    @Override
    public AddMountTableEntryResponse addMountTableEntry(AddMountTableEntryRequest request) throws IOException {
        return this.getMountTableStore().addMountTableEntry(request);
    }

    @Override
    public UpdateMountTableEntryResponse updateMountTableEntry(UpdateMountTableEntryRequest request) throws IOException {
        MountTable updateEntry = request.getEntry();
        MountTable oldEntry = null;
        if (this.router.getSubclusterResolver() instanceof MountTableResolver) {
            MountTableResolver mResolver = (MountTableResolver)this.router.getSubclusterResolver();
            oldEntry = mResolver.getMountPoint(updateEntry.getSourcePath());
        }
        UpdateMountTableEntryResponse response = this.getMountTableStore().updateMountTableEntry(request);
        try {
            if (updateEntry != null && this.router.isQuotaEnabled()) {
                if (this.isQuotaUpdated(request, oldEntry)) {
                    this.synchronizeQuota(updateEntry.getSourcePath(), updateEntry.getQuota().getQuota(), updateEntry.getQuota().getSpaceQuota(), null);
                }
                RouterQuotaUsage newQuota = request.getEntry().getQuota();
                boolean locationsChanged = oldEntry == null || !oldEntry.getDestinations().equals(updateEntry.getDestinations());
                for (StorageType t : StorageType.values()) {
                    if (!locationsChanged && oldEntry.getQuota().getTypeQuota(t) == newQuota.getTypeQuota(t)) continue;
                    this.synchronizeQuota(updateEntry.getSourcePath(), Long.MAX_VALUE, newQuota.getTypeQuota(t), t);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to reset quota at the destinations for {}: {}", (Object)request.getEntry(), (Object)e.getMessage());
        }
        return response;
    }

    private boolean isQuotaUpdated(UpdateMountTableEntryRequest request, MountTable oldEntry) throws IOException {
        if (oldEntry != null) {
            MountTable updateEntry = request.getEntry();
            if (!oldEntry.getDestinations().equals(updateEntry.getDestinations())) {
                return true;
            }
            RouterQuotaUsage preQuota = oldEntry.getQuota();
            long nsQuota = preQuota.getQuota();
            long ssQuota = preQuota.getSpaceQuota();
            RouterQuotaUsage mountQuota = updateEntry.getQuota();
            return nsQuota != mountQuota.getQuota() || ssQuota != mountQuota.getSpaceQuota();
        }
        return true;
    }

    private void synchronizeQuota(String path, long nsQuota, long ssQuota, StorageType type) throws IOException {
        if (this.isQuotaSyncRequired(nsQuota, ssQuota)) {
            if (this.iStateStoreCache) {
                ((StateStoreCache)((Object)this.router.getSubclusterResolver())).loadCache(true);
            }
            Quota routerQuota = this.router.getRpcServer().getQuotaModule();
            routerQuota.setQuota(path, nsQuota, ssQuota, type, false);
        }
    }

    private boolean isQuotaSyncRequired(long nsQuota, long ssQuota) {
        return this.router.isQuotaEnabled() && (nsQuota != Long.MAX_VALUE || ssQuota != Long.MAX_VALUE);
    }

    @Override
    public RemoveMountTableEntryResponse removeMountTableEntry(RemoveMountTableEntryRequest request) throws IOException {
        try {
            this.synchronizeQuota(request.getSrcPath(), -1L, -1L, null);
        }
        catch (Exception e) {
            LOG.warn("Unable to clear quota at the destinations for {}: {}", (Object)request.getSrcPath(), (Object)e.getMessage());
        }
        return this.getMountTableStore().removeMountTableEntry(request);
    }

    @Override
    public GetMountTableEntriesResponse getMountTableEntries(GetMountTableEntriesRequest request) throws IOException {
        return this.getMountTableStore().getMountTableEntries(request);
    }

    @Override
    public EnterSafeModeResponse enterSafeMode(EnterSafeModeRequest request) throws IOException {
        this.checkSuperuserPrivilege();
        boolean success = false;
        RouterSafemodeService safeModeService = this.router.getSafemodeService();
        if (safeModeService != null) {
            this.router.updateRouterState(RouterServiceState.SAFEMODE);
            safeModeService.setManualSafeMode(true);
            success = this.verifySafeMode(true);
            if (success) {
                LOG.info("STATE* Safe mode is ON.\nIt was turned on manually. Use \"hdfs dfsrouteradmin -safemode leave\" to turn safe mode off.");
            } else {
                LOG.error("Unable to enter safemode.");
            }
        }
        return EnterSafeModeResponse.newInstance(success);
    }

    @Override
    public LeaveSafeModeResponse leaveSafeMode(LeaveSafeModeRequest request) throws IOException {
        this.checkSuperuserPrivilege();
        boolean success = false;
        RouterSafemodeService safeModeService = this.router.getSafemodeService();
        if (safeModeService != null) {
            this.router.updateRouterState(RouterServiceState.RUNNING);
            safeModeService.setManualSafeMode(false);
            success = this.verifySafeMode(false);
            if (success) {
                LOG.info("STATE* Safe mode is OFF.\nIt was turned off manually.");
            } else {
                LOG.error("Unable to leave safemode.");
            }
        }
        return LeaveSafeModeResponse.newInstance(success);
    }

    @Override
    public GetSafeModeResponse getSafeMode(GetSafeModeRequest request) throws IOException {
        boolean isInSafeMode = false;
        RouterSafemodeService safeModeService = this.router.getSafemodeService();
        if (safeModeService != null) {
            isInSafeMode = safeModeService.isInSafeMode();
            LOG.info("Safemode status retrieved successfully.");
        }
        return GetSafeModeResponse.newInstance(isInSafeMode);
    }

    @Override
    public RefreshMountTableEntriesResponse refreshMountTableEntries(RefreshMountTableEntriesRequest request) throws IOException {
        if (this.iStateStoreCache) {
            boolean result = ((StateStoreCache)((Object)this.router.getSubclusterResolver())).loadCache(true);
            RefreshMountTableEntriesResponse response = RefreshMountTableEntriesResponse.newInstance();
            response.setResult(result);
            return response;
        }
        return this.getMountTableStore().refreshMountTableEntries(request);
    }

    @Override
    public GetDestinationResponse getDestination(GetDestinationRequest request) throws IOException {
        String src = request.getSrcPath();
        ArrayList<String> nsIds = new ArrayList<String>();
        RouterRpcServer rpcServer = this.router.getRpcServer();
        List<RemoteLocation> locations = rpcServer.getLocationsForPath(src, false);
        RouterRpcClient rpcClient = rpcServer.getRPCClient();
        RemoteMethod method = new RemoteMethod("getFileInfo", new Class[]{String.class}, new RemoteParam());
        try {
            Map<RemoteLocation, HdfsFileStatus> responses = rpcClient.invokeConcurrent(locations, method, false, false, HdfsFileStatus.class);
            for (RemoteLocation location : locations) {
                if (responses.get(location) == null) continue;
                nsIds.add(location.getNameserviceId());
            }
        }
        catch (IOException ioe) {
            LOG.error("Cannot get location for {}: {}", (Object)src, (Object)ioe.getMessage());
        }
        if (nsIds.isEmpty() && !locations.isEmpty()) {
            String nsId = locations.get(0).getNameserviceId();
            nsIds.add(nsId);
        }
        return GetDestinationResponse.newInstance(nsIds);
    }

    private boolean verifySafeMode(boolean isInSafeMode) {
        Preconditions.checkNotNull((Object)((Object)this.router.getSafemodeService()));
        boolean serverInSafeMode = this.router.getSafemodeService().isInSafeMode();
        RouterServiceState currentState = this.router.getRouterState();
        return isInSafeMode && currentState == RouterServiceState.SAFEMODE && serverInSafeMode || !isInSafeMode && currentState != RouterServiceState.SAFEMODE && !serverInSafeMode;
    }

    @Override
    public DisableNameserviceResponse disableNameservice(DisableNameserviceRequest request) throws IOException {
        this.checkSuperuserPrivilege();
        String nsId = request.getNameServiceId();
        boolean success = false;
        if (this.namespaceExists(nsId)) {
            success = this.getDisabledNameserviceStore().disableNameservice(nsId);
            if (success) {
                LOG.info("Nameservice {} disabled successfully.", (Object)nsId);
            } else {
                LOG.error("Unable to disable Nameservice {}", (Object)nsId);
            }
        } else {
            LOG.error("Cannot disable {}, it does not exists", (Object)nsId);
        }
        return DisableNameserviceResponse.newInstance(success);
    }

    private boolean namespaceExists(String nsId) throws IOException {
        boolean found = false;
        ActiveNamenodeResolver resolver = this.router.getNamenodeResolver();
        Set<FederationNamespaceInfo> nss = resolver.getNamespaces();
        for (FederationNamespaceInfo ns : nss) {
            if (!nsId.equals(ns.getNameserviceId())) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public EnableNameserviceResponse enableNameservice(EnableNameserviceRequest request) throws IOException {
        this.checkSuperuserPrivilege();
        String nsId = request.getNameServiceId();
        DisabledNameserviceStore store = this.getDisabledNameserviceStore();
        Set<String> disabled = store.getDisabledNameservices();
        boolean success = false;
        if (disabled.contains(nsId)) {
            success = store.enableNameservice(nsId);
            if (success) {
                LOG.info("Nameservice {} enabled successfully.", (Object)nsId);
            } else {
                LOG.error("Unable to enable Nameservice {}", (Object)nsId);
            }
        } else {
            LOG.error("Cannot enable {}, it was not disabled", (Object)nsId);
        }
        return EnableNameserviceResponse.newInstance(success);
    }

    @Override
    public GetDisabledNameservicesResponse getDisabledNameservices(GetDisabledNameservicesRequest request) throws IOException {
        Set<String> nsIds = this.getDisabledNameserviceStore().getDisabledNameservices();
        return GetDisabledNameservicesResponse.newInstance(nsIds);
    }

    public static RouterPermissionChecker getPermissionChecker() throws AccessControlException {
        if (!isPermissionEnabled) {
            return null;
        }
        try {
            return new RouterPermissionChecker(routerOwner, superGroup, NameNode.getRemoteUser());
        }
        catch (IOException e) {
            throw new AccessControlException((Throwable)e);
        }
    }

    public static String getSuperUser() {
        return routerOwner;
    }

    public static String getSuperGroup() {
        return superGroup;
    }

    public Collection<RefreshResponse> refresh(String identifier, String[] args) {
        return RefreshRegistry.defaultRegistry().dispatch(identifier, args);
    }

    @Override
    public boolean refreshSuperUserGroupsConfiguration() throws IOException {
        ProxyUsers.refreshSuperUserGroupsConfiguration();
        return true;
    }

    public void refreshCallQueue() throws IOException {
        LOG.info("Refreshing call queue.");
        Configuration configuration = new Configuration();
        this.router.getRpcServer().getServer().refreshCallQueue(configuration);
    }
}

