/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.security.token;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.ZKDelegationTokenSecretManager;
import org.apache.hadoop.util.Time;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKDelegationTokenSecretManagerImpl
extends ZKDelegationTokenSecretManager<AbstractDelegationTokenIdentifier> {
    public static final String ZK_DTSM_ROUTER_TOKEN_SYNC_INTERVAL = "zk-dt-secret-manager.router.token.sync.interval";
    public static final int ZK_DTSM_ROUTER_TOKEN_SYNC_INTERVAL_DEFAULT = 5;
    private static final Logger LOG = LoggerFactory.getLogger(ZKDelegationTokenSecretManagerImpl.class);
    private Configuration conf;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final Set<AbstractDelegationTokenIdentifier> localTokenCache = new HashSet<AbstractDelegationTokenIdentifier>();
    private ZooKeeper zookeeper;
    private final String TOKEN_PATH = "/" + this.zkClient.getNamespace() + "/ZKDTSMTokensRoot";
    private ThreadLocal<Boolean> checkAgainstZkBeforeDeletion = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };

    public ZKDelegationTokenSecretManagerImpl(Configuration conf) {
        super(conf);
        this.conf = conf;
        try {
            this.startThreads();
        }
        catch (IOException e) {
            LOG.error("Error starting threads for zkDelegationTokens", (Throwable)e);
        }
        LOG.info("Zookeeper delegation token secret manager instantiated");
    }

    public void startThreads() throws IOException {
        super.startThreads();
        if (!this.isTokenWatcherEnabled()) {
            LOG.info("Watcher for tokens is disabled in this secret manager");
            try {
                block9: {
                    this.checkAgainstZkBeforeDeletion.set(true);
                    if (this.zkClient.checkExists().forPath("/ZKDTSMTokensRoot") == null) {
                        ((ACLBackgroundPathAndBytesable)this.zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath("/ZKDTSMTokensRoot");
                    }
                    try {
                        this.zookeeper = this.zkClient.getZookeeperClient().getZooKeeper();
                    }
                    catch (Exception e) {
                        LOG.info("Cannot get zookeeper client ", (Throwable)e);
                    }
                    finally {
                        if (this.zookeeper != null) break block9;
                        throw new IOException("Zookeeper client is null");
                    }
                }
                LOG.info("Start loading token cache");
                long start = Time.now();
                this.rebuildTokenCache(true);
                LOG.info("Loaded token cache in {} milliseconds", (Object)(Time.now() - start));
                int syncInterval = this.conf.getInt(ZK_DTSM_ROUTER_TOKEN_SYNC_INTERVAL, 5);
                this.scheduler.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ZKDelegationTokenSecretManagerImpl.this.rebuildTokenCache(false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, syncInterval, syncInterval, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.error("Error rebuilding local cache for zkDelegationTokens ", (Throwable)e);
            }
        }
    }

    public void stopThreads() {
        super.stopThreads();
        this.scheduler.shutdown();
    }

    public DelegationTokenIdentifier createIdentifier() {
        return new DelegationTokenIdentifier();
    }

    private void rebuildTokenCache(boolean initial) throws IOException {
        List zkTokens;
        this.localTokenCache.clear();
        try {
            zkTokens = this.zookeeper.getChildren(this.TOKEN_PATH, false);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Tokens cannot be fetched from path " + this.TOKEN_PATH, e);
        }
        for (String tokenPath : zkTokens) {
            byte[] data;
            try {
                data = (byte[])this.zkClient.getData().forPath("/ZKDTSMTokensRoot/" + tokenPath);
            }
            catch (KeeperException.NoNodeException e) {
                LOG.debug("No node in path [" + tokenPath + "]");
                continue;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
            AbstractDelegationTokenIdentifier ident = this.processTokenAddOrUpdate(data);
            this.localTokenCache.add(ident);
        }
        if (!initial) {
            for (AbstractDelegationTokenIdentifier ident : this.currentTokens.keySet()) {
                if (this.localTokenCache.contains(ident)) continue;
                this.currentTokens.remove(ident);
            }
        }
    }

    public AbstractDelegationTokenIdentifier cancelToken(Token<AbstractDelegationTokenIdentifier> token, String canceller) throws IOException {
        this.checkAgainstZkBeforeDeletion.set(false);
        AbstractDelegationTokenIdentifier ident = super.cancelToken(token, canceller);
        this.checkAgainstZkBeforeDeletion.set(true);
        return ident;
    }

    protected void removeStoredToken(AbstractDelegationTokenIdentifier ident) throws IOException {
        super.removeStoredToken(ident, this.checkAgainstZkBeforeDeletion.get().booleanValue());
    }

    protected void addOrUpdateToken(AbstractDelegationTokenIdentifier ident, AbstractDelegationTokenSecretManager.DelegationTokenInformation info, boolean isUpdate) throws Exception {
        this.currentTokens.put(ident, info);
        super.addOrUpdateToken(ident, info, isUpdate);
    }
}

