/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.collector;

import java.util.concurrent.Future;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AppLevelTimelineCollector
extends TimelineCollector {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineCollector.class);
    private final ApplicationId appId;
    private final String appUser;
    private final TimelineCollectorContext context;
    private UserGroupInformation currentUser;
    private Token<TimelineDelegationTokenIdentifier> delegationTokenForApp;
    private long tokenMaxDate = 0L;
    private String tokenRenewer;
    private Future<?> renewalOrRegenerationFuture;

    public AppLevelTimelineCollector(ApplicationId appId) {
        this(appId, null);
    }

    public AppLevelTimelineCollector(ApplicationId appId, String user) {
        super(AppLevelTimelineCollector.class.getName() + " - " + appId.toString());
        Preconditions.checkNotNull((Object)appId, (Object)"AppId shouldn't be null");
        this.appId = appId;
        this.appUser = user;
        this.context = new TimelineCollectorContext();
    }

    public UserGroupInformation getCurrentUser() {
        return this.currentUser;
    }

    public String getAppUser() {
        return this.appUser;
    }

    void setDelegationTokenAndFutureForApp(Token<TimelineDelegationTokenIdentifier> token, Future<?> appRenewalOrRegenerationFuture, long tknMaxDate, String renewer) {
        this.delegationTokenForApp = token;
        this.tokenMaxDate = tknMaxDate;
        this.tokenRenewer = renewer;
        this.renewalOrRegenerationFuture = appRenewalOrRegenerationFuture;
    }

    void setRenewalOrRegenerationFutureForApp(Future<?> appRenewalOrRegenerationFuture) {
        this.renewalOrRegenerationFuture = appRenewalOrRegenerationFuture;
    }

    void cancelRenewalOrRegenerationFutureForApp() {
        if (this.renewalOrRegenerationFuture != null && !this.renewalOrRegenerationFuture.isDone()) {
            this.renewalOrRegenerationFuture.cancel(true);
        }
    }

    long getAppDelegationTokenMaxDate() {
        return this.tokenMaxDate;
    }

    String getAppDelegationTokenRenewer() {
        return this.tokenRenewer;
    }

    @VisibleForTesting
    public Token<TimelineDelegationTokenIdentifier> getDelegationTokenForApp() {
        return this.delegationTokenForApp;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        this.context.setClusterId(conf.get("yarn.resourcemanager.cluster-id", "yarn_cluster"));
        this.currentUser = UserGroupInformation.getCurrentUser();
        this.context.setUserId(this.currentUser.getShortUserName());
        this.context.setAppId(this.appId.toString());
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        this.cancelRenewalOrRegenerationFutureForApp();
        super.serviceStop();
    }

    @Override
    public TimelineCollectorContext getTimelineEntityContext() {
        return this.context;
    }
}

