/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.buffertofile.DataSerializer;
import com.github.davidmoten.rx.internal.operators.NullSentinel;
import com.github.davidmoten.util.ByteArrayOutputStreamNoCopyUnsynchronized;
import com.github.davidmoten.util.Preconditions;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;

public class FileBasedSPSCQueueMemoryMappedReaderWriter<T> {
    private volatile RandomAccessFile f;
    private volatile FileChannel channel;
    private DataInputStream input;
    private DataOutputStream output;
    private MappedByteBuffer read;
    private MappedByteBuffer write;
    private final DataSerializer<T> serializer;
    private final File file;
    private final int fileSize;
    private final DataOutput buffer;
    private final ByteArrayOutputStreamNoCopyUnsynchronized bytes;
    private final AtomicInteger status = new AtomicInteger(0);
    private final Object markerLock = new Object();
    static final int WRITTEN_READ = 0;
    static final int WRITTEN_READ_NOT_STARTED = 1;
    static final int WRITTEN_READING = 2;
    static final int WRITING_NOT_READING = 3;
    static final int WRITING_READING = 4;
    private static final EOFRuntimeException EOF = new EOFRuntimeException();
    static final byte MARKER_END_OF_QUEUE = 0;
    static final byte MARKER_END_OF_FILE = 1;
    static final byte MARKER_ITEM_PRESENT = 2;
    static final int MARKER_HEADER_SIZE = 1;
    static final int UNKNOWN_LENGTH = 0;

    public FileBasedSPSCQueueMemoryMappedReaderWriter(File file, int fileSize, DataSerializer<T> serializer) {
        Preconditions.checkArgument(serializer.size() == 0 || serializer.size() <= fileSize - 2, "serializer.size() must be less than or equal to file based queue size - 2");
        this.file = file;
        this.serializer = serializer;
        this.fileSize = fileSize;
        this.bytes = new ByteArrayOutputStreamNoCopyUnsynchronized();
        this.buffer = new DataOutputStream(this.bytes);
    }

    public FileBasedSPSCQueueMemoryMappedReaderWriter<T> openForRead() {
        int newStatus;
        int st;
        if (!this.status.compareAndSet(1, 2)) {
            this.status.compareAndSet(3, 4);
        }
        while (!this.status.compareAndSet(st, newStatus = (st = this.status.get()) == 1 ? 2 : (st == 3 ? 4 : st))) {
        }
        this.checkClose(newStatus);
        try {
            if (this.f == null) {
                this.f = new RandomAccessFile(this.file, "r");
            }
            if (this.channel == null) {
                this.channel = this.f.getChannel();
            }
            this.read = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size());
            this.input = new DataInputStream(new MappedByteBufferInputStream(this.read));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void closeForRead() {
        int newStatus;
        int st;
        while (!this.status.compareAndSet(st, newStatus = (st = this.status.get()) == 2 ? 0 : st)) {
        }
        this.checkClose(newStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBasedSPSCQueueMemoryMappedReaderWriter<T> openForWrite() {
        int newStatus;
        int st2;
        while (!this.status.compareAndSet(st2, newStatus = (st2 = this.status.get()) == 0 ? 3 : st2)) {
        }
        this.checkClose(newStatus);
        try {
            if (this.f == null) {
                this.f = new RandomAccessFile(this.file, "rw");
            }
            if (this.channel == null) {
                this.channel = this.f.getChannel();
            }
            this.write = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, this.fileSize);
            this.output = new DataOutputStream(new MappedByteBufferOutputStream(this.write));
            Object st2 = this.markerLock;
            synchronized (st2) {
                this.output.write(0);
            }
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void closeForWrite() {
        int newStatus;
        int st;
        do {
            if ((st = this.status.get()) == 4) {
                newStatus = 2;
                continue;
            }
            if (st != 3) continue;
            newStatus = 1;
        } while (!this.status.compareAndSet(st, newStatus = st));
        this.checkClose(newStatus);
    }

    private void checkClose(int newStatus) {
        if (newStatus == 0) {
            try {
                this.channel.close();
                this.channel = null;
                this.read = null;
                this.input = null;
                this.f.close();
                this.f = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static int toUnsignedInteger(byte b) {
        return b & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll() {
        byte marker;
        int position = this.read.position();
        Object object = this.markerLock;
        synchronized (object) {
            marker = this.read.get();
        }
        if (marker == 0) {
            this.read.position(position);
            return null;
        }
        if (marker == 1) {
            throw EOF;
        }
        if (marker == 2) {
            try {
                T t = this.serializer.deserialize(this.input);
                if (t == null) {
                    return NullSentinel.instance();
                }
                return t;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("unexpected");
    }

    public boolean offer(T t) {
        int serializedLength = this.serializer.size();
        if (serializedLength == 0) {
            return this.offerUnknownLength(t);
        }
        return this.offerKnownLength(t, serializedLength);
    }

    private boolean offerKnownLength(T t, int serializedLength) {
        try {
            if (this.notEnoughSpace(serializedLength)) {
                this.markFileAsCompletedAndClose();
                return false;
            }
            int position = this.write.position();
            this.serializer.serialize(this.output, t);
            int length = this.write.position() - position;
            this.checkLength(serializedLength, length);
            this.updateMarkers(serializedLength);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean offerUnknownLength(T t) {
        try {
            this.bytes.reset();
            this.serializer.serialize(this.buffer, t);
            int serializedLength = this.bytes.size();
            if (this.notEnoughSpace(serializedLength)) {
                this.markFileAsCompletedAndClose();
                return false;
            }
            this.write.put(this.bytes.toByteArrayNoCopy(), 0, this.bytes.size());
            this.updateMarkers(serializedLength);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkLength(int serializedLength, int length) {
        if (length > serializedLength) {
            throw new IllegalArgumentException("serialized length of value being offered to file queue was greater than serializer.size() value (which was non-zero)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markFileAsCompletedAndClose() {
        this.write.position(this.write.position() - 1);
        Object object = this.markerLock;
        synchronized (object) {
            this.write.put((byte)1);
        }
        this.closeForWrite();
    }

    private boolean notEnoughSpace(int serializedLength) {
        if (serializedLength > this.fileSize - 2) {
            throw new RuntimeException("serialized length is larger than can fit in one file");
        }
        return serializedLength + 1 > this.write.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMarkers(int serializedLength) throws IOException {
        this.write.put((byte)0);
        int newWritePosition = this.write.position();
        this.write.position(this.write.position() - serializedLength - 2);
        Object object = this.markerLock;
        synchronized (object) {
            this.write.put((byte)2);
        }
        this.write.position(newWritePosition);
    }

    public void close() {
        try {
            this.f.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static final class EOFRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = -6943467453336359472L;

        EOFRuntimeException() {
        }
    }

    private static class MappedByteBufferInputStream
    extends InputStream {
        private final MappedByteBuffer read;

        MappedByteBufferInputStream(MappedByteBuffer read) {
            this.read = read;
        }

        @Override
        public int read() throws IOException {
            return FileBasedSPSCQueueMemoryMappedReaderWriter.toUnsignedInteger(this.read.get());
        }
    }

    private static class MappedByteBufferOutputStream
    extends OutputStream {
        private final MappedByteBuffer write;

        MappedByteBufferOutputStream(MappedByteBuffer write) {
            this.write = write;
        }

        @Override
        public void write(int b) throws IOException {
            this.write.put((byte)b);
        }
    }
}

