/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.sun.jersey.server.impl.container.filter;

import java.net.URI;
import org.apache.hadoop.shaded.com.sun.jersey.api.core.ResourceConfig;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.uri.UriHelper;
import org.apache.hadoop.shaded.com.sun.jersey.spi.container.ContainerRequest;
import org.apache.hadoop.shaded.com.sun.jersey.spi.container.ContainerRequestFilter;
import org.apache.hadoop.shaded.javax.ws.rs.WebApplicationException;
import org.apache.hadoop.shaded.javax.ws.rs.core.Context;
import org.apache.hadoop.shaded.javax.ws.rs.core.Response;

public class NormalizeFilter
implements ContainerRequestFilter {
    @Context
    ResourceConfig resourceConfig;

    @Override
    public ContainerRequest filter(ContainerRequest request) {
        URI normalizedUri;
        URI uri;
        if (this.resourceConfig.getFeature("org.apache.hadoop.shaded.com.sun.jersey.config.feature.NormalizeURI") && (uri = request.getRequestUri()) != (normalizedUri = UriHelper.normalize(uri, !this.resourceConfig.getFeature("org.apache.hadoop.shaded.com.sun.jersey.config.feature.CanonicalizeURIPath")))) {
            if (this.resourceConfig.getFeature("org.apache.hadoop.shaded.com.sun.jersey.config.feature.Redirect")) {
                throw new WebApplicationException(Response.temporaryRedirect((URI)normalizedUri).build());
            }
            URI baseUri = UriHelper.normalize(request.getBaseUri(), !this.resourceConfig.getFeature("org.apache.hadoop.shaded.com.sun.jersey.config.feature.CanonicalizeURIPath"));
            request.setUris(baseUri, normalizedUri);
        }
        return request;
    }
}

