/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Test;

public class TestErasureCodingCorruption {
    @Test
    public void testCorruptionDuringFailover() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.corrupt.block.delete.immediately.enabled", false);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(8).build();){
            cluster.transitionToActive(0);
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem(0);
            dfs.mkdirs(new Path("/dir"));
            dfs.setErasureCodingPolicy(new Path("/dir"), "RS-6-3-1024k");
            FSDataOutputStream out = dfs.create(new Path("/dir/file"));
            for (int i = 0; i < 0xF00000; ++i) {
                out.write(i);
            }
            MiniDFSCluster.DataNodeProperties dn = cluster.stopDataNode(0);
            for (int i = 0; i < 0x700000; ++i) {
                out.write(i);
            }
            out.close();
            BlockManager bm = cluster.getNamesystem(0).getBlockManager();
            cluster.transitionToStandby(0);
            cluster.transitionToActive(0);
            cluster.restartDataNode(dn);
            GenericTestUtils.waitFor(() -> bm.getCorruptECBlockGroups() == 0L, (long)100L, (long)10000L);
        }
    }
}

