/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

public final class JobHistoryEventUtils {
    public static final int ATS_CONFIG_PUBLISH_SIZE_BYTES = 10240;

    private JobHistoryEventUtils() {
    }

    public static JsonNode countersToJSON(Counters counters) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode nodes = mapper.createArrayNode();
        if (counters != null) {
            for (CounterGroup counterGroup : counters) {
                ObjectNode groupNode = nodes.addObject();
                groupNode.put("NAME", counterGroup.getName());
                groupNode.put("DISPLAY_NAME", counterGroup.getDisplayName());
                ArrayNode countersNode = groupNode.putArray("COUNTERS");
                for (Counter counter : counterGroup) {
                    ObjectNode counterNode = countersNode.addObject();
                    counterNode.put("NAME", counter.getName());
                    counterNode.put("DISPLAY_NAME", counter.getDisplayName());
                    counterNode.put("VALUE", counter.getValue());
                }
            }
        }
        return nodes;
    }

    public static Set<TimelineMetric> countersToTimelineMetric(Counters counters, long timestamp) {
        return JobHistoryEventUtils.countersToTimelineMetric(counters, timestamp, "");
    }

    public static Set<TimelineMetric> countersToTimelineMetric(Counters counters, long timestamp, String groupNamePrefix) {
        HashSet<TimelineMetric> entityMetrics = new HashSet<TimelineMetric>();
        for (CounterGroup g : counters) {
            String groupName = g.getName();
            for (Counter c : g) {
                String name = groupNamePrefix + groupName + ":" + c.getName();
                TimelineMetric metric = new TimelineMetric();
                metric.setId(name);
                metric.addValue(timestamp, (Number)c.getValue());
                entityMetrics.add(metric);
            }
        }
        return entityMetrics;
    }
}

