/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@Metrics(name="RouterClientActivity", about="Router metrics", context="dfs")
public class RouterClientMetrics {
    private final MetricsRegistry registry = new MetricsRegistry("router");
    @Metric
    private MutableCounterLong getBlockLocationsOps;
    @Metric
    private MutableCounterLong getServerDefaultsOps;
    @Metric
    private MutableCounterLong createOps;
    @Metric
    private MutableCounterLong appendOps;
    @Metric
    private MutableCounterLong recoverLeaseOps;
    @Metric
    private MutableCounterLong setReplicationOps;
    @Metric
    private MutableCounterLong setStoragePolicyOps;
    @Metric
    private MutableCounterLong getStoragePoliciesOps;
    @Metric
    private MutableCounterLong setPermissionOps;
    @Metric
    private MutableCounterLong setOwnerOps;
    @Metric
    private MutableCounterLong addBlockOps;
    @Metric
    private MutableCounterLong getAdditionalDatanodeOps;
    @Metric
    private MutableCounterLong abandonBlockOps;
    @Metric
    private MutableCounterLong completeOps;
    @Metric
    private MutableCounterLong updateBlockForPipelineOps;
    @Metric
    private MutableCounterLong updatePipelineOps;
    @Metric
    private MutableCounterLong getPreferredBlockSizeOps;
    @Metric
    private MutableCounterLong renameOps;
    @Metric
    private MutableCounterLong rename2Ops;
    @Metric
    private MutableCounterLong concatOps;
    @Metric
    private MutableCounterLong truncateOps;
    @Metric
    private MutableCounterLong deleteOps;
    @Metric
    private MutableCounterLong mkdirsOps;
    @Metric
    private MutableCounterLong renewLeaseOps;
    @Metric
    private MutableCounterLong getListingOps;
    @Metric
    private MutableCounterLong getBatchedListingOps;
    @Metric
    private MutableCounterLong getFileInfoOps;
    @Metric
    private MutableCounterLong isFileClosedOps;
    @Metric
    private MutableCounterLong getFileLinkInfoOps;
    @Metric
    private MutableCounterLong getLocatedFileInfoOps;
    @Metric
    private MutableCounterLong getStatsOps;
    @Metric
    private MutableCounterLong getDatanodeReportOps;
    @Metric
    private MutableCounterLong getDatanodeStorageReportOps;
    @Metric
    private MutableCounterLong setSafeModeOps;
    @Metric
    private MutableCounterLong restoreFailedStorageOps;
    @Metric
    private MutableCounterLong saveNamespaceOps;
    @Metric
    private MutableCounterLong rollEditsOps;
    @Metric
    private MutableCounterLong refreshNodesOps;
    @Metric
    private MutableCounterLong finalizeUpgradeOps;
    @Metric
    private MutableCounterLong upgradeStatusOps;
    @Metric
    private MutableCounterLong rollingUpgradeOps;
    @Metric
    private MutableCounterLong metaSaveOps;
    @Metric
    private MutableCounterLong listCorruptFileBlocksOps;
    @Metric
    private MutableCounterLong setBalancerBandwidthOps;
    @Metric
    private MutableCounterLong getContentSummaryOps;
    @Metric
    private MutableCounterLong fsyncOps;
    @Metric
    private MutableCounterLong setTimesOps;
    @Metric
    private MutableCounterLong createSymlinkOps;
    @Metric
    private MutableCounterLong getLinkTargetOps;
    @Metric
    private MutableCounterLong allowSnapshotOps;
    @Metric
    private MutableCounterLong disallowSnapshotOps;
    @Metric
    private MutableCounterLong renameSnapshotOps;
    @Metric
    private MutableCounterLong getSnapshottableDirListingOps;
    @Metric
    private MutableCounterLong getSnapshotListingOps;
    @Metric
    private MutableCounterLong getSnapshotDiffReportOps;
    @Metric
    private MutableCounterLong getSnapshotDiffReportListingOps;
    @Metric
    private MutableCounterLong addCacheDirectiveOps;
    @Metric
    private MutableCounterLong modifyCacheDirectiveOps;
    @Metric
    private MutableCounterLong removeCacheDirectiveOps;
    @Metric
    private MutableCounterLong listCacheDirectivesOps;
    @Metric
    private MutableCounterLong addCachePoolOps;
    @Metric
    private MutableCounterLong modifyCachePoolOps;
    @Metric
    private MutableCounterLong removeCachePoolOps;
    @Metric
    private MutableCounterLong listCachePoolsOps;
    @Metric
    private MutableCounterLong modifyAclEntriesOps;
    @Metric
    private MutableCounterLong removeAclEntriesOps;
    @Metric
    private MutableCounterLong removeDefaultAclOps;
    @Metric
    private MutableCounterLong removeAclOps;
    @Metric
    private MutableCounterLong setAclOps;
    @Metric
    private MutableCounterLong getAclStatusOps;
    @Metric
    private MutableCounterLong createEncryptionZoneOps;
    @Metric
    private MutableCounterLong getEZForPathOps;
    @Metric
    private MutableCounterLong listEncryptionZonesOps;
    @Metric
    private MutableCounterLong reencryptEncryptionZoneOps;
    @Metric
    private MutableCounterLong listReencryptionStatusOps;
    @Metric
    private MutableCounterLong setXAttrOps;
    @Metric
    private MutableCounterLong getXAttrsOps;
    @Metric
    private MutableCounterLong listXAttrsOps;
    @Metric
    private MutableCounterLong removeXAttrsOps;
    @Metric
    private MutableCounterLong checkAccessOps;
    @Metric
    private MutableCounterLong getCurrentEditLogTxidOps;
    @Metric
    private MutableCounterLong getEditsFromTxidOps;
    @Metric
    private MutableCounterLong getDataEncryptionKeyOps;
    @Metric
    private MutableCounterLong createSnapshotOps;
    @Metric
    private MutableCounterLong deleteSnapshotOps;
    @Metric
    private MutableCounterLong setQuotaOps;
    @Metric
    private MutableCounterLong getQuotaUsageOps;
    @Metric
    private MutableCounterLong reportBadBlocksOps;
    @Metric
    private MutableCounterLong unsetStoragePolicyOps;
    @Metric
    private MutableCounterLong getStoragePolicyOps;
    @Metric
    private MutableCounterLong getErasureCodingPoliciesOps;
    @Metric
    private MutableCounterLong getErasureCodingCodecsOps;
    @Metric
    private MutableCounterLong addErasureCodingPoliciesOps;
    @Metric
    private MutableCounterLong removeErasureCodingPolicyOps;
    @Metric
    private MutableCounterLong disableErasureCodingPolicyOps;
    @Metric
    private MutableCounterLong enableErasureCodingPolicyOps;
    @Metric
    private MutableCounterLong getErasureCodingPolicyOps;
    @Metric
    private MutableCounterLong setErasureCodingPolicyOps;
    @Metric
    private MutableCounterLong unsetErasureCodingPolicyOps;
    @Metric
    private MutableCounterLong getECTopologyResultForPoliciesOps;
    @Metric
    private MutableCounterLong getECBlockGroupStatsOps;
    @Metric
    private MutableCounterLong getReplicatedBlockStatsOps;
    @Metric
    private MutableCounterLong listOpenFilesOps;
    @Metric
    private MutableCounterLong msyncOps;
    @Metric
    private MutableCounterLong satisfyStoragePolicyOps;
    @Metric
    private MutableCounterLong getHAServiceStateOps;
    @Metric
    private MutableCounterLong otherOps;
    @Metric
    private MutableCounterLong getSlowDatanodeReportOps;
    @Metric
    private MutableCounterLong concurrentSetReplicationOps;
    @Metric
    private MutableCounterLong concurrentSetPermissionOps;
    @Metric
    private MutableCounterLong concurrentSetOwnerOps;
    @Metric
    private MutableCounterLong concurrentRenameOps;
    @Metric
    private MutableCounterLong concurrentRename2Ops;
    @Metric
    private MutableCounterLong concurrentDeleteOps;
    @Metric
    private MutableCounterLong concurrentMkdirsOps;
    @Metric
    private MutableCounterLong concurrentRenewLeaseOps;
    @Metric
    private MutableCounterLong concurrentGetListingOps;
    @Metric
    private MutableCounterLong concurrentGetFileInfoOps;
    @Metric
    private MutableCounterLong concurrentGetStatsOps;
    @Metric
    private MutableCounterLong concurrentGetDatanodeReportOps;
    @Metric
    private MutableCounterLong concurrentSetSafeModeOps;
    @Metric
    private MutableCounterLong concurrentRestoreFailedStorageOps;
    @Metric
    private MutableCounterLong concurrentSaveNamespaceOps;
    @Metric
    private MutableCounterLong concurrentRollEditsOps;
    @Metric
    private MutableCounterLong concurrentRefreshNodesOps;
    @Metric
    private MutableCounterLong concurrentFinalizeUpgradeOps;
    @Metric
    private MutableCounterLong concurrentRollingUpgradeOps;
    @Metric
    private MutableCounterLong concurrentMetaSaveOps;
    @Metric
    private MutableCounterLong concurrentListCorruptFileBlocksOps;
    @Metric
    private MutableCounterLong concurrentSetBalancerBandwidthOps;
    @Metric
    private MutableCounterLong concurrentGetContentSummaryOps;
    @Metric
    private MutableCounterLong concurrentModifyAclEntriesOps;
    @Metric
    private MutableCounterLong concurrentRemoveAclEntriesOps;
    @Metric
    private MutableCounterLong concurrentRemoveDefaultAclOps;
    @Metric
    private MutableCounterLong concurrentRemoveAclOps;
    @Metric
    private MutableCounterLong concurrentSetAclOps;
    @Metric
    private MutableCounterLong concurrentSetXAttrOps;
    @Metric
    private MutableCounterLong concurrentRemoveXAttrOps;
    @Metric
    private MutableCounterLong concurrentGetCurrentEditLogTxidOps;
    @Metric
    private MutableCounterLong concurrentGetReplicatedBlockStatsOps;
    @Metric
    private MutableCounterLong concurrentSetQuotaOps;
    @Metric
    private MutableCounterLong concurrentGetQuotaUsageOps;
    @Metric
    private MutableCounterLong concurrentOtherOps;
    @Metric
    private MutableCounterLong concurrentGetSlowDatanodeReportOps;

    RouterClientMetrics(String processName, String sessionId) {
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, processName).tag((MetricsInfo)MsInfo.SessionId, sessionId);
    }

    public static RouterClientMetrics create(Configuration conf) {
        String sessionId = conf.get("dfs.metrics.session-id");
        String processName = "Router";
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (RouterClientMetrics)ms.register((Object)new RouterClientMetrics(processName, sessionId));
    }

    public void shutdown() {
        DefaultMetricsSystem.shutdown();
    }

    public void incInvokedMethod(Method method) {
        switch (method.getName()) {
            case "getBlockLocations": {
                this.getBlockLocationsOps.incr();
                break;
            }
            case "getServerDefaults": {
                this.getServerDefaultsOps.incr();
                break;
            }
            case "create": {
                this.createOps.incr();
                break;
            }
            case "append": {
                this.appendOps.incr();
                break;
            }
            case "recoverLease": {
                this.recoverLeaseOps.incr();
                break;
            }
            case "setReplication": {
                this.setReplicationOps.incr();
                break;
            }
            case "setStoragePolicy": {
                this.setStoragePolicyOps.incr();
                break;
            }
            case "getStoragePolicies": {
                this.getStoragePoliciesOps.incr();
                break;
            }
            case "setPermission": {
                this.setPermissionOps.incr();
                break;
            }
            case "setOwner": {
                this.setOwnerOps.incr();
                break;
            }
            case "addBlock": {
                this.addBlockOps.incr();
                break;
            }
            case "getAdditionalDatanode": {
                this.getAdditionalDatanodeOps.incr();
                break;
            }
            case "abandonBlock": {
                this.abandonBlockOps.incr();
                break;
            }
            case "complete": {
                this.completeOps.incr();
                break;
            }
            case "updateBlockForPipeline": {
                this.updateBlockForPipelineOps.incr();
                break;
            }
            case "updatePipeline": {
                this.updatePipelineOps.incr();
                break;
            }
            case "getPreferredBlockSize": {
                this.getPreferredBlockSizeOps.incr();
                break;
            }
            case "rename": {
                this.renameOps.incr();
                break;
            }
            case "rename2": {
                this.rename2Ops.incr();
                break;
            }
            case "concat": {
                this.concatOps.incr();
                break;
            }
            case "truncate": {
                this.truncateOps.incr();
                break;
            }
            case "delete": {
                this.deleteOps.incr();
                break;
            }
            case "mkdirs": {
                this.mkdirsOps.incr();
                break;
            }
            case "renewLease": {
                this.renewLeaseOps.incr();
                break;
            }
            case "getListing": {
                this.getListingOps.incr();
                break;
            }
            case "getBatchedListing": {
                this.getBatchedListingOps.incr();
                break;
            }
            case "getFileInfo": {
                this.getFileInfoOps.incr();
                break;
            }
            case "isFileClosed": {
                this.isFileClosedOps.incr();
                break;
            }
            case "getFileLinkInfo": {
                this.getFileLinkInfoOps.incr();
                break;
            }
            case "getLocatedFileInfo": {
                this.getLocatedFileInfoOps.incr();
                break;
            }
            case "getStats": {
                this.getStatsOps.incr();
                break;
            }
            case "getDatanodeReport": {
                this.getDatanodeReportOps.incr();
                break;
            }
            case "getDatanodeStorageReport": {
                this.getDatanodeStorageReportOps.incr();
                break;
            }
            case "setSafeMode": {
                this.setSafeModeOps.incr();
                break;
            }
            case "restoreFailedStorage": {
                this.restoreFailedStorageOps.incr();
                break;
            }
            case "saveNamespace": {
                this.saveNamespaceOps.incr();
                break;
            }
            case "rollEdits": {
                this.rollEditsOps.incr();
                break;
            }
            case "refreshNodes": {
                this.refreshNodesOps.incr();
                break;
            }
            case "finalizeUpgrade": {
                this.finalizeUpgradeOps.incr();
                break;
            }
            case "upgradeStatus": {
                this.upgradeStatusOps.incr();
                break;
            }
            case "rollingUpgrade": {
                this.rollingUpgradeOps.incr();
                break;
            }
            case "metaSave": {
                this.metaSaveOps.incr();
                break;
            }
            case "listCorruptFileBlocks": {
                this.listCorruptFileBlocksOps.incr();
                break;
            }
            case "setBalancerBandwidth": {
                this.setBalancerBandwidthOps.incr();
                break;
            }
            case "getContentSummary": {
                this.getContentSummaryOps.incr();
                break;
            }
            case "fsync": {
                this.fsyncOps.incr();
                break;
            }
            case "setTimes": {
                this.setTimesOps.incr();
                break;
            }
            case "createSymlink": {
                this.createSymlinkOps.incr();
                break;
            }
            case "getLinkTarget": {
                this.getLinkTargetOps.incr();
                break;
            }
            case "allowSnapshot": {
                this.allowSnapshotOps.incr();
                break;
            }
            case "disallowSnapshot": {
                this.disallowSnapshotOps.incr();
                break;
            }
            case "renameSnapshot": {
                this.renameSnapshotOps.incr();
                break;
            }
            case "getSnapshottableDirListing": {
                this.getSnapshottableDirListingOps.incr();
                break;
            }
            case "getSnapshotListing": {
                this.getSnapshotListingOps.incr();
                break;
            }
            case "getSnapshotDiffReport": {
                this.getSnapshotDiffReportOps.incr();
                break;
            }
            case "getSnapshotDiffReportListing": {
                this.getSnapshotDiffReportListingOps.incr();
                break;
            }
            case "addCacheDirective": {
                this.addCacheDirectiveOps.incr();
                break;
            }
            case "modifyCacheDirective": {
                this.modifyCacheDirectiveOps.incr();
                break;
            }
            case "removeCacheDirective": {
                this.removeCacheDirectiveOps.incr();
                break;
            }
            case "listCacheDirectives": {
                this.listCacheDirectivesOps.incr();
                break;
            }
            case "addCachePool": {
                this.addCachePoolOps.incr();
                break;
            }
            case "modifyCachePool": {
                this.modifyCachePoolOps.incr();
                break;
            }
            case "removeCachePool": {
                this.removeCachePoolOps.incr();
                break;
            }
            case "listCachePools": {
                this.listCachePoolsOps.incr();
                break;
            }
            case "modifyAclEntries": {
                this.modifyAclEntriesOps.incr();
                break;
            }
            case "removeAclEntries": {
                this.removeAclEntriesOps.incr();
                break;
            }
            case "removeDefaultAcl": {
                this.removeDefaultAclOps.incr();
                break;
            }
            case "removeAcl": {
                this.removeAclOps.incr();
                break;
            }
            case "setAcl": {
                this.setAclOps.incr();
                break;
            }
            case "getAclStatus": {
                this.getAclStatusOps.incr();
                break;
            }
            case "createEncryptionZone": {
                this.createEncryptionZoneOps.incr();
                break;
            }
            case "getEZForPath": {
                this.getEZForPathOps.incr();
                break;
            }
            case "listEncryptionZones": {
                this.listEncryptionZonesOps.incr();
                break;
            }
            case "reencryptEncryptionZone": {
                this.reencryptEncryptionZoneOps.incr();
                break;
            }
            case "listReencryptionStatus": {
                this.listReencryptionStatusOps.incr();
                break;
            }
            case "setXAttr": {
                this.setXAttrOps.incr();
                break;
            }
            case "getXAttrs": {
                this.getXAttrsOps.incr();
                break;
            }
            case "listXAttrs": {
                this.listXAttrsOps.incr();
                break;
            }
            case "removeXAttr": {
                this.removeXAttrsOps.incr();
                break;
            }
            case "checkAccess": {
                this.checkAccessOps.incr();
                break;
            }
            case "getCurrentEditLogTxid": {
                this.getCurrentEditLogTxidOps.incr();
                break;
            }
            case "getEditsFromTxid": {
                this.getEditsFromTxidOps.incr();
                break;
            }
            case "getDataEncryptionKey": {
                this.getDataEncryptionKeyOps.incr();
                break;
            }
            case "createSnapshot": {
                this.createSnapshotOps.incr();
                break;
            }
            case "deleteSnapshot": {
                this.deleteSnapshotOps.incr();
                break;
            }
            case "setQuota": {
                this.setQuotaOps.incr();
                break;
            }
            case "getQuotaUsage": {
                this.getQuotaUsageOps.incr();
                break;
            }
            case "reportBadBlocks": {
                this.reportBadBlocksOps.incr();
                break;
            }
            case "unsetStoragePolicy": {
                this.unsetStoragePolicyOps.incr();
                break;
            }
            case "getStoragePolicy": {
                this.getStoragePolicyOps.incr();
                break;
            }
            case "getErasureCodingPolicies": {
                this.getErasureCodingPoliciesOps.incr();
                break;
            }
            case "getErasureCodingCodecs": {
                this.getErasureCodingCodecsOps.incr();
                break;
            }
            case "addErasureCodingPolicies": {
                this.addErasureCodingPoliciesOps.incr();
                break;
            }
            case "removeErasureCodingPolicy": {
                this.removeErasureCodingPolicyOps.incr();
                break;
            }
            case "disableErasureCodingPolicy": {
                this.disableErasureCodingPolicyOps.incr();
                break;
            }
            case "enableErasureCodingPolicy": {
                this.enableErasureCodingPolicyOps.incr();
                break;
            }
            case "getErasureCodingPolicy": {
                this.getErasureCodingPolicyOps.incr();
                break;
            }
            case "setErasureCodingPolicy": {
                this.setErasureCodingPolicyOps.incr();
                break;
            }
            case "unsetErasureCodingPolicy": {
                this.unsetErasureCodingPolicyOps.incr();
                break;
            }
            case "getECTopologyResultForPolicies": {
                this.getECTopologyResultForPoliciesOps.incr();
                break;
            }
            case "getECBlockGroupStats": {
                this.getECBlockGroupStatsOps.incr();
                break;
            }
            case "getReplicatedBlockStats": {
                this.getReplicatedBlockStatsOps.incr();
                break;
            }
            case "listOpenFiles": {
                this.listOpenFilesOps.incr();
                break;
            }
            case "msync": {
                this.msyncOps.incr();
                break;
            }
            case "satisfyStoragePolicy": {
                this.satisfyStoragePolicyOps.incr();
                break;
            }
            case "getHAServiceState": {
                this.getHAServiceStateOps.incr();
                break;
            }
            case "getSlowDatanodeReport": {
                this.getSlowDatanodeReportOps.incr();
                break;
            }
            default: {
                this.otherOps.incr();
            }
        }
    }

    public void incInvokedConcurrent(Method method) {
        switch (method.getName()) {
            case "setReplication": {
                this.concurrentSetReplicationOps.incr();
                break;
            }
            case "setPermission": {
                this.concurrentSetPermissionOps.incr();
                break;
            }
            case "setOwner": {
                this.concurrentSetOwnerOps.incr();
                break;
            }
            case "rename": {
                this.concurrentRenameOps.incr();
                break;
            }
            case "rename2": {
                this.concurrentRename2Ops.incr();
                break;
            }
            case "delete": {
                this.concurrentDeleteOps.incr();
                break;
            }
            case "mkdirs": {
                this.concurrentMkdirsOps.incr();
                break;
            }
            case "renewLease": {
                this.concurrentRenewLeaseOps.incr();
                break;
            }
            case "getListing": {
                this.concurrentGetListingOps.incr();
                break;
            }
            case "getFileInfo": {
                this.concurrentGetFileInfoOps.incr();
                break;
            }
            case "getStats": {
                this.concurrentGetStatsOps.incr();
                break;
            }
            case "getDatanodeReport": {
                this.concurrentGetDatanodeReportOps.incr();
                break;
            }
            case "setSafeMode": {
                this.concurrentSetSafeModeOps.incr();
                break;
            }
            case "restoreFailedStorage": {
                this.concurrentRestoreFailedStorageOps.incr();
                break;
            }
            case "saveNamespace": {
                this.concurrentSaveNamespaceOps.incr();
                break;
            }
            case "rollEdits": {
                this.concurrentRollEditsOps.incr();
                break;
            }
            case "refreshNodes": {
                this.concurrentRefreshNodesOps.incr();
                break;
            }
            case "finalizeUpgrade": {
                this.concurrentFinalizeUpgradeOps.incr();
                break;
            }
            case "rollingUpgrade": {
                this.concurrentRollingUpgradeOps.incr();
                break;
            }
            case "metaSave": {
                this.concurrentMetaSaveOps.incr();
                break;
            }
            case "listCorruptFileBlocks": {
                this.concurrentListCorruptFileBlocksOps.incr();
                break;
            }
            case "setBalancerBandwidth": {
                this.concurrentSetBalancerBandwidthOps.incr();
                break;
            }
            case "getContentSummary": {
                this.concurrentGetContentSummaryOps.incr();
                break;
            }
            case "modifyAclEntries": {
                this.concurrentModifyAclEntriesOps.incr();
                break;
            }
            case "removeAclEntries": {
                this.concurrentRemoveAclEntriesOps.incr();
                break;
            }
            case "removeDefaultAcl": {
                this.concurrentRemoveDefaultAclOps.incr();
                break;
            }
            case "removeAcl": {
                this.concurrentRemoveAclOps.incr();
                break;
            }
            case "setAcl": {
                this.concurrentSetAclOps.incr();
                break;
            }
            case "setXAttr": {
                this.concurrentSetXAttrOps.incr();
                break;
            }
            case "removeXAttr": {
                this.concurrentRemoveXAttrOps.incr();
                break;
            }
            case "getCurrentEditLogTxid": {
                this.concurrentGetCurrentEditLogTxidOps.incr();
                break;
            }
            case "getReplicatedBlockStats": {
                this.concurrentGetReplicatedBlockStatsOps.incr();
                break;
            }
            case "setQuota": {
                this.concurrentSetQuotaOps.incr();
                break;
            }
            case "getQuotaUsage": {
                this.concurrentGetQuotaUsageOps.incr();
                break;
            }
            case "getSlowDatanodeReport": {
                this.concurrentGetSlowDatanodeReportOps.incr();
                break;
            }
            default: {
                this.concurrentOtherOps.incr();
            }
        }
    }
}

