/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;

public interface MatrixDecomposition<N extends Number> {
    public static final Structure2D TYPICAL = new Structure2D(){

        @Override
        public long countColumns() {
            return 50L;
        }

        @Override
        public long countRows() {
            return 50L;
        }
    };

    public boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> var1);

    public boolean isComputed();

    @Deprecated
    public MatrixStore<N> reconstruct();

    public void reset();

    public static interface Values<N extends Number>
    extends MatrixDecomposition<N> {
        public boolean computeValuesOnly(Access2D.Collectable<N, ? super PhysicalStore<N>> var1);

        public boolean isOrdered();
    }

    public static interface Solver<N extends Number>
    extends MatrixDecomposition<N>,
    SolverTask<N>,
    InverterTask<N> {
        default public boolean compute(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
            return this.decompose(matrix) && this.isSolvable();
        }

        public MatrixStore<N> getInverse();

        public MatrixStore<N> getInverse(PhysicalStore<N> var1);

        public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> var1);

        public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> var1, PhysicalStore<N> var2);

        public boolean isSolvable();
    }

    public static interface Hermitian<N extends Number>
    extends MatrixDecomposition<N> {
        default public boolean checkAndCompute(MatrixStore<N> matrix) {
            this.reset();
            if (MatrixUtils.isHermitian(matrix)) {
                return this instanceof Solver ? ((Solver)((Object)this)).compute(matrix) : this.decompose(matrix);
            }
            return false;
        }
    }

    public static interface Factory<D extends MatrixDecomposition<?>> {
        default public D make() {
            return this.make(TYPICAL);
        }

        public D make(Structure2D var1);
    }

    public static interface EconomySize<N extends Number>
    extends MatrixDecomposition<N> {
        public boolean isFullSize();

        public void setFullSize(boolean var1);
    }

    public static interface Determinant<N extends Number>
    extends MatrixDecomposition<N>,
    DeterminantTask<N> {
        public N getDeterminant();
    }
}

