/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.ojalgo.matrix.store.DelegatingStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.Scalar;

final class AboveBelowStore<N extends Number>
extends DelegatingStore<N> {
    private final MatrixStore<N> myBelow;
    private final int mySplit;

    AboveBelowStore(MatrixStore<N> base, MatrixStore<N> below) {
        super(base, (int)(base.countRows() + below.countRows()), (int)base.countColumns());
        this.myBelow = below;
        this.mySplit = (int)base.countRows();
        if (base.countColumns() != below.countColumns()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public double doubleValue(long row, long col) {
        return row >= (long)this.mySplit ? this.myBelow.doubleValue(row - (long)this.mySplit, col) : this.getBase().doubleValue(row, col);
    }

    @Override
    public int firstInColumn(int col) {
        return this.getBase().firstInColumn(col);
    }

    @Override
    public int firstInRow(int row) {
        return row < this.mySplit ? this.getBase().firstInRow(row) : this.myBelow.firstInRow(row - this.mySplit);
    }

    @Override
    public N get(long row, long col) {
        return row >= (long)this.mySplit ? this.myBelow.get(row - (long)this.mySplit, col) : this.getBase().get(row, col);
    }

    @Override
    public int limitOfColumn(int col) {
        return this.mySplit + this.myBelow.limitOfColumn(col);
    }

    @Override
    public int limitOfRow(int row) {
        return row < this.mySplit ? this.getBase().limitOfRow(row) : this.myBelow.limitOfRow(row - this.mySplit);
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        Future<MatrixStore<N>> tmpBaseFuture = this.executeMultiplyRightOnBase(right);
        MatrixStore<MatrixStore<N>> tmpLower = this.myBelow.multiply(right);
        try {
            return new AboveBelowStore<MatrixStore<N>>(tmpBaseFuture.get(), tmpLower);
        }
        catch (InterruptedException | ExecutionException ex) {
            return null;
        }
    }

    @Override
    public void supplyTo(ElementsConsumer<N> receiver) {
        this.getBase().supplyTo(receiver.regionByLimits(this.mySplit, this.getColDim()));
        this.myBelow.supplyTo(receiver.regionByOffsets(this.mySplit, 0));
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return row >= (long)this.mySplit ? this.myBelow.toScalar(row - (long)this.mySplit, column) : this.getBase().toScalar(row, column);
    }

    @Override
    protected void addNonzerosTo(ElementsConsumer<N> consumer) {
        this.supplyTo(consumer);
    }
}

