/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.fluent;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.hc.client5.http.classic.methods.ClassicHttpRequests;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.fluent.Executor;
import org.apache.hc.client5.http.fluent.Response;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URLEncodedUtils;
import org.apache.hc.core5.util.Timeout;

public class Request {
    public static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final Locale DATE_LOCALE = Locale.US;
    public static final TimeZone TIME_ZONE = TimeZone.getTimeZone("GMT");
    private final ClassicHttpRequest request;
    private Boolean useExpectContinue;
    private Timeout connectTimeout;
    private Timeout responseTimeout;
    private HttpHost proxy;
    private SimpleDateFormat dateFormatter;

    public static Request create(Method method, URI uri) {
        return new Request((ClassicHttpRequest)new HttpUriRequestBase(method.name(), uri));
    }

    public static Request create(String methodName, String uri) {
        return new Request((ClassicHttpRequest)new HttpUriRequestBase(methodName, URI.create(uri)));
    }

    public static Request create(String methodName, URI uri) {
        return new Request((ClassicHttpRequest)new HttpUriRequestBase(methodName, uri));
    }

    public static Request get(URI uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.get((URI)uri));
    }

    public static Request get(String uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.get((String)uri));
    }

    public static Request head(URI uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.head((URI)uri));
    }

    public static Request head(String uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.head((String)uri));
    }

    public static Request post(URI uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.post((URI)uri));
    }

    public static Request post(String uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.post((String)uri));
    }

    public static Request patch(URI uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.patch((URI)uri));
    }

    public static Request patch(String uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.patch((String)uri));
    }

    public static Request put(URI uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.put((URI)uri));
    }

    public static Request put(String uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.put((String)uri));
    }

    public static Request trace(URI uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.trace((URI)uri));
    }

    public static Request trace(String uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.trace((String)uri));
    }

    public static Request delete(URI uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.delete((URI)uri));
    }

    public static Request delete(String uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.delete((String)uri));
    }

    public static Request options(URI uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.options((URI)uri));
    }

    public static Request options(String uri) {
        return new Request((ClassicHttpRequest)ClassicHttpRequests.options((String)uri));
    }

    Request(ClassicHttpRequest request) {
        this.request = request;
    }

    ClassicHttpResponse internalExecute(CloseableHttpClient client, HttpClientContext localContext) throws IOException {
        RequestConfig.Builder builder = client instanceof Configurable ? RequestConfig.copy((RequestConfig)((Configurable)client).getConfig()) : RequestConfig.custom();
        if (this.useExpectContinue != null) {
            builder.setExpectContinueEnabled(this.useExpectContinue.booleanValue());
        }
        if (this.connectTimeout != null) {
            builder.setConnectTimeout(this.connectTimeout);
        }
        if (this.responseTimeout != null) {
            builder.setResponseTimeout(this.responseTimeout);
        }
        if (this.proxy != null) {
            builder.setProxy(this.proxy);
        }
        RequestConfig config = builder.build();
        localContext.setRequestConfig(config);
        return client.execute(this.request, (HttpContext)localContext);
    }

    public Response execute() throws IOException {
        return this.execute(Executor.CLIENT);
    }

    public Response execute(CloseableHttpClient client) throws IOException {
        return new Response(this.internalExecute(client, HttpClientContext.create()));
    }

    public Request addHeader(Header header) {
        this.request.addHeader(header);
        return this;
    }

    public Request setHeader(Header header) {
        this.request.setHeader(header);
        return this;
    }

    public Request addHeader(String name, String value) {
        this.request.addHeader(name, (Object)value);
        return this;
    }

    public Request setHeader(String name, String value) {
        this.request.setHeader(name, (Object)value);
        return this;
    }

    public Request removeHeader(Header header) {
        this.request.removeHeader(header);
        return this;
    }

    public Request removeHeaders(String name) {
        this.request.removeHeaders(name);
        return this;
    }

    public Request setHeaders(Header ... headers) {
        this.request.setHeaders(headers);
        return this;
    }

    public Request setCacheControl(String cacheControl) {
        this.request.setHeader("Cache-Control", (Object)cacheControl);
        return this;
    }

    private SimpleDateFormat getDateFormat() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat(DATE_FORMAT, DATE_LOCALE);
            this.dateFormatter.setTimeZone(TIME_ZONE);
        }
        return this.dateFormatter;
    }

    ClassicHttpRequest getRequest() {
        return this.request;
    }

    public Request setDate(Date date) {
        this.request.setHeader("Date", (Object)this.getDateFormat().format(date));
        return this;
    }

    public Request setIfModifiedSince(Date date) {
        this.request.setHeader("If-Modified-Since", (Object)this.getDateFormat().format(date));
        return this;
    }

    public Request setIfUnmodifiedSince(Date date) {
        this.request.setHeader("If-Unmodified-Since", (Object)this.getDateFormat().format(date));
        return this;
    }

    public Request version(HttpVersion version) {
        this.request.setVersion((ProtocolVersion)version);
        return this;
    }

    public Request useExpectContinue() {
        this.useExpectContinue = Boolean.TRUE;
        return this;
    }

    public Request userAgent(String agent) {
        this.request.setHeader("User-Agent", (Object)agent);
        return this;
    }

    public Request connectTimeout(Timeout timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public Request responseTimeout(Timeout timeout) {
        this.responseTimeout = timeout;
        return this;
    }

    public Request viaProxy(HttpHost proxy) {
        this.proxy = proxy;
        return this;
    }

    public Request viaProxy(String proxy) {
        try {
            this.proxy = HttpHost.create((String)proxy);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid host");
        }
        return this;
    }

    public Request body(HttpEntity entity) {
        this.request.setEntity(entity);
        return this;
    }

    public Request bodyForm(Iterable<? extends NameValuePair> formParams, Charset charset) {
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        for (NameValuePair nameValuePair : formParams) {
            paramList.add(nameValuePair);
        }
        ContentType contentType = charset != null ? ContentType.APPLICATION_FORM_URLENCODED.withCharset(charset) : ContentType.APPLICATION_FORM_URLENCODED;
        String string = URLEncodedUtils.format(paramList, (Charset)contentType.getCharset());
        return this.bodyString(string, contentType);
    }

    public Request bodyForm(Iterable<? extends NameValuePair> formParams) {
        return this.bodyForm(formParams, StandardCharsets.ISO_8859_1);
    }

    public Request bodyForm(NameValuePair ... formParams) {
        return this.bodyForm(Arrays.asList(formParams), StandardCharsets.ISO_8859_1);
    }

    public Request bodyString(String s, ContentType contentType) {
        Charset charset = contentType != null ? contentType.getCharset() : null;
        byte[] raw = charset != null ? s.getBytes(charset) : s.getBytes();
        return this.body((HttpEntity)new ByteArrayEntity(raw, contentType));
    }

    public Request bodyFile(File file, ContentType contentType) {
        return this.body((HttpEntity)new FileEntity(file, contentType));
    }

    public Request bodyByteArray(byte[] b) {
        return this.body((HttpEntity)new ByteArrayEntity(b, null));
    }

    public Request bodyByteArray(byte[] b, ContentType contentType) {
        return this.body((HttpEntity)new ByteArrayEntity(b, contentType));
    }

    public Request bodyByteArray(byte[] b, int off, int len) {
        return this.body((HttpEntity)new ByteArrayEntity(b, off, len, null));
    }

    public Request bodyByteArray(byte[] b, int off, int len, ContentType contentType) {
        return this.body((HttpEntity)new ByteArrayEntity(b, off, len, contentType));
    }

    public Request bodyStream(InputStream inStream) {
        return this.body((HttpEntity)new InputStreamEntity(inStream, -1L, null));
    }

    public Request bodyStream(InputStream inStream, ContentType contentType) {
        return this.body((HttpEntity)new InputStreamEntity(inStream, -1L, contentType));
    }

    public String toString() {
        return this.request.toString();
    }
}

