/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.recovery.restart;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.recovery.restart.RestartPartitionsCallInput;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.RecoveryApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.RestartPartitionsRequest;

@Singleton
public class RestartPartitionsCall
implements Call<RestartPartitionsCallInput, String> {
    private final ApiClientFactory clientFactory;

    public RestartPartitionsCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<String> execute(RestartPartitionsCallInput input) {
        RecoveryApi client = new RecoveryApi(this.clientFactory.getClient(input.clusterUrl()));
        RestartPartitionsRequest command = new RestartPartitionsRequest();
        command.setPartitionIds(input.partitionIds());
        command.setNodeNames(input.nodeNames());
        command.setTableName(input.tableName());
        command.setZoneName(input.zoneName());
        try {
            client.restartPartitions(command);
            return DefaultCallOutput.success("Successfully restarted partitions.");
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }
}

