/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.connect;

import jakarta.inject.Inject;
import java.net.URL;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.cli.ReplManager;
import org.apache.ignite.internal.cli.call.connect.ConnectCallInput;
import org.apache.ignite.internal.cli.call.connect.ConnectWizardCall;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.connect.ConnectOptions;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.converters.RestEndpointUrlConverter;
import picocli.CommandLine;

@CommandLine.Command(name="connect", description={"Connects to Ignite 3 node"})
public class ConnectCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Parameters(description={"URL of a node that will be used as a communication endpoint. It can be any node URL. If not set, then the default URL from the profile settings will be used"}, descriptionKey="ignite.cluster-endpoint-url", converter={RestEndpointUrlConverter.class})
    private URL nodeUrl;
    @CommandLine.ArgGroup(exclusive=false)
    private ConnectOptions connectOptions;
    @Inject
    private ConnectWizardCall connectCall;
    @Inject
    private ReplManager replManager;

    @Override
    public Integer call() {
        this.replManager.subscribe();
        int exitCode = this.runPipeline(CallExecutionPipeline.builder(this.connectCall).inputProvider(this::connectCallInput));
        if (exitCode == 0) {
            this.replManager.startReplMode();
        }
        return exitCode;
    }

    private ConnectCallInput connectCallInput() {
        return ConnectCallInput.builder().url(this.nodeUrl.toString()).username(this.connectOptions != null ? this.connectOptions.username() : null).password(this.connectOptions != null ? this.connectOptions.password() : null).checkClusterInit(true).build();
    }
}

