/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.flow.builder;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallInput;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.flow.DefaultFlowable;
import org.apache.ignite.internal.cli.core.flow.Flow;
import org.apache.ignite.internal.cli.core.flow.Flowable;
import org.apache.ignite.internal.cli.core.flow.builder.FlowBuilder;
import org.apache.ignite.internal.cli.core.flow.builder.FlowBuilderImpl;
import org.apache.ignite.internal.cli.core.flow.question.AcceptedQuestionAnswer;
import org.apache.ignite.internal.cli.core.flow.question.InterruptQuestionAnswer;
import org.apache.ignite.internal.cli.core.flow.question.QuestionAnswer;
import org.apache.ignite.internal.cli.core.flow.question.QuestionAskerFactory;
import org.apache.ignite.internal.cli.core.style.component.QuestionUiComponent;

public final class Flows {
    private Flows() {
    }

    public static <I extends CallInput, T> Flow<I, T> fromCall(Call<I, T> call) {
        return flowable -> {
            if (flowable.hasError()) {
                return Flowable.failure(flowable.errorCause());
            }
            return Flows.fromOutput(call.execute((CallInput)flowable.value()));
        };
    }

    public static <I, CIT extends CallInput, T> Flow<I, T> fromCall(Call<CIT, T> call, Function<I, CIT> mapper) {
        return flowable -> {
            if (flowable.hasError()) {
                return Flowable.failure(flowable.errorCause());
            }
            return Flows.fromOutput(call.execute((CallInput)mapper.apply(flowable.value())));
        };
    }

    public static <T> FlowBuilder<Void, T> from(T value) {
        return new FlowBuilderImpl(input -> Flowable.success(value));
    }

    public static <I, O> FlowBuilder<I, O> from(Function<I, O> function) {
        return new FlowBuilderImpl<I, O>(Flows.mono(function));
    }

    public static <I, O> Flow<I, O> mono(Function<I, O> function) {
        return input -> {
            if (input.hasError()) {
                return Flowable.failure(input.errorCause());
            }
            return Flowable.process(() -> function.apply(input.value()));
        };
    }

    private static <T> Flowable<T> fromOutput(CallOutput<T> output) {
        return DefaultFlowable.builder().body(output.body()).cause(output.errorCause()).build();
    }

    public static <I, O> FlowBuilder<I, O> question(String question, List<QuestionAnswer<I, O>> answers) {
        return new FlowBuilderImpl<I, O>(Flows.questionFlow(question, answers));
    }

    public static <I, O> FlowBuilder<I, O> acceptQuestion(String question, Supplier<O> onAccept) {
        return Flows.question(question, List.of(new AcceptedQuestionAnswer<Object, Object>((a, i) -> onAccept.get()), new InterruptQuestionAnswer()));
    }

    public static <I, O> FlowBuilder<I, O> acceptQuestion(QuestionUiComponent question, Supplier<O> onAccept) {
        return Flows.acceptQuestion(question.render(), onAccept);
    }

    public static <I, O> FlowBuilder<I, O> acceptQuestion(QuestionUiComponent question, Function<I, O> onAccept) {
        return Flows.question(question.render(), List.of(new AcceptedQuestionAnswer<Object, Object>((a, i) -> onAccept.apply(i)), new InterruptQuestionAnswer()));
    }

    public static <I, O> Flow<I, O> questionFlow(String question, List<QuestionAnswer<I, O>> answers) {
        return input -> Flowable.success(QuestionAskerFactory.newQuestionAsker().askQuestion(question, input.value(), answers));
    }

    public static <I> Flow<I, I> acceptQuestionFlow(QuestionUiComponent question, Consumer<I> onAccept) {
        return Flows.questionFlow(question.render(), List.of(new AcceptedQuestionAnswer<Object, Object>((a, i) -> {
            onAccept.accept(i);
            return i;
        }), new QuestionAnswer<Object, Object>(s -> true, (a, i) -> i)));
    }

    public static <I> FlowBuilder<I, I> identity() {
        return new FlowBuilderImpl(input -> Flowable.success(input.value()));
    }
}

