/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.query.UnSupportedFillTypeException;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimeFillPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByEngineDataSet;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.LinearFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.db.query.executor.fill.ValueFill;
import org.apache.iotdb.db.query.udf.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByFillDataSet
extends GroupByEngineDataSet {
    private static final Logger logger = LoggerFactory.getLogger(GroupByFillDataSet.class);
    private QueryDataSet dataSet;
    private final Map<TSDataType, IFill> fillTypes;
    private final IFill singleFill;
    private final List<String> aggregations;
    private boolean[] unsupportedFillMethod;
    private final TSDataType[] resultDataType;
    private long[] previousTimes;
    private Object[] previousValues;
    private int[] nextIndices;
    private List<ElasticSerializableTVList> nextTVLists;
    private final float groupByFillCacheSizeInMB = IoTDBDescriptor.getInstance().getConfig().getGroupByFillCacheSizeInMB();

    public GroupByFillDataSet(QueryContext context, GroupByTimeFillPlan groupByTimeFillPlan) throws QueryProcessException {
        super(context, groupByTimeFillPlan);
        this.aggregations = groupByTimeFillPlan.getDeduplicatedAggregations();
        this.fillTypes = groupByTimeFillPlan.getFillType();
        this.singleFill = groupByTimeFillPlan.getSingleFill();
        this.resultDataType = new TSDataType[this.aggregations.size()];
        this.initArrays(context);
    }

    private void initArrays(QueryContext context) throws QueryProcessException {
        int i;
        for (i = 0; i < this.aggregations.size(); ++i) {
            this.resultDataType[i] = TypeInferenceUtils.getAggrDataType(this.aggregations.get(i), (TSDataType)this.dataTypes.get(i));
        }
        this.previousTimes = new long[this.aggregations.size()];
        this.previousValues = new Object[this.aggregations.size()];
        this.nextIndices = new int[this.aggregations.size()];
        this.unsupportedFillMethod = new boolean[this.aggregations.size()];
        Arrays.fill(this.previousTimes, Long.MAX_VALUE);
        Arrays.fill(this.previousValues, null);
        Arrays.fill(this.nextIndices, 0);
        Arrays.fill(this.unsupportedFillMethod, false);
        this.nextTVLists = new ArrayList<ElasticSerializableTVList>(this.aggregations.size());
        for (i = 0; i < this.aggregations.size(); ++i) {
            this.nextTVLists.add(ElasticSerializableTVList.newElasticSerializableTVList(this.resultDataType[i], context.getQueryId(), this.groupByFillCacheSizeInMB, 2));
        }
    }

    public void setDataSet(QueryDataSet dataSet) {
        this.dataSet = dataSet;
    }

    public void initCache() throws QueryProcessException {
        BitSet cacheSet = new BitSet(this.aggregations.size());
        try {
            while (cacheSet.cardinality() < this.aggregations.size() && this.dataSet.hasNextWithoutConstraint()) {
                RowRecord record = this.dataSet.nextWithoutConstraint();
                long timestamp = record.getTimestamp();
                List fields = record.getFields();
                for (int i = 0; i < fields.size(); ++i) {
                    Field field = (Field)fields.get(i);
                    if (field == null) continue;
                    if (this.ascending && timestamp < this.startTime) {
                        this.previousTimes[i] = timestamp;
                        this.previousValues[i] = field.getObjectValue(this.resultDataType[i]);
                        continue;
                    }
                    if (!this.ascending && timestamp >= this.endTime) {
                        this.previousTimes[i] = timestamp;
                        this.previousValues[i] = field.getObjectValue(this.resultDataType[i]);
                        continue;
                    }
                    this.nextTVLists.get(i).put(timestamp, field.getObjectValue(this.resultDataType[i]));
                    cacheSet.set(i);
                }
            }
        }
        catch (IOException e) {
            logger.error("there has an exception while init: ", (Throwable)e);
            throw new QueryProcessException(e.getMessage());
        }
    }

    @Override
    public RowRecord nextWithoutConstraint() throws IOException {
        RowRecord record;
        long curTimestamp;
        if (!this.hasCachedTimeInterval) {
            throw new IOException("need to call hasNext() before calling next() in GroupByFillDataSet.");
        }
        this.hasCachedTimeInterval = false;
        if (this.leftCRightO) {
            curTimestamp = this.curStartTime;
            record = new RowRecord(this.curStartTime);
        } else {
            curTimestamp = this.curEndTime - 1L;
            record = new RowRecord(this.curEndTime - 1L);
        }
        for (int i = 0; i < this.aggregations.size(); ++i) {
            if (this.nextTVLists.get(i).size() == this.nextIndices[i]) {
                this.fillRecord(i, record);
                continue;
            }
            long cacheTime = this.nextTVLists.get(i).getTime(this.nextIndices[i]);
            if (cacheTime == curTimestamp) {
                record.addField(this.getNextCacheValue(i), this.resultDataType[i]);
                continue;
            }
            this.fillRecord(i, record);
        }
        try {
            this.slideCache(record.getTimestamp());
        }
        catch (QueryProcessException e) {
            logger.error("group by fill has an exception while sliding: ", (Throwable)e);
        }
        return record;
    }

    private void fillRecord(int index, RowRecord record) throws IOException {
        Pair afterPair;
        Pair beforePair;
        if (this.unsupportedFillMethod[index]) {
            record.addField(null);
            return;
        }
        IFill fill = this.fillTypes != null ? this.fillTypes.get(this.resultDataType[index]) : this.singleFill;
        if (fill == null) {
            record.addField(null);
            return;
        }
        if (this.ascending) {
            beforePair = this.previousValues[index] != null ? new Pair((Object)this.previousTimes[index], this.previousValues[index]) : null;
            afterPair = this.nextIndices[index] < this.nextTVLists.get(index).size() ? new Pair((Object)this.nextTVLists.get(index).getTime(this.nextIndices[index]), this.getNextCacheValue(index)) : null;
        } else {
            beforePair = this.nextIndices[index] < this.nextTVLists.get(index).size() ? new Pair((Object)this.nextTVLists.get(index).getTime(this.nextIndices[index]), this.getNextCacheValue(index)) : null;
            afterPair = this.previousValues[index] != null ? new Pair((Object)this.previousTimes[index], this.previousValues[index]) : null;
        }
        if (fill instanceof PreviousFill) {
            if (beforePair != null && (fill.getBeforeRange() == -1L || fill.insideBeforeRange((Long)beforePair.left, record.getTimestamp())) && (!((PreviousFill)fill).isUntilLast() || afterPair != null && (Long)afterPair.left < this.endTime)) {
                record.addField(beforePair.right, this.resultDataType[index]);
            } else {
                record.addField(null);
            }
        } else if (fill instanceof LinearFill) {
            LinearFill linearFill = new LinearFill();
            if (beforePair != null && afterPair != null && (fill.getBeforeRange() == -1L || fill.insideBeforeRange((Long)beforePair.left, record.getTimestamp())) && (fill.getAfterRange() == -1L || fill.insideAfterRange((Long)afterPair.left, record.getTimestamp()))) {
                try {
                    TimeValuePair filledPair = linearFill.averageWithTimeAndDataType(new TimeValuePair(((Long)beforePair.left).longValue(), TsPrimitiveType.getByType((TSDataType)this.resultDataType[index], (Object)beforePair.right)), new TimeValuePair(((Long)afterPair.left).longValue(), TsPrimitiveType.getByType((TSDataType)this.resultDataType[index], (Object)afterPair.right)), record.getTimestamp(), this.resultDataType[index]);
                    record.addField(filledPair.getValue().getValue(), this.resultDataType[index]);
                }
                catch (UnSupportedFillTypeException ignore) {
                    record.addField(null);
                    this.unsupportedFillMethod[index] = true;
                    logger.info("Linear fill doesn't support the " + index + "-th column in SQL.");
                }
            } else {
                record.addField(null);
            }
        } else if (fill instanceof ValueFill) {
            try {
                TimeValuePair filledPair = fill.getFillResult();
                if (filledPair == null) {
                    filledPair = ((ValueFill)fill).getSpecifiedFillResult(this.resultDataType[index]);
                }
                record.addField(filledPair.getValue().getValue(), this.resultDataType[index]);
            }
            catch (NumberFormatException ignore) {
                record.addField(null);
                this.unsupportedFillMethod[index] = true;
                logger.info("Value fill doesn't support the " + index + "-th column in SQL.");
            }
            catch (StorageEngineException | QueryProcessException e) {
                throw new IOException(e);
            }
        }
    }

    private Object getNextCacheValue(int index) throws IOException {
        switch (this.resultDataType[index]) {
            case INT32: {
                return this.nextTVLists.get(index).getInt(this.nextIndices[index]);
            }
            case INT64: {
                return this.nextTVLists.get(index).getLong(this.nextIndices[index]);
            }
            case FLOAT: {
                return Float.valueOf(this.nextTVLists.get(index).getFloat(this.nextIndices[index]));
            }
            case DOUBLE: {
                return this.nextTVLists.get(index).getDouble(this.nextIndices[index]);
            }
            case BOOLEAN: {
                return this.nextTVLists.get(index).getBoolean(this.nextIndices[index]);
            }
            case TEXT: {
                return this.nextTVLists.get(index).getBinary(this.nextIndices[index]);
            }
        }
        throw new IOException("unknown data type!");
    }

    private void slideCache(long curTimestamp) throws IOException, QueryProcessException {
        BitSet slideSet = new BitSet(this.aggregations.size());
        for (int i = 0; i < this.aggregations.size(); ++i) {
            if (this.nextTVLists.get(i).size() == this.nextIndices[i] || this.nextTVLists.get(i).getTime(this.nextIndices[i]) != curTimestamp) continue;
            this.previousTimes[i] = curTimestamp;
            this.previousValues[i] = this.getNextCacheValue(i);
            int n = i;
            this.nextIndices[n] = this.nextIndices[n] + 1;
            this.nextTVLists.get(i).setEvictionUpperBound(this.nextIndices[i]);
            slideSet.set(i);
        }
        while (slideSet.cardinality() > 0 && this.dataSet.hasNextWithoutConstraint()) {
            RowRecord record = this.dataSet.nextWithoutConstraint();
            long timestamp = record.getTimestamp();
            List fields = record.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                Field field = (Field)fields.get(i);
                if (field == null) continue;
                this.nextTVLists.get(i).put(timestamp, field.getObjectValue(this.resultDataType[i]));
                slideSet.clear(i);
            }
        }
    }
}

