/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server;

import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.query.manage.ClusterSessionManager;
import org.apache.iotdb.cluster.server.ClusterRPCServiceMBean;
import org.apache.iotdb.cluster.server.ClusterTSServiceImpl;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.runtime.RPCServiceException;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.service.thrift.ProcessorWithMetrics;
import org.apache.iotdb.db.service.thrift.ThriftService;
import org.apache.iotdb.db.service.thrift.ThriftServiceThread;
import org.apache.iotdb.db.service.thrift.handler.RPCServiceThriftHandler;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.thrift.server.TServerEventHandler;

public class ClusterRPCService
extends ThriftService
implements ClusterRPCServiceMBean {
    private ClusterTSServiceImpl impl;

    private ClusterRPCService() {
    }

    public ThriftService getImplementation() {
        return ClusterRPCServiceHolder.INSTANCE;
    }

    public ServiceType getID() {
        return ServiceType.CLUSTER_RPC_SERVICE;
    }

    public void initSyncedServiceImpl(Object serviceImpl) {
        this.impl = (ClusterTSServiceImpl)((Object)serviceImpl);
        super.initSyncedServiceImpl(serviceImpl);
    }

    public void initTProcessor() throws InstantiationException {
        if (this.impl == null) {
            throw new InstantiationException("ClusterTSServiceImpl is null");
        }
        this.processor = MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric() != false ? new ProcessorWithMetrics((TSIService.Iface)this.impl) : new TSIService.Processor((TSIService.Iface)this.impl);
    }

    public void initThriftServiceThread() throws IllegalAccessException {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        try {
            this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.CLUSTER_RPC_CLIENT.getName(), this.getBindIP(), this.getBindPort(), config.getRpcMaxConcurrentClientNum(), config.getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new RPCServiceThriftHandler(this.impl){

                protected SessionManager getSessionManager() {
                    return ClusterSessionManager.getInstance();
                }
            }, IoTDBDescriptor.getInstance().getConfig().isRpcThriftCompressionEnable());
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(ThreadName.CLUSTER_RPC_SERVICE.getName());
    }

    public String getBindIP() {
        return IoTDBDescriptor.getInstance().getConfig().getRpcAddress();
    }

    public int getBindPort() {
        return ClusterDescriptor.getInstance().getConfig().getClusterRpcPort();
    }

    @Override
    public int getRPCPort() {
        return this.getBindPort();
    }

    public static ClusterRPCService getInstance() {
        return ClusterRPCServiceHolder.INSTANCE;
    }

    private static class ClusterRPCServiceHolder {
        private static final ClusterRPCService INSTANCE = new ClusterRPCService();

        private ClusterRPCServiceHolder() {
        }
    }
}

