/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.String;

import java.io.IOException;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.utils.Binary;

public class UDTFStrLocate
implements UDTF {
    private String target;
    private boolean reverse;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.TEXT, Type.STRING}).validate(target -> ((String)target).length() > 0, "target should not be empty", (Object)validator.getParameters().getString("target"));
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        this.target = parameters.getString("target");
        this.reverse = parameters.getBooleanOrDefault("reverse", false);
        configurations.setAccessStrategy((AccessStrategy)new MappableRowByRowAccessStrategy()).setOutputDataType(Type.INT32);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        collector.putInt(row.getTime(), this.reverse ? row.getString(0).lastIndexOf(this.target) : row.getString(0).indexOf(this.target));
    }

    public Object transform(Row row) throws IOException {
        if (row.isNull(0)) {
            return null;
        }
        return this.reverse ? row.getString(0).lastIndexOf(this.target) : row.getString(0).indexOf(this.target);
    }

    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        Binary[] inputs = columns[0].getBinaries();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            String str = inputs[i].getStringValue(TSFileConfig.STRING_CHARSET);
            int res = this.reverse ? str.lastIndexOf(this.target) : str.indexOf(this.target);
            builder.writeInt(res);
        }
    }
}

