/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.DataNodeEndPoints;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.QueryIdGenerator;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.DataNodeSchemaLockManager;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.execution.QueryExecution;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigExecution;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.TreeModelPlanner;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Coordinator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Coordinator.class);
    private static final int COORDINATOR_SCHEDULED_EXECUTOR_SIZE = 10;
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final Logger SLOW_SQL_LOGGER = LoggerFactory.getLogger((String)"SLOW_SQL");
    private static final Logger SAMPLED_QUERIES_LOGGER = LoggerFactory.getLogger((String)"SAMPLED_QUERIES");
    private static final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> SYNC_INTERNAL_SERVICE_CLIENT_MANAGER = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.SyncDataNodeInternalServiceClientPoolFactory());
    private static final IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> ASYNC_INTERNAL_SERVICE_CLIENT_MANAGER = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.AsyncDataNodeInternalServiceClientPoolFactory());
    private final ExecutorService executor;
    private final ExecutorService writeOperationExecutor;
    private final ScheduledExecutorService scheduledExecutor;
    private final QueryIdGenerator queryIdGenerator = new QueryIdGenerator(IoTDBDescriptor.getInstance().getConfig().getDataNodeId());
    private static final Coordinator INSTANCE = new Coordinator();
    private final ConcurrentHashMap<Long, IQueryExecution> queryExecutionMap = new ConcurrentHashMap();

    private Coordinator() {
        this.executor = this.getQueryExecutor();
        this.writeOperationExecutor = this.getWriteExecutor();
        this.scheduledExecutor = this.getScheduledExecutor();
    }

    private ExecutionResult execution(long queryId, SessionInfo session, String sql, boolean userQuery, BiFunction<MPPQueryContext, Long, IQueryExecution> iQueryExecutionFactory) {
        long startTime = System.currentTimeMillis();
        QueryId globalQueryId = this.queryIdGenerator.createNextQueryId();
        MPPQueryContext queryContext = null;
        try {
            SetThreadName queryName = new SetThreadName(globalQueryId.getId());
            try {
                if (sql != null && !sql.isEmpty()) {
                    LOGGER.debug("[QueryStart] sql: {}", (Object)sql);
                }
                queryContext = new MPPQueryContext(sql, globalQueryId, queryId, session, DataNodeEndPoints.LOCAL_HOST_DATA_BLOCK_ENDPOINT, DataNodeEndPoints.LOCAL_HOST_INTERNAL_ENDPOINT);
                queryContext.setUserQuery(userQuery);
                IQueryExecution execution = iQueryExecutionFactory.apply(queryContext, startTime);
                if (execution.isQuery()) {
                    this.queryExecutionMap.put(queryId, execution);
                } else {
                    queryContext.setTimeOut(Long.MAX_VALUE);
                }
                execution.start();
                ExecutionResult result = execution.getStatus();
                if (!execution.isQuery() && result.status != null && StatusUtils.needRetry((TSStatus)result.status)) {
                    result.status.setNeedRetry(true);
                }
                ExecutionResult executionResult = result;
                queryName.close();
                return executionResult;
            }
            catch (Throwable throwable) {
                try {
                    queryName.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (queryContext != null) {
                queryContext.releaseAllMemoryReservedForFrontEnd();
            }
            DataNodeSchemaLockManager.getInstance().releaseReadLock(queryContext);
        }
    }

    public ExecutionResult executeForTreeModel(Statement statement, long queryId, SessionInfo session, String sql, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        return this.executeForTreeModel(statement, queryId, session, sql, partitionFetcher, schemaFetcher, Long.MAX_VALUE, false);
    }

    public ExecutionResult executeForTreeModel(Statement statement, long queryId, SessionInfo session, String sql, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher, long timeOut, boolean userQuery) {
        return this.execution(queryId, session, sql, userQuery, (queryContext, startTime) -> this.createQueryExecutionForTreeModel(statement, (MPPQueryContext)queryContext, partitionFetcher, schemaFetcher, timeOut > 0L ? timeOut : CONFIG.getQueryTimeoutThreshold(), (long)startTime));
    }

    private IQueryExecution createQueryExecutionForTreeModel(Statement statement, MPPQueryContext queryContext, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher, long timeOut, long startTime) {
        queryContext.setTimeOut(timeOut);
        queryContext.setStartTime(startTime);
        if (statement instanceof IConfigStatement) {
            queryContext.setQueryType(((IConfigStatement)((Object)statement)).getQueryType());
            return new ConfigExecution(queryContext, statement.getType(), this.executor, statement.accept(new ConfigTaskVisitor(), queryContext));
        }
        TreeModelPlanner treeModelPlanner = new TreeModelPlanner(statement, this.executor, this.writeOperationExecutor, this.scheduledExecutor, partitionFetcher, schemaFetcher, SYNC_INTERNAL_SERVICE_CLIENT_MANAGER, ASYNC_INTERNAL_SERVICE_CLIENT_MANAGER);
        return new QueryExecution(treeModelPlanner, queryContext, this.executor);
    }

    public IQueryExecution getQueryExecution(Long queryId) {
        return this.queryExecutionMap.get(queryId);
    }

    public List<IQueryExecution> getAllQueryExecutions() {
        return new ArrayList<IQueryExecution>(this.queryExecutionMap.values());
    }

    public int getQueryExecutionMapSize() {
        return this.queryExecutionMap.size();
    }

    private ExecutorService getQueryExecutor() {
        int coordinatorReadExecutorSize = CONFIG.getCoordinatorReadExecutorSize();
        return IoTDBThreadPoolFactory.newFixedThreadPool((int)coordinatorReadExecutorSize, (String)ThreadName.MPP_COORDINATOR_EXECUTOR_POOL.getName());
    }

    private ExecutorService getWriteExecutor() {
        int coordinatorWriteExecutorSize = CONFIG.getCoordinatorWriteExecutorSize();
        return IoTDBThreadPoolFactory.newFixedThreadPool((int)coordinatorWriteExecutorSize, (String)ThreadName.MPP_COORDINATOR_WRITE_EXECUTOR.getName());
    }

    private ScheduledExecutorService getScheduledExecutor() {
        return IoTDBThreadPoolFactory.newScheduledThreadPool((int)10, (String)ThreadName.MPP_COORDINATOR_SCHEDULED_EXECUTOR.getName());
    }

    public QueryId createQueryId() {
        return this.queryIdGenerator.createNextQueryId();
    }

    public void cleanupQueryExecution(Long queryId, TBase<?, ?> nativeApiRequest, Throwable t) {
        IQueryExecution queryExecution = this.getQueryExecution(queryId);
        if (queryExecution != null) {
            try (SetThreadName threadName = new SetThreadName(queryExecution.getQueryId());){
                LOGGER.debug("[CleanUpQuery]]");
                queryExecution.stopAndCleanup(t);
                this.queryExecutionMap.remove(queryId);
                if (queryExecution.isQuery() && queryExecution.isUserQuery()) {
                    long costTime = queryExecution.getTotalExecutionTime();
                    if (costTime / 1000000L >= CONFIG.getSlowQueryThreshold()) {
                        SLOW_SQL_LOGGER.info("Cost: {} ms, {}", (Object)(costTime / 1000000L), (Object)CommonUtils.getContentOfRequest(nativeApiRequest, queryExecution));
                    }
                    if (t == null && COMMON_CONFIG.isEnableQuerySampling()) {
                        String queryRequest = CommonUtils.getContentOfRequest(nativeApiRequest, queryExecution);
                        if (COMMON_CONFIG.isQuerySamplingHasRateLimit()) {
                            if (COMMON_CONFIG.getQuerySamplingRateLimiter().tryAcquire(queryRequest.length())) {
                                SAMPLED_QUERIES_LOGGER.info(queryRequest);
                            }
                        } else {
                            SAMPLED_QUERIES_LOGGER.info(queryRequest);
                        }
                    }
                }
            }
        }
    }

    public void cleanupQueryExecution(Long queryId) {
        this.cleanupQueryExecution(queryId, null, null);
    }

    public IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> getInternalServiceClientManager() {
        return SYNC_INTERNAL_SERVICE_CLIENT_MANAGER;
    }

    public static Coordinator getInstance() {
        return INSTANCE;
    }

    public void recordExecutionTime(long queryId, long executionTime) {
        IQueryExecution queryExecution = this.getQueryExecution(queryId);
        if (queryExecution != null) {
            queryExecution.recordExecutionTime(executionTime);
        }
    }

    public long getTotalExecutionTime(long queryId) {
        IQueryExecution queryExecution = this.getQueryExecution(queryId);
        if (queryExecution != null) {
            return queryExecution.getTotalExecutionTime();
        }
        return -1L;
    }
}

